# Generated by Django 2.2.13 on 2020-07-14 17:02

from django.db import migrations


TASK_STATEMENTS = [
    {
        "action": ["list"],
        "principal": "authenticated",
        "effect": "allow"
    }, {
        "action": ["retrieve"],
        "principal": "authenticated",
        "effect": "allow",
        "condition": "has_model_or_obj_perms:core.view_task"
    }, {
        "action": ["destroy"],
        "principal": "authenticated",
        "effect": "allow",
        "condition": "has_model_or_obj_perms:core.delete_task"
    }, {
        "action": ["update", "partial_update"],
        "principal": "authenticated",
        "effect": "allow",
        "condition": "has_model_or_obj_perms:core.change_task"
    }
]


TASK_PERMISSIONS_ASSIGNMENT = [
    {
        "function": "add_for_object_creator",
        "parameters": None,
        "permissions": ["core.view_task", "core.change_task", "core.delete_task"]
    }
]


def populate_access_policy(apps, schema_editor):
    AccessPolicy = apps.get_model('core', 'AccessPolicy')
    AccessPolicy.objects.create(
        viewset_name="TaskViewSet",
        statements=TASK_STATEMENTS,
        permissions_assignment=TASK_PERMISSIONS_ASSIGNMENT
    )


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0041_accesspolicy'),
    ]

    operations = [
        migrations.RunPython(populate_access_policy, reverse_code=migrations.RunPython.noop, elidable=True),
    ]
