# Generated by Django 2.2.10 on 2020-02-19 20:40

from django.db import migrations, transaction
from django.db.models import F


def plus_one(apps, schema_editor):
    # re: https://pulp.plan.io/issues/6147
    with transaction.atomic():
        Repository = apps.get_model('core', 'Repository')
        Repository.objects.all().update(last_version=F('last_version') + 1)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0021_add_signing_service_foreign_key'),
    ]

    operations = [
        migrations.RunPython(plus_one),
        migrations.RenameField(
            model_name='repository',
            old_name='last_version',
            new_name='next_version',
        ),
    ]
