"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class ServerlessApp extends cdk.Construct {
    // readonly functionVersionArn: lambda.Version;
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.resource = new cdk.CfnResource(this, id, {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: props.applicationId,
                    SemanticVersion: props.semanticVersion,
                },
                Parameters: props.parameters,
            },
        });
        cdk.Stack.of(this).templateOptions.transforms = ['AWS::Serverless-2016-10-31'];
    }
}
exports.ServerlessApp = ServerlessApp;
_a = JSII_RTTI_SYMBOL_1;
ServerlessApp[_a] = { fqn: "cdk-cloudfront-plus.ServerlessApp", version: "0.3.141" };
//# sourceMappingURL=data:application/json;base64,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