"""
    Sample metadata API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 5.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sample_metadata.api_client import ApiClient, Endpoint as _Endpoint
from sample_metadata.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
    async_wrap
)
from sample_metadata.model.http_validation_error import HTTPValidationError
from sample_metadata.model.sequence_type import SequenceType


class SeqrApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_external_participant_id_to_internal_sample_id_async = async_wrap(self.get_external_participant_id_to_internal_sample_id)
        self.get_external_participant_id_to_internal_sample_id_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/participant/{project}/external-pid-to-internal-sample-id',
                'operation_id': 'get_external_participant_id_to_internal_sample_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'export_type',
                    'flip_columns',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'export_type':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'flip_columns':
                        (bool,),
                },
                'attribute_map': {
                    'project': 'project',
                    'export_type': 'export_type',
                    'flip_columns': 'flip_columns',
                },
                'location_map': {
                    'project': 'path',
                    'export_type': 'query',
                    'flip_columns': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_families_async = async_wrap(self.get_families)
        self.get_families_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/family/{project}/',
                'operation_id': 'get_families',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'participant_ids',
                    'sample_ids',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'participant_ids':
                        ([int],),
                    'sample_ids':
                        ([str],),
                },
                'attribute_map': {
                    'project': 'project',
                    'participant_ids': 'participant_ids',
                    'sample_ids': 'sample_ids',
                },
                'location_map': {
                    'project': 'path',
                    'participant_ids': 'query',
                    'sample_ids': 'query',
                },
                'collection_format_map': {
                    'participant_ids': 'multi',
                    'sample_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_individual_metadata_for_seqr_async = async_wrap(self.get_individual_metadata_for_seqr)
        self.get_individual_metadata_for_seqr_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/participant/{project}/individual-metadata-seqr',
                'operation_id': 'get_individual_metadata_for_seqr',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'export_type',
                    'external_participant_ids',
                    'replace_with_participant_external_ids',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'export_type':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'external_participant_ids':
                        ([str],),
                    'replace_with_participant_external_ids':
                        (bool,),
                },
                'attribute_map': {
                    'project': 'project',
                    'export_type': 'export_type',
                    'external_participant_ids': 'external_participant_ids',
                    'replace_with_participant_external_ids': 'replace_with_participant_external_ids',
                },
                'location_map': {
                    'project': 'path',
                    'export_type': 'query',
                    'external_participant_ids': 'query',
                    'replace_with_participant_external_ids': 'query',
                },
                'collection_format_map': {
                    'external_participant_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_pedigree_async = async_wrap(self.get_pedigree)
        self.get_pedigree_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/family/{project}/pedigree',
                'operation_id': 'get_pedigree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'internal_family_ids',
                    'export_type',
                    'replace_with_participant_external_ids',
                    'replace_with_family_external_ids',
                    'include_header',
                    'empty_participant_value',
                    'include_participants_not_in_families',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'internal_family_ids':
                        ([int],),
                    'export_type':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'replace_with_participant_external_ids':
                        (bool,),
                    'replace_with_family_external_ids':
                        (bool,),
                    'include_header':
                        (bool,),
                    'empty_participant_value':
                        (str,),
                    'include_participants_not_in_families':
                        (bool,),
                },
                'attribute_map': {
                    'project': 'project',
                    'internal_family_ids': 'internal_family_ids',
                    'export_type': 'export_type',
                    'replace_with_participant_external_ids': 'replace_with_participant_external_ids',
                    'replace_with_family_external_ids': 'replace_with_family_external_ids',
                    'include_header': 'include_header',
                    'empty_participant_value': 'empty_participant_value',
                    'include_participants_not_in_families': 'include_participants_not_in_families',
                },
                'location_map': {
                    'project': 'path',
                    'internal_family_ids': 'query',
                    'export_type': 'query',
                    'replace_with_participant_external_ids': 'query',
                    'replace_with_family_external_ids': 'query',
                    'include_header': 'query',
                    'empty_participant_value': 'query',
                    'include_participants_not_in_families': 'query',
                },
                'collection_format_map': {
                    'internal_family_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_samples_reads_map_async = async_wrap(self.get_samples_reads_map)
        self.get_samples_reads_map_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/sample-cram-path-map',
                'operation_id': 'get_samples_reads_map',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'export_type',
                    'sequence_types',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'export_type':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'sequence_types':
                        ([SequenceType],),
                },
                'attribute_map': {
                    'project': 'project',
                    'export_type': 'export_type',
                    'sequence_types': 'sequence_types',
                },
                'location_map': {
                    'project': 'path',
                    'export_type': 'query',
                    'sequence_types': 'query',
                },
                'collection_format_map': {
                    'sequence_types': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.import_families_async = async_wrap(self.import_families)
        self.import_families_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/family/{project}/family-template',
                'operation_id': 'import_families',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'file',
                    'has_header',
                    'delimiter',
                ],
                'required': [
                    'project',
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'file':
                        (file_type,),
                    'has_header':
                        (bool,),
                    'delimiter':
                        (str,),
                },
                'attribute_map': {
                    'project': 'project',
                    'file': 'file',
                    'has_header': 'has_header',
                    'delimiter': 'delimiter',
                },
                'location_map': {
                    'project': 'path',
                    'file': 'form',
                    'has_header': 'query',
                    'delimiter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

        self.import_individual_metadata_manifest_async = async_wrap(self.import_individual_metadata_manifest)
        self.import_individual_metadata_manifest_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/import/{project}/individual-metadata-manifest',
                'operation_id': 'import_individual_metadata_manifest',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'file',
                    'delimiter',
                    'extra_participants_method',
                ],
                'required': [
                    'project',
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'file':
                        (file_type,),
                    'delimiter':
                        (str,),
                    'extra_participants_method':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'project': 'project',
                    'file': 'file',
                    'delimiter': 'delimiter',
                    'extra_participants_method': 'extra_participants_method',
                },
                'location_map': {
                    'project': 'path',
                    'file': 'form',
                    'delimiter': 'query',
                    'extra_participants_method': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

        self.import_pedigree_async = async_wrap(self.import_pedigree)
        self.import_pedigree_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/family/{project}/pedigree',
                'operation_id': 'import_pedigree',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'file',
                    'has_header',
                    'create_missing_participants',
                    'perform_sex_check',
                ],
                'required': [
                    'project',
                    'file',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'file':
                        (file_type,),
                    'has_header':
                        (bool,),
                    'create_missing_participants':
                        (bool,),
                    'perform_sex_check':
                        (bool,),
                },
                'attribute_map': {
                    'project': 'project',
                    'file': 'file',
                    'has_header': 'has_header',
                    'create_missing_participants': 'create_missing_participants',
                    'perform_sex_check': 'perform_sex_check',
                },
                'location_map': {
                    'project': 'path',
                    'file': 'form',
                    'has_header': 'query',
                    'create_missing_participants': 'query',
                    'perform_sex_check': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def get_external_participant_id_to_internal_sample_id(
        self,
        project,
        **kwargs
    ):
        """Get External Participant Id To Internal Sample Id  # noqa: E501

        Get csv / tsv export of external_participant_id to internal_sample_id  Get a map of {external_participant_id} -> {internal_sample_id} useful to matching joint-called samples in the matrix table to the participant  Return a list not dictionary, because dict could lose participants with multiple samples.  :param flip_columns: Set to True when exporting for seqr  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_external_participant_id_to_internal_sample_id(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            export_type (bool, date, datetime, dict, float, int, list, str, none_type): [optional]
            flip_columns (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_external_participant_id_to_internal_sample_id_endpoint.call_with_http_info(**kwargs)

    def get_families(
        self,
        project,
        **kwargs
    ):
        """Get Families  # noqa: E501

        Get families for some project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_families(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            participant_ids ([int]): [optional]
            sample_ids ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_families_endpoint.call_with_http_info(**kwargs)

    def get_individual_metadata_for_seqr(
        self,
        project,
        **kwargs
    ):
        """Get Individual Metadata Template For Seqr  # noqa: E501

        Get individual metadata template for SEQR as a CSV  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_individual_metadata_for_seqr(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            export_type (bool, date, datetime, dict, float, int, list, str, none_type): [optional]
            external_participant_ids ([str]): [optional]
            replace_with_participant_external_ids (bool): [optional] if omitted the server will use the default value of True
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_individual_metadata_for_seqr_endpoint.call_with_http_info(**kwargs)

    def get_pedigree(
        self,
        project,
        **kwargs
    ):
        """Get Pedigree  # noqa: E501

        Generate tab-separated Pedigree file for ALL families unless internal_family_ids is specified.  Allow replacement of internal participant and family IDs with their external counterparts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pedigree(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            internal_family_ids ([int]): [optional]
            export_type (bool, date, datetime, dict, float, int, list, str, none_type): [optional]
            replace_with_participant_external_ids (bool): [optional] if omitted the server will use the default value of True
            replace_with_family_external_ids (bool): [optional] if omitted the server will use the default value of True
            include_header (bool): [optional] if omitted the server will use the default value of True
            empty_participant_value (str): [optional]
            include_participants_not_in_families (bool): [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_pedigree_endpoint.call_with_http_info(**kwargs)

    def get_samples_reads_map(
        self,
        project,
        **kwargs
    ):
        """Get Sample Reads Map  # noqa: E501

        Get map of ExternalSampleId  pathToCram  InternalSampleID for seqr  Description:     Column 1: Individual ID     Column 2: gs:// Google bucket path or server filesystem path for this Individual     Column 3: Sample ID for this file, if different from the Individual ID.                 Used primarily for gCNV files to identify the sample in the batch path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_samples_reads_map(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            export_type (bool, date, datetime, dict, float, int, list, str, none_type): [optional]
            sequence_types ([SequenceType]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_samples_reads_map_endpoint.call_with_http_info(**kwargs)

    def import_families(
        self,
        project,
        file,
        **kwargs
    ):
        """Import Families  # noqa: E501

        Import a family csv  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_families(project, file, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):
            file (file_type):

        Keyword Args:
            has_header (bool): [optional] if omitted the server will use the default value of True
            delimiter (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        kwargs['file'] = \
            file
        return self.import_families_endpoint.call_with_http_info(**kwargs)

    def import_individual_metadata_manifest(
        self,
        project,
        file,
        **kwargs
    ):
        """Import Individual Metadata Manifest  # noqa: E501

        Import individual metadata manifest  :param extra_participants_method: If extra participants are in the uploaded file,     add a PARTICIPANT entry for them  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_individual_metadata_manifest(project, file, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):
            file (file_type):

        Keyword Args:
            delimiter (str): [optional]
            extra_participants_method (bool, date, datetime, dict, float, int, list, str, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        kwargs['file'] = \
            file
        return self.import_individual_metadata_manifest_endpoint.call_with_http_info(**kwargs)

    def import_pedigree(
        self,
        project,
        file,
        **kwargs
    ):
        """Import Pedigree  # noqa: E501

        Import a pedigree  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_pedigree(project, file, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):
            file (file_type):

        Keyword Args:
            has_header (bool): [optional] if omitted the server will use the default value of False
            create_missing_participants (bool): [optional] if omitted the server will use the default value of False
            perform_sex_check (bool): [optional] if omitted the server will use the default value of True
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        kwargs['file'] = \
            file
        return self.import_pedigree_endpoint.call_with_http_info(**kwargs)

