EvoCluster is an open source and cross-platform framework implemented in Python which includes the most well-known and recent nature-inspired meta heuristic optimizers that are customized to perform partitional clustering tasks. The goal of this framework is to provide a user-friendly and customizable implementation of the metaheuristic based clustering algorithms which canbe utilized by experienced and non-experienced users for different applications. The framework can also be used by researchers who can benefit from the implementation of the metaheuristic optimizers for their research studies. 

- Web Page: http://evo-ml.com/evocluster/
- Paper: https://link.springer.com/chapter/10.1007/978-3-030-43722-0_2
- Extended Paper: https://link.springer.com/article/10.1007/s42979-021-00511-0
- Source code: https://github.com/RaneemQaddoura/EvoCluster/

Features
- Ten nature-inspired metaheuristic optimizers are implemented (SSA, PSO, GA, BAT, FFA, GWO, WOA, MVO, MFO, and CS).
- Five objective functions (SSE, TWCV, SC, DB, and DI).
- Thirty datasets obtained from Scikit learn, UCI, School of Computing at University of Eastern Finland, ELKI, KEEL, and Naftali Harris Blog
- Twelve evaluation measures (SSE, Purity, Entropy, HS, CS, VM, AMI, ARI, Fmeasure, TWCV, SC, Accuracy, DI, DB, and Standard Diviation)
- More than twenty distance measures
- Ten different ways for detecting the k value
- The implimentation uses the fast array manipulation using [NumPy] (http://www.numpy.org/).
- Matrix support using [SciPy's] (https://www.scipy.org/) package.
- Simple and efficient tools for prediction using [sklearn] (https://scikit-learn.org/stable/)
- File data analysis and manipulation tool using [pandas] (https://pandas.pydata.org/)
- Plot interactive visualizations using [matplotlib] (https://matplotlib.org/)
- More optimizers, objective functions, adatasets, and evaluation measures are coming soon.
