"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const pjson = require('../package.json');
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, params) {
        super(scope, id);
        /**
         * @stability stable
         */
        this.objectCodeKey = pjson.version;
        if (typeof params.subnet !== 'undefined' || typeof params.securityGroups !== 'undefined' && !(typeof params.vpc !== 'undefined')) {
            throw new Error('you cant pass subnet or securitygroup without vpc');
        }
        if (!(typeof params.subnet !== 'undefined') || !(typeof params.securityGroups !== 'undefined') && typeof params.vpc !== 'undefined') {
            throw new Error('you cant pass vpc without subnet and securityGroups');
        }
        this.flywayLambdaMigration = new awsLambda.Function(this, id, {
            vpc: params.vpc,
            vpcSubnets: params.subnet,
            securityGroups: params.securityGroups,
            memorySize: params.memorySize || 512,
            timeout: params.timeout || cdk.Duration.seconds(30),
            handler: FlywayConstruct.HANDLER,
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                //add PREFIX: params.bucketFolderPrefix || ''
                ARN: params.migrationDBSecretManager.secretArn,
                BUCKET_NAME: params.bucketMigrationSQL.bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, FlywayConstruct.ID_LAMBDA_CODE, FlywayConstruct.BUCKET_CODE_ARN), 'flywayjar.' + this.objectCodeKey + '.zip'),
        });
        params.migrationDBSecretManager.grantRead(this.flywayLambdaMigration);
        params.bucketMigrationSQL.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.2.27" };
/**
 * @stability stable
 */
FlywayConstruct.HANDLER = 'tech.necko.flywayjar.Main::handleRequest';
/**
 * @stability stable
 */
FlywayConstruct.ID_LAMBDA_CODE = 'bucketMigration';
/**
 * @stability stable
 */
FlywayConstruct.BUCKET_CODE_ARN = 'arn:aws:s3:::flywaymigrationconstruct';
//# sourceMappingURL=data:application/json;base64,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