from __future__ import print_function
import pickle
import os.path
from googleapiclient.discovery import build
from google_auth_oauthlib.flow import InstalledAppFlow
from google.auth.transport.requests import Request
from googleapiclient.http import MediaFileUpload

import webbrowser

# If modifying these scopes, delete the file token.pickle.
SCOPES = ['https://www.googleapis.com/auth/drive']

def main(path, filename):
    """Shows basic usage of the Drive v3 API.
    Prints the names and ids of the first 10 files the user has access to.
    """
    creds = None
    # The file token.pickle stores the user's access and refresh tokens, and is
    # created automatically when the authorization flow completes for the first
    # time.
    if os.path.exists('token.pickle'):
        with open('token.pickle', 'rb') as token:
            creds = pickle.load(token)
    # If there are no (valid) credentials available, let the user log in.
    if not creds or not creds.valid:
        if creds and creds.expired and creds.refresh_token:
            creds.refresh(Request())
        else:
            flow = InstalledAppFlow.from_client_secrets_file(
                'credentials.json', SCOPES)
            creds = flow.run_local_server(port=0)
        # Save the credentials for the next run
        with open('token.pickle', 'wb') as token:
            pickle.dump(creds, token)

    service = build('drive', 'v3', credentials=creds)

    # Call the Drive v3 API - Fetch files
    # results = service.files().list(
    #     pageSize=10, fields="nextPageToken, files(id, name)").execute()
    # items = results.get('files', [])

    # if not items:
    #     print('No files found.')
    # else:
    #     print('Files:')
    #     for item in items:
    #         print(u'{0} ({1})'.format(item['name'], item['id']))

    file_metadata = {'name': 'cat.jpg'}
    media = MediaFileUpload('files/cat.jpg')
    file = service.files().create(body=file_metadata,
                                        media_body=media,
                                        fields='id').execute()

    webbrowser.open(f"https://drive.google.com/file/d/{file.get('id')}/view")

    print("Link: " + f"https://drive.google.com/file/d/{file.get('id')}/view")


if __name__ == '__main__':
    import argparse
    parser = argparse.ArgumentParser(description='Upload a file to Google Drive')
    parser.add_argument('Path',
                       metavar='path',
                       type=str,
                       help='Path of the file that you wan to upload to Google Drive')

    args = parser.parse_args()

    input_path = args.Path

    if not os.path.isfile(input_path):
        print("Invalid path")
    else:
        head, tail = os.path.split(input_path)
        main(input_path, tail)

