# abTEM: ab initio Transmission Electron Microscopy

[![PyPI version](https://badge.fury.io/py/abtem.svg)](https://badge.fury.io/py/abtem)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![Documentation Status](https://readthedocs.org/projects/abtem/badge/?version=latest)](https://abtem.readthedocs.io/en/latest/?badge=latest)
[![Gitter](https://badges.gitter.im/abTEM/community.svg)](https://gitter.im/abTEM/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

[**Docs**](https://abtem.readthedocs.io/en/latest/index.html)
| [**Install Guide**](https://abtem.readthedocs.io/en/latest/install.html)
| [**Examples**](https://github.com/jacobjma/abTEM/tree/master/examples)
| [**Gitter**](https://gitter.im/abTEM/)

**This program is under development and subject to changes. Please be aware and report issues.**

abTEM provides a Python API for running simulations of (scanning) transmission electron microscopy images and diffraction patterns using the multislice or PRISM algorithms. It is designed to closely integrate with atomistic simulations using the Atomic Simulation Environment (ASE), and to directly use *ab initio* electrostatic potentials from the high-performance density functional theory code GPAW.

## Installation

You can install abTEM using `pip`:

```sh
$ pip install abtem
```

For detailed instructions on installing abTEM, see [the installation guide](https://abtem.readthedocs.io/en/latest/install.html).

## Getting started

To get started using abTEM, please visit our [walkthrough](https://abtem.readthedocs.io/en/latest/walkthrough/introduction.html).

## Contact
* Chat on [gitter](https://gitter.im/abTEM/)
* Write the [maintainer](https://github.com/jacobjma) directly
* Bug reports and development: [github issues](https://github.com/jacobjma/abTEM/issues)

Please send us bug reports, patches, code, ideas and questions.
