"""
    Sample metadata API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.6.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sample_metadata.api_client import ApiClient, Endpoint as _Endpoint
from sample_metadata.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
    async_wrap
)
from sample_metadata.model.analysis_model import AnalysisModel
from sample_metadata.model.analysis_query_model import AnalysisQueryModel
from sample_metadata.model.analysis_type import AnalysisType
from sample_metadata.model.analysis_update_model import AnalysisUpdateModel
from sample_metadata.model.body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post import BodyGetLatestCompleteAnalysisForTypePostApiV1AnalysisProjectAnalysisTypeLatestCompletePost
from sample_metadata.model.http_validation_error import HTTPValidationError


class AnalysisApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.create_new_analysis_async = async_wrap(self.create_new_analysis)
        self.create_new_analysis_endpoint = _Endpoint(
            settings={
                'response_type': (int,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/',
                'operation_id': 'create_new_analysis',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                    'analysis_model',
                ],
                'required': [
                    'project',
                    'analysis_model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                    'analysis_model':
                        (AnalysisModel,),
                },
                'attribute_map': {
                    'project': 'project',
                },
                'location_map': {
                    'project': 'path',
                    'analysis_model': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

        self.get_all_sample_ids_without_analysis_type_async = async_wrap(self.get_all_sample_ids_without_analysis_type)
        self.get_all_sample_ids_without_analysis_type_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/type/{analysis_type}/not-included-sample-ids',
                'operation_id': 'get_all_sample_ids_without_analysis_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_type',
                    'project',
                ],
                'required': [
                    'analysis_type',
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_type':
                        (AnalysisType,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'analysis_type': 'analysis_type',
                    'project': 'project',
                },
                'location_map': {
                    'analysis_type': 'path',
                    'project': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_analysis_by_id_async = async_wrap(self.get_analysis_by_id)
        self.get_analysis_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{analysis_id}/details',
                'operation_id': 'get_analysis_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_id',
                ],
                'required': [
                    'analysis_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_id':
                        (int,),
                },
                'attribute_map': {
                    'analysis_id': 'analysis_id',
                },
                'location_map': {
                    'analysis_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_analysis_runner_log_async = async_wrap(self.get_analysis_runner_log)
        self.get_analysis_runner_log_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/analysis-runner',
                'operation_id': 'get_analysis_runner_log',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'request_body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'request_body':
                        ([str],),
                },
                'attribute_map': {
                },
                'location_map': {
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

        self.get_incomplete_analyses_async = async_wrap(self.get_incomplete_analyses)
        self.get_incomplete_analyses_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/incomplete',
                'operation_id': 'get_incomplete_analyses',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'project': 'project',
                },
                'location_map': {
                    'project': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_latest_analysis_for_samples_and_type_async = async_wrap(self.get_latest_analysis_for_samples_and_type)
        self.get_latest_analysis_for_samples_and_type_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/{analysis_type}/latest-complete/for-samples',
                'operation_id': 'get_latest_analysis_for_samples_and_type',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_type',
                    'project',
                    'request_body',
                    'allow_missing',
                ],
                'required': [
                    'analysis_type',
                    'project',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_type':
                        (AnalysisType,),
                    'project':
                        (str,),
                    'request_body':
                        ([str],),
                    'allow_missing':
                        (bool,),
                },
                'attribute_map': {
                    'analysis_type': 'analysis_type',
                    'project': 'project',
                    'allow_missing': 'allow_missing',
                },
                'location_map': {
                    'analysis_type': 'path',
                    'project': 'path',
                    'request_body': 'body',
                    'allow_missing': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

        self.get_latest_complete_analysis_for_type_async = async_wrap(self.get_latest_complete_analysis_for_type)
        self.get_latest_complete_analysis_for_type_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/{analysis_type}/latest-complete',
                'operation_id': 'get_latest_complete_analysis_for_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_type',
                    'project',
                ],
                'required': [
                    'analysis_type',
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_type':
                        (AnalysisType,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'analysis_type': 'analysis_type',
                    'project': 'project',
                },
                'location_map': {
                    'analysis_type': 'path',
                    'project': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_latest_complete_analysis_for_type_post_async = async_wrap(self.get_latest_complete_analysis_for_type_post)
        self.get_latest_complete_analysis_for_type_post_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/{analysis_type}/latest-complete',
                'operation_id': 'get_latest_complete_analysis_for_type_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_type',
                    'project',
                    'body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post',
                ],
                'required': [
                    'analysis_type',
                    'project',
                    'body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_type':
                        (AnalysisType,),
                    'project':
                        (str,),
                    'body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post':
                        (BodyGetLatestCompleteAnalysisForTypePostApiV1AnalysisProjectAnalysisTypeLatestCompletePost,),
                },
                'attribute_map': {
                    'analysis_type': 'analysis_type',
                    'project': 'project',
                },
                'location_map': {
                    'analysis_type': 'path',
                    'project': 'path',
                    'body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

        self.get_sample_reads_map_for_seqr_async = async_wrap(self.get_sample_reads_map_for_seqr)
        self.get_sample_reads_map_for_seqr_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{project}/sample-cram-path-map/tsv',
                'operation_id': 'get_sample_reads_map_for_seqr',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                ],
                'required': [
                    'project',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'project': 'project',
                },
                'location_map': {
                    'project': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.query_analyses_async = async_wrap(self.query_analyses)
        self.query_analyses_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/query',
                'operation_id': 'query_analyses',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_query_model',
                ],
                'required': [
                    'analysis_query_model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_query_model':
                        (AnalysisQueryModel,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'analysis_query_model': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

        self.update_analysis_status_async = async_wrap(self.update_analysis_status)
        self.update_analysis_status_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/analysis/{analysis_id}/',
                'operation_id': 'update_analysis_status',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'analysis_id',
                    'analysis_update_model',
                ],
                'required': [
                    'analysis_id',
                    'analysis_update_model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'analysis_id':
                        (int,),
                    'analysis_update_model':
                        (AnalysisUpdateModel,),
                },
                'attribute_map': {
                    'analysis_id': 'analysis_id',
                },
                'location_map': {
                    'analysis_id': 'path',
                    'analysis_update_model': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_new_analysis(
        self,
        project,
        analysis_model,
        **kwargs
    ):
        """Create New Analysis  # noqa: E501

        Create a new analysis  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_new_analysis(project, analysis_model, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):
            analysis_model (AnalysisModel):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            int
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        kwargs['analysis_model'] = \
            analysis_model
        return self.create_new_analysis_endpoint.call_with_http_info(**kwargs)

    def get_all_sample_ids_without_analysis_type(
        self,
        analysis_type,
        project,
        **kwargs
    ):
        """Get All Sample Ids Without Analysis Type  # noqa: E501

        get_all_sample_ids_without_analysis_type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_sample_ids_without_analysis_type(analysis_type, project, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_type (AnalysisType):
            project (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_type'] = \
            analysis_type
        kwargs['project'] = \
            project
        return self.get_all_sample_ids_without_analysis_type_endpoint.call_with_http_info(**kwargs)

    def get_analysis_by_id(
        self,
        analysis_id,
        **kwargs
    ):
        """Get Analysis By Id  # noqa: E501

        Get analysis by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_by_id(analysis_id, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_id (int):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_id'] = \
            analysis_id
        return self.get_analysis_by_id_endpoint.call_with_http_info(**kwargs)

    def get_analysis_runner_log(
        self,
        **kwargs
    ):
        """Get Analysis Runner Log  # noqa: E501

        Get log for the analysis-runner, useful for checking this history of analysis  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_runner_log(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            request_body ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_analysis_runner_log_endpoint.call_with_http_info(**kwargs)

    def get_incomplete_analyses(
        self,
        project,
        **kwargs
    ):
        """Get Incomplete Analyses  # noqa: E501

        Get analyses with status queued or in-progress  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_incomplete_analyses(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_incomplete_analyses_endpoint.call_with_http_info(**kwargs)

    def get_latest_analysis_for_samples_and_type(
        self,
        analysis_type,
        project,
        request_body,
        **kwargs
    ):
        """Get Latest Analysis For Samples And Type  # noqa: E501

        Get latest complete gvcfs for sample  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_latest_analysis_for_samples_and_type(analysis_type, project, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_type (AnalysisType):
            project (str):
            request_body ([str]):

        Keyword Args:
            allow_missing (bool): [optional] if omitted the server will use the default value of True
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_type'] = \
            analysis_type
        kwargs['project'] = \
            project
        kwargs['request_body'] = \
            request_body
        return self.get_latest_analysis_for_samples_and_type_endpoint.call_with_http_info(**kwargs)

    def get_latest_complete_analysis_for_type(
        self,
        analysis_type,
        project,
        **kwargs
    ):
        """Get Latest Complete Analysis For Type  # noqa: E501

        Get (SINGLE) latest complete analysis for some analysis type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_latest_complete_analysis_for_type(analysis_type, project, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_type (AnalysisType):
            project (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_type'] = \
            analysis_type
        kwargs['project'] = \
            project
        return self.get_latest_complete_analysis_for_type_endpoint.call_with_http_info(**kwargs)

    def get_latest_complete_analysis_for_type_post(
        self,
        analysis_type,
        project,
        body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post,
        **kwargs
    ):
        """Get Latest Complete Analysis For Type Post  # noqa: E501

        Get SINGLE latest complete analysis for some analysis type (you can specify meta attributes in this route)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_latest_complete_analysis_for_type_post(analysis_type, project, body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_type (AnalysisType):
            project (str):
            body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post (BodyGetLatestCompleteAnalysisForTypePostApiV1AnalysisProjectAnalysisTypeLatestCompletePost):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_type'] = \
            analysis_type
        kwargs['project'] = \
            project
        kwargs['body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post'] = \
            body_get_latest_complete_analysis_for_type_post_api_v1_analysis_project_analysis_type_latest_complete_post
        return self.get_latest_complete_analysis_for_type_post_endpoint.call_with_http_info(**kwargs)

    def get_sample_reads_map_for_seqr(
        self,
        project,
        **kwargs
    ):
        """Get Sample Reads Map For Seqr  # noqa: E501

        Get map of ExternalSampleId  pathToCram  InternalSampleID for seqr  Description:     Column 1: Individual ID     Column 2: gs:// Google bucket path or server filesystem path for this Individual     Column 3: Sample ID for this file, if different from the Individual ID.                 Used primarily for gCNV files to identify the sample in the batch path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sample_reads_map_for_seqr(project, async_req=True)
        >>> result = thread.get()

        Args:
            project (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['project'] = \
            project
        return self.get_sample_reads_map_for_seqr_endpoint.call_with_http_info(**kwargs)

    def query_analyses(
        self,
        analysis_query_model,
        **kwargs
    ):
        """Query Analyses  # noqa: E501

        Get analyses by some criteria  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_analyses(analysis_query_model, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_query_model (AnalysisQueryModel):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_query_model'] = \
            analysis_query_model
        return self.query_analyses_endpoint.call_with_http_info(**kwargs)

    def update_analysis_status(
        self,
        analysis_id,
        analysis_update_model,
        **kwargs
    ):
        """Update Analysis Status  # noqa: E501

        Update status of analysis  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_analysis_status(analysis_id, analysis_update_model, async_req=True)
        >>> result = thread.get()

        Args:
            analysis_id (int):
            analysis_update_model (AnalysisUpdateModel):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['analysis_id'] = \
            analysis_id
        kwargs['analysis_update_model'] = \
            analysis_update_model
        return self.update_analysis_status_endpoint.call_with_http_info(**kwargs)

