q = {
    "markAsRead": "mutation MarkAllNotificationsAsSeen {markAllNotificationsAsSeen {id}}",
    "replTitle": "query ReplTitle($title: String, $teamId: Int) {replTitle(title: $title, teamId: $teamId)}",
    "dashboardMoveItems": "mutation ReplsDashboardMoveItemsToFolder($replIds: [String!]!, $folderIds: [String!]!, $destFolderId: String!, $teamId: Int) {moveItemsToFolder(replIds: $replIds, folderIds: $folderIds, destFolderId: $destFolderId, teamId: $teamId) {... on Repl {id, ...ReplsDashboardReplItemRepl}, ... on ReplFolder {id, ...ReplsDashboardFolderItemReplFolder}}}, fragment ReplsDashboardReplItemRepl on Repl {id, ...ReplsDashboardReplItemActionsRepl, ...ReplLinkRepl, user {...UserLinkUser}}, fragment ReplsDashboardReplItemActionsRepl on Repl {id}, fragment ReplLinkRepl on Repl {id}, fragment UserLinkUser on User {id}, fragment ReplsDashboardFolderItemReplFolder on ReplFolder {id}",
    "dashboardItems": "query ReplsDashboardReplFolderList($path: String!, $starred: Boolean, $after: String) {currentUser {replFolderByPath(path: $path) {id, canEdit, canCreateSubFolders, parent {id}, folders {name, canEdit, timeCreated}, repls(starred: $starred, after: $after) {items {id, user {username}, config {isServer}}, pageInfo {nextCursor}}}}}",
    "updatePresence": "mutation SitePresenceUpdate { updateUserSitePresence { __typename } }",
    "replComments": "query Repl($id: String!, $after: String, $count: Int) {repl(id: $id) {... on Repl {comments(after: $after, count: $count) {items {\n\t\t\tid\n\t\t\ttimeCreated\n\t \t\ttimeUpdated\n\t\t\tbody\n\t\t\tbodyNoMarkdown: body(removeMarkdown: true)\n\t\t\tuser {\n\t \t\t\tusername\n\t\t\t}\n\t \t\tisHidden\n\t\t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\tparentComment {\n\t\t\t\tid\n\t\t\t}\n\t \t\tpost {\n\t\t\t\tid\n\t\t\t}\n\t\t\tcurrentUserPermissions {\n\t \t\t\tedit\n\t\t \t\tdelete\n\t\t \t\tbanAuthor\n\t\t \t\tcanHideComment\n\t\t \t\treport\n\t\t\t}\n\t\t}}}}}",
    "currentUser": """query {currentUser {
			id
			email
			username
			firstName
			lastName
			locale
			emailNotifications
			isVerified
			displayName
			fullName
			url
			bio
			socials {
				id
		 		url
				type
			}
			hasRepl
			hasPrivacyRole
			roles {
				id
		 		key
				name
		 		tagline
			}
			isLoggedIn
			isSubscribed
			timeCreated
			warnings {
				id
		 		reason
				moderator {
		 			username
				}
		 		timeCreated
			}
			followerCount
			followCount
			isBannedFromBoards
			isHacker
			cannySSOToken
			canUpdateEmail: canUpdate(column: EMAIL)
			canUpdateUsername: canUpdate(column: USERNAME)
			state {
				id
		 		skillLevel
				interestedIn
		 		languagesInterestedIn {
					id
					displayName
					icon
					tagline
				}
			}
			device {
				isMobile
		 		isMac
			}
			sidebarClosed
			hasProfileImage
			image
			coverImage {
				url
		 		offsetY
			}
			socialSignup
			googleAuth: auth(provider: GOOGLE) {
				accessToken
			}
			githubAuth: auth(provider: GITHUB) {
				accessToken
			}
			facebookAuth: auth(provider: FACEBOOK) {
				accessToken
			}
			gitHubInfo {
		 		installations {
					id
					type
					avatarUrl
					name
				}
		 		userInfo {
					name
					email
					avatarUrl
				}
			}
			usernameRepl {
				id
		 		title
				url
			}
			daysSinceSignup
			storage {
				limit
		 		used
			}
			clui
			editorPreferences {
				isLayoutStacked
		 		theme
				fontSize
		 		indentIsSpaces
				indentSize
		 		keyboardHandler
				wrapping
		 		codeIntelligence
				codeSuggestion
				accessibleTerminal
		 		extraDelight
			}
		}}""",
    "comment": "query Comment($id: Int!) {comment(id: $id) {id, body, voteCount, timeCreated, timeUpdated, user {username}, url, post {id}, parentComment {id}, isAuthor, canEdit, canVote, canComment, hasVoted, canReport, hasReported, isAnswer, canSelectAsAnswer, canUnselectAsAnswer}}",
    "restore": "mutation Mutation($title: String!) {clui {trash {restore(title: $title) {...CluiOutput}}}}, fragment CluiOutput on CluiOutput {... on CluiSuccessOutput {message, json}, ... on CluiErrorOutput {error, json}, ... on CluiMarkdownOutput {markdown}, ... on CluiComponentOutput {component}, ... on CluiTableOutput {columns {label, key}, rows}}",
    "dashboardDeleteFolder": "mutation ReplsDashboardFolderItemDelete($folderId: String!) {deleteReplFolder(folderId: $folderId) {id}}",
    "updateUser": "mutation UpdateCurrentUser($input: UpdateCurrentUserInput!) {updateCurrentUser(input: $input) {\n\t\t\tfirstName\n\t \t\tlastName\n\t\t\tbio\n\t\t\temailNotifications\n\t \t\timage\n\t\t}}",
    "deleteRepl": "mutation DeleteRepl($id: String!) {deleteRepl(id: $id) {id}}",
    "replComment": "query ReplComment($id: Int!) {replComment(id: $id) {...on ReplComment {\n\t\t\tid\n\t\t\tbody\n\t\t\ttimeCreated\n\t \t\ttimeUpdated\n\t\t\tuser {\n\t \t\t\tusername\n\t\t\t}\n\t \t\tisHidden\n\t\t\tpost {\n\t \t\t\tid\n\t\t\t}\n\t \t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\tparentComment {\n\t\t\t\tid\n\t\t \t\tbody\n\t\t\t\ttimeCreated\n\t\t \t\ttimeUpdated\n\t\t\t\tuser {\n\t\t \t\t\tusername\n\t\t\t\t}\n\t\t\t\tpost {\n\t\t \t\t\tid\n\t\t\t\t}\n\t\t \t\trepl {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\tcomments: replies {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\tcanComment\n\t\t\t}\n\t \t\tcomments: replies {\n\t\t\t\tid\n\t\t \t\tbody\n\t\t\t\ttimeCreated\n\t\t \t\ttimeUpdated\n\t\t\t\tuser {\n\t\t \t\t\tusername\n\t\t\t\t}\n\t\t \t\trepl {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\tparentComment {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\tcanComment\n\t\t\t}\n\t \t\tcanComment\n\t\t} ...on UserError {message}}}",
    "user": "query User($id: Int!) {user(id: $id) {\n\t \t\tid\n\t\t\tusername\n\t\t\tfirstName\n\t\t\tlastName\n\t\t\tlocale\n\t\t\tisVerified\n\t\t\tdisplayName\n\t\t\tfullName\n\t\t\turl\n\t\t\tbio\n\t\t\tsocials {\n\t\t\t\tid\n\t\t \t\turl\n\t\t\t\ttype\n\t\t\t}\n\t\t\troles {\n\t\t\t\tid\n\t\t \t\tkey\n\t\t\t\tname\n\t\t \t\ttagline\n\t\t\t}\n\t\t\tisFollowedByCurrentUser\n\t\t\tisFollowingCurrentUser\n\t\t\tisBlockedByCurrentUser\n\t\t\tisBlockingCurrentUser\n\t\t\tisLoggedIn\n\t\t\tisSubscribed\n\t\t\ttimeCreated\n\t\t\tfollowerCount\n\t\t\tfollowCount\n\t\t\tisHacker\n\t\t\timage\n\t\t\tcoverImage {\n\t\t\t\turl\n\t\t \t\toffsetY\n\t\t\t}\n\t\t\tpresenceStatus {\n\t\t\t\tlastSeen\n\t\t \t\tisOnline\n\t\t\t}\n\t\t}}",
    "createReplComment": "mutation CreateReplComment($input: CreateReplCommentInput!) {createReplComment(input: $input) {...on UserError {message} ...on ReplComment {\n\t\t\tid\n\t \t\tbody\n\t\t\ttimeCreated\n\t \t\ttimeUpdated\n\t\t\tuser {\n\t \t\t\tusername\n\t\t\t}\n\t\t\tpost {\n\t \t\t\tid\n\t\t\t}\n\t \t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\tcanEdit\n\t\t}}}",
    "trash": "query Query {clui {trash {view {...CluiOutput}}}}, fragment CluiOutput on CluiOutput {... on CluiSuccessOutput {message, json}, ... on CluiErrorOutput {error, json}, ... on CluiMarkdownOutput {markdown}, ... on CluiComponentOutput {component}, ... on CluiTableOutput {columns {label, key}, rows}}",
    "removeMultiplayer": "mutation RemoveMultiplayerUser($username: String!, $replId: String!) {removeMultiplayerUser(username: $username, replId: $replId) {id}}",
    "following": "query FollowModalFollows($username: String!, $after: String, $count: Int) {currentUser {id}, user: userByUsername(username: $username) {id, follows(after: $after, count: $count) {items {id, ...FollowModalUser}, pageInfo {hasNextPagenextCursor}}}}, fragment FollowModalUser on User {...UserLinkUser, id, username, fullName, image, isFollowedByCurrentUser, followerCount}, fragment UserLinkUser on User {id, url, username}",
    "userByUsername": "query UserByUsername($username: String!) {userByUsername(username: $username) {\n\t \t\tid\n\t\t\tusername\n\t\t\tfirstName\n\t\t\tlastName\n\t\t\tlocale\n\t\t\tisVerified\n\t\t\tdisplayName\n\t\t\tfullName\n\t\t\turl\n\t\t\tbio\n\t\t\tsocials {\n\t\t\t\tid\n\t\t \t\turl\n\t\t\t\ttype\n\t\t\t}\n\t\t\troles {\n\t\t\t\tid\n\t\t \t\tkey\n\t\t\t\tname\n\t\t \t\ttagline\n\t\t\t}\n\t\t\tisFollowedByCurrentUser\n\t\t\tisFollowingCurrentUser\n\t\t\tisBlockedByCurrentUser\n\t\t\tisBlockingCurrentUser\n\t\t\tisLoggedIn\n\t\t\tisSubscribed\n\t\t\ttimeCreated\n\t\t\tfollowerCount\n\t\t\tfollowCount\n\t\t\tisHacker\n\t\t\timage\n\t\t\tcoverImage {\n\t\t\t\turl\n\t\t \t\toffsetY\n\t\t\t}\n\t\t\tpresenceStatus {\n\t\t\t\tlastSeen\n\t\t \t\tisOnline\n\t\t\t}\n\t\t}}",
    "userPosts": "query ProfilePosts($username: String!, $after: String, $order: String, $count: Int) {userByUsername(username: $username) {posts(after: $after, order: $order, count: $count) {items {\n\t\t\tid\n\t \t\ttitle\n\t\t\tshowHosted\n\t \t\tcommentCount\n\t\t\tisPinned\n\t \t\tisHidden\n\t\t\tisLocked\n\t \t\ttimeCreated\n\t\t\ttimeUpdated\n\t \t\tbody\n\t\t\turl\n\t \t\tuser {\n\t\t\t\tusername\n\t\t\t}\n\t \t\tboard {\n\t\t\t\tid\n\t\t\t}\n\t \t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\treplComment {\n\t\t\t\tid\n\t\t\t}\n\t\t}}}}",
    "post": "query Post($id: Int!) {post(id: $id) {\n\t\t\tid\n\t \t\ttitle\n\t\t\tshowHosted\n\t \t\tcommentCount\n\t\t\tisPinned\n\t \t\tisHidden\n\t\t\tisLocked\n\t \t\ttimeCreated\n\t\t\ttimeUpdated\n\t \t\tbody\n\t \t\tuser {\n\t\t\t\tusername\n\t\t\t}\n\t \t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\treplComment {\n\t\t\t\tid\n\t\t\t\tbody\n\t\t\t\ttimeCreated\n\t\t \t\ttimeUpdated\n\t\t\t\tuser {\n\t\t \t\t\tusername\n\t\t\t\t}\n\t\t \t\tisHidden\n\t\t \t\trepl {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\tparentComment {\n\t\t\t\t\tid\n\t\t\t \t\tbody\n\t\t\t\t\ttimeCreated\n\t\t\t \t\ttimeUpdated\n\t\t\t\t\tuser {\n\t\t\t \t\t\tusername\n\t\t\t\t\t}\n\t\t\t\t\tpost {\n\t\t\t \t\t\tid\n\t\t\t\t\t}\n\t\t\t \t\trepl {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t \t\tcomments: replies {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t \t\tcanComment\n\t\t\t\t}\n\t\t \t\tcomments: replies {\n\t\t\t\t\tid\n\t\t\t \t\tbody\n\t\t\t\t\ttimeCreated\n\t\t\t \t\ttimeUpdated\n\t\t\t\t\tuser {\n\t\t\t \t\t\tusername\n\t\t\t\t\t}\n\t\t\t \t\trepl {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t \t\tparentComment {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t \t\tcanComment\n\t\t\t\t}\n\t\t \t\tcanComment\n\t\t\t}\n\t\t}}",
    "createRepl": "mutation CreateRepl($input: CreateReplInput!) {createRepl(input: $input) {... on Repl {\n\t\t\tid\n\t\t \tisProject\n\t\t \tisPrivate\n\t\t \tisStarred\n\t\t \ttitle\n\t\t \tslug\n\t\t \timageUrl\n\t\t \tfolderId\n\t\t \tisRenamed\n\t\t \tcommentCount\n\t\t \tlikeCount\n\t\t \tcurrentUserDidLike\n\t\t \ttemplateCategory\n\t\t \twasPosted\n\t\t \twasPublished\n\t\t \tlayoutState\n\t\t \tlanguage\n\t\t \towner: user {\n\t\t \t\tid\n\t\t\t\tusername\n\t\t\t\tfirstName\n\t\t\t\tlastName\n\t\t\t\tlocale\n\t\t\t\tisVerified\n\t\t\t\tdisplayName\n\t\t\t\tfullName\n\t\t\t\turl\n\t\t\t\tbio\n\t\t\t\tsocials {\n\t\t\t\t\tid\n\t\t\t \t\turl\n\t\t\t\t\ttype\n\t\t\t\t}\n\t\t\t\troles {\n\t\t\t\t\tid\n\t\t\t \t\tkey\n\t\t\t\t\tname\n\t\t\t \t\ttagline\n\t\t\t\t}\n\t\t\t\tisFollowedByCurrentUser\n\t\t\t\tisFollowingCurrentUser\n\t\t\t\tisBlockedByCurrentUser\n\t\t\t\tisBlockingCurrentUser\n\t\t\t\tisLoggedIn\n\t\t\t\tisSubscribed\n\t\t\t\ttimeCreated\n\t\t\t\tfollowerCount\n\t\t\t\tfollowCount\n\t\t\t\tisHacker\n\t\t\t\timage\n\t\t\t\tcoverImage {\n\t\t\t\t\turl\n\t\t\t \t\toffsetY\n\t\t\t\t}\n\t\t\t\tpresenceStatus {\n\t\t\t\t\tlastSeen\n\t\t\t \t\tisOnline\n\t\t\t\t}\n\t\t\t}\n\t\t\torigin {\n\t\t\t\tid\n\t\t \t\ttitle\n\t\t\t}\n\t\t\tlang {\n\t\t\t\tid\n\t\t \t\tdisplayName\n\t\t \t\tcanUseShellRunner\n\t\t\t}\n\t\t\ticonUrl\n\t\t\ttemplateLabel\n\t\t\turl\n\t\t\tinviteUrl\n\t\t\tmultiplayerInvites {\n\t\t\t\temail\n\t\t \t\treplId\n\t\t\t\ttype\n\t\t\t}\n\t\t\thistoryUrl\n\t\t\tanalyticsUrl\n\t\t\trootOriginReplUrl\n\t\t\ttimeCreated\n\t\t\ttimeUpdated\n\t\t\tisOwner\n\t\t\tconfig {\n\t\t\t\tisServer\n\t\t \t\tgitRemoteUrl\n\t\t\t\tdomain\n\t\t \t\tisVnc\n\t\t \t\tdoClone\n\t\t\t}\n\t\t\tpinnedToProfile\n\t\t\tsize\n\t\t\thostedUrl\n\t\t\thostedUrlDotty: hostedUrl(dotty: true)\n\t\t\thostedUrlDev: hostedUrl(dev: true)\n\t\t\thostedUrlNoCustom: hostedUrl(noCustomDomain: true)\n\t\t\tterminalUrl\n\t\t\tcurrentUserPermissions {\n\t\t\t\tchangeTitle\n\t\t \t\tchangeDescription\n\t\t\t\tchangeImageUrl\n\t\t \t\tchangeIconUrl\n\t\t\t\tchangeTemplateLabel\n\t\t \t\tchangeLanguage\n\t\t\t\tchangeConfig\n\t\t \t\tchangePrivacy\n\t\t\t\tstar\n\t\t \t\tpin\n\t\t\t\tmove\n\t\t \t\tdelete\n\t\t\t\tleaveMultiplayer\n\t\t \t\teditMultiplayers\n\t\t\t\tviewHistory\t\n\t\t \t\tcontainerAttach\n\t\t\t\tcontainerWrite\n\t\t \t\tchangeAlwaysOn\n\t\t\t\tlinkDomain\n\t\t \t\twriteTests\n\t\t\t\tchangeCommentSettings\n\t\t \t\tinviteGuests\n\t\t\t\tpublish\n\t\t \t\tfork\n\t\t\t}\n\t\t\tdatabase {\n\t\t\t\tid\n\t\t \t\tkeysCount\n\t\t\t\tsizeMB\n\t\t\t\tjwt\n\t\t\t}\n\t\t\ttemplate {\n\t\t\t\tid\n\t\t\t}\n\t\t\tisProjectFork\n\t\t\tisModelSolution\n\t\t\tisModelSolutionFork\n\t\t\tworkspaceCta\n\t\t\tsubmission {\n\t\t\t\tid\n\t\t \t\ttimeSubmitted\n\t\t\t\ttimeLastReviewed\n\t\t \t\tisGroupSubmission\n\t\t\t\tauthor {\n\t\t \t\t\tusername\n\t\t\t\t}\n\t\t \t\tsubmissionGroup {\n\t\t\t\t\tusers {\n\t\t\t\t\t\tusername\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tcommentSettings {\n\t\t\t\tid\n\t\t \t\tenabled\n\t\t\t}\n\t\t\tpublicForkCount\n\t\t\trunCount\n\t\t\tisAlwaysOn\n\t\t\tisBoosted\n\t\t\ttags {\n\t\t\t\tid\n\t\t \t\tisOfficial\n\t\t\t}\n\t\t\tlastPublishedAt\n\t\t\tmultiplayers {\n\t\t\t\tusername\n\t\t\t}\n\t\t\tnixedLanguage\n\t\t\tpublishedAs\n\t\t\tattachments {\n\t\t\t\tid\n\t\t \t\tfileName\n\t\t\t\tmimeType\n\t\t \t\ttimeCreated\n\t\t\t\ttimeUpdated\n\t\t \t\tcontents\n\t\t\t}\n\t\t\tdescription(plainText: true)\n\t\t\tmarkdownDescription: description(plainText: false)\n\t\t\thasExplainCode\n\t\t\thasGenerateCode\n\t\t\ttemplateInfo {\n\t\t\t\tlabel\n\t\t \t\ticonUrl\n\t\t\t}\n\t\t\tdomains {\n\t\t\t\tdomain\n\t\t \t\tstate\n\t\t\t}\n\t\t\tapexProxy\n\t\t\treplViewSettings {\n\t\t\t\tid\n\t\t \t\tdefaultView\n\t\t\t\treplFile\n\t\t \t\treplImage\n\t\t\t}\n\t\t\tpowerUpCosts {\n\t\t\t\t...on UnauthorizedError {\n\t\t \t\t\tmessage\n\t\t\t\t}\n\t\t \t\t...on NotFoundError {\n\t\t\t\t\tmessage\n\t\t\t\t}\n\t\t \t\t...on PowerUpCostsType {\n\t\t\t\t\tboost {\n\t\t\t\t\t\tcycles\n\t\t\t \t\t\texplanation\n\t\t\t\t\t}\n\t\t\t\t\talwaysOn {\n\t\t\t\t\t\tcycles\n\t\t\t \t\t\texplanation\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tisTutorial\n\t\t}}}",
    "postComments": "mutation createReplComment($input: CreateReplCommentInput!) { createReplComment(input: $input) { ...on ReplComment { $input } } }",
    "getUserEventsFeed": "query getUserEventsFeed($count: Int!, $after: String!) {\n        getUserEventsFeed(count: $count, after: $after) {\n          ... on UserEventConnection {\n            items {\n              id\n              user { username }\n              following { username }\n              comment { body repl { url } }\n              reaction { reactionType }\n              repl { title url }\n              eventType\n            }\n          }\n        }\n      }",
    "changeUsername": "mutation Mutation($username: String!) {clui {account {changeUsername(username: $username) {...CluiOutput}}}}, fragment CluiOutput on CluiOutput {... on CluiSuccessOutput {message, json}, ... on CluiErrorOutput {error, json}, ... on CluiMarkdownOutput {markdown}, ... on CluiComponentOutput {component}, ... on CluiTableOutput {columns {label, key}, rows}}",
    "ReplNews": "query ReplNews($count: Int!, $options: ReplPostsQueryOptions!, $username: String!) {\n      pinnedPosts { title repl { url } user { username } }\n      siteBanner { id message }\n      trendingReplPosts(count: $count) { repl { id title url description user { username } } }\n      replPosts(options: $options) { items { repl { title url description user { username } } } }\n      userByUsername(username: $username) { presenceStatus { lastSeen isOnline } }\n    }",
    "replThreads": "query Repl($id: String) {repl(id: $id) {...on Repl {\n\t\t\tannotationAnchors {\n\t\t\t\tid\n\t\t \t\tpath\n\t\t\t\totVersion\n\t\t \t\tindexStart\n\t\t\t\tindexEnd\n\t\t \t\ttimeCreated\n\t\t\t\ttimeUpdated\n\t\t \t\tisResolved\n\t\t\t\tmessages {\n\t\t \t\t\tid\n\t\t\t \t\ttimeCreated\n\t\t\t \t\ttimeUpdated\n\t\t\t \t\tcontent {\n\t\t\t \t\t\t...on TextMessageContentType {\n\t\t\t\t\t\t\ttext\n\t\t\t\t\t\t}\n\t\t\t \t\t\t...on StatusMessageContentType {\n\t\t\t\t\t\t\tstatus\n\t\t\t\t\t\t}\n\t\t\t \t\t\t...on PreviewMessageContentType {\n\t\t\t\t\t\t\tpreview\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t \t\tuser {\n\t\t\t \t\t\tusername\n\t\t\t\t\t}\n\t\t\t\t\tseen\n\t\t\t\t\tcurrentUserIsAuthor\n\t\t\t\t}\n\t\t \t\tparticipants {\n\t\t\t\t\tusername\n\t\t\t\t}\n\t\t \t\tmessageCount\n\t\t\t\tunreadCount\n\t\t \t\tcurrentUserIsAuthor\n\t\t\t\tisGeneral\n\t\t\t}\n\t\t}}}",
    "clientUser": "query {currentUser {id, username, firstName, lastName, bio, isVerified, displayName, fullName, url, roles {id, name, tagline}, isLoggedIn, timeCreated, isHacker, languages {id}, image, email, state {id, skillLevel, interestedIn}, device {isMobile, isMac}, notificationCount}}",
    "userRepls": "query UserByUsername($username: String!, $count: Int = 50) {userByUsername(username: $username){publicRepls(showUnnamed: true, count: $count){items{id, title, slug, description, isRenamed, user {username}, lang {id}, url, timeCreated, timeUpdated, hostedUrl}}}}",
    "repl": "query Repl($id: String, $url: String) {repl(id: $id, url: $url) {...on Repl {\n\t\t\tid\n\t\t \tisProject\n\t\t \tisPrivate\n\t\t \tisStarred\n\t\t \ttitle\n\t\t \tslug\n\t\t \timageUrl\n\t\t \tfolderId\n\t\t \tisRenamed\n\t\t \tcommentCount\n\t\t \tlikeCount\n\t\t \tcurrentUserDidLike\n\t\t \ttemplateCategory\n\t\t \twasPosted\n\t\t \twasPublished\n\t\t \tlayoutState\n\t\t \tlanguage\n\t\t \towner: user {\n\t\t \t\tid\n\t\t\t\tusername\n\t\t\t\tfirstName\n\t\t\t\tlastName\n\t\t\t\tlocale\n\t\t\t\tisVerified\n\t\t\t\tdisplayName\n\t\t\t\tfullName\n\t\t\t\turl\n\t\t\t\tbio\n\t\t\t\tsocials {\n\t\t\t\t\tid\n\t\t\t \t\turl\n\t\t\t\t\ttype\n\t\t\t\t}\n\t\t\t\troles {\n\t\t\t\t\tid\n\t\t\t \t\tkey\n\t\t\t\t\tname\n\t\t\t \t\ttagline\n\t\t\t\t}\n\t\t\t\tisFollowedByCurrentUser\n\t\t\t\tisFollowingCurrentUser\n\t\t\t\tisBlockedByCurrentUser\n\t\t\t\tisBlockingCurrentUser\n\t\t\t\tisLoggedIn\n\t\t\t\tisSubscribed\n\t\t\t\ttimeCreated\n\t\t\t\tfollowerCount\n\t\t\t\tfollowCount\n\t\t\t\tisHacker\n\t\t\t\timage\n\t\t\t\tcoverImage {\n\t\t\t\t\turl\n\t\t\t \t\toffsetY\n\t\t\t\t}\n\t\t\t\tpresenceStatus {\n\t\t\t\t\tlastSeen\n\t\t\t \t\tisOnline\n\t\t\t\t}\n\t\t\t}\n\t\t\torigin {\n\t\t\t\tid\n\t\t \t\ttitle\n\t\t\t}\n\t\t\tlang {\n\t\t\t\tid\n\t\t \t\tdisplayName\n\t\t \t\tcanUseShellRunner\n\t\t\t}\n\t\t\ticonUrl\n\t\t\ttemplateLabel\n\t\t\turl\n\t\t\tinviteUrl\n\t\t\tmultiplayerInvites {\n\t\t\t\temail\n\t\t \t\treplId\n\t\t\t\ttype\n\t\t\t}\n\t\t\tanalyticsUrl\n\t\t\trootOriginReplUrl\n\t\t\ttimeCreated\n\t\t\ttimeUpdated\n\t\t\tisOwner\n\t\t\tconfig {\n\t\t\t\tisServer\n\t\t \t\tgitRemoteUrl\n\t\t\t\tdomain\n\t\t \t\tisVnc\n\t\t \t\tdoClone\n\t\t\t}\n\t\t\tpinnedToProfile\n\t\t\tsize\n\t\t\thostedUrl\n\t\t\thostedUrlDotty: hostedUrl(dotty: true)\n\t\t\thostedUrlDev: hostedUrl(dev: true)\n\t\t\thostedUrlNoCustom: hostedUrl(noCustomDomain: true)\n\t\t\tterminalUrl\n\t\t\tcurrentUserPermissions {\n\t\t\t\tchangeTitle\n\t\t \t\tchangeDescription\n\t\t\t\tchangeImageUrl\n\t\t \t\tchangeIconUrl\n\t\t\t\tchangeTemplateLabel\n\t\t \t\tchangeLanguage\n\t\t\t\tchangeConfig\n\t\t \t\tchangePrivacy\n\t\t\t\tstar\n\t\t \t\tpin\n\t\t\t\tmove\n\t\t \t\tdelete\n\t\t\t\tleaveMultiplayer\n\t\t \t\teditMultiplayers\n\t\t\t\tviewHistory\t\n\t\t \t\tcontainerAttach\n\t\t\t\tcontainerWrite\n\t\t \t\tchangeAlwaysOn\n\t\t\t\tlinkDomain\n\t\t \t\twriteTests\n\t\t\t\tchangeCommentSettings\n\t\t \t\tinviteGuests\n\t\t\t\tpublish\n\t\t \t\tfork\n\t\t\t}\n\t\t\tdatabase {\n\t\t\t\tid\n\t\t \t\tkeysCount\n\t\t\t\tsizeMB\n\t\t\t\tjwt\n\t\t\t}\n\t\t\ttemplate {\n\t\t\t\tid\n\t\t\t}\n\t\t\tisProjectFork\n\t\t\tisModelSolution\n\t\t\tisModelSolutionFork\n\t\t\tworkspaceCta\n\t\t\tsubmission {\n\t\t\t\tid\n\t\t \t\ttimeSubmitted\n\t\t\t\ttimeLastReviewed\n\t\t \t\tisGroupSubmission\n\t\t\t\tauthor {\n\t\t \t\t\tusername\n\t\t\t\t}\n\t\t \t\tsubmissionGroup {\n\t\t\t\t\tusers {\n\t\t\t\t\t\tusername\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tcommentSettings {\n\t\t\t\tid\n\t\t \t\tenabled\n\t\t\t}\n\t\t\tpublicForkCount\n\t\t\trunCount\n\t\t\tisAlwaysOn\n\t\t\tisBoosted\n\t\t\ttags {\n\t\t\t\tid\n\t\t \t\tisOfficial\n\t\t\t}\n\t\t\tlastPublishedAt\n\t\t\tmultiplayers {\n\t\t\t\tusername\n\t\t\t}\n\t\t\tnixedLanguage\n\t\t\tpublishedAs\n\t\t\tattachments {\n\t\t\t\tid\n\t\t \t\tfileName\n\t\t\t\tmimeType\n\t\t \t\ttimeCreated\n\t\t\t\ttimeUpdated\n\t\t \t\tcontents\n\t\t\t}\n\t\t\tdescription(plainText: true)\n\t\t\tmarkdownDescription: description(plainText: false)\n\t\t\thasExplainCode\n\t\t\thasGenerateCode\n\t\t\ttemplateInfo {\n\t\t\t\tlabel\n\t\t \t\ticonUrl\n\t\t\t}\n\t\t\tdomains {\n\t\t\t\tdomain\n\t\t \t\tstate\n\t\t\t}\n\t\t\tapexProxy\n\t\t\treplViewSettings {\n\t\t\t\tid\n\t\t \t\tdefaultView\n\t\t\t\treplFile\n\t\t \t\treplImage\n\t\t\t}\n\t\t\tpowerUpCosts {\n\t\t\t\t...on UnauthorizedError {\n\t\t \t\t\tmessage\n\t\t\t\t}\n\t\t \t\t...on NotFoundError {\n\t\t\t\t\tmessage\n\t\t\t\t}\n\t\t \t\t...on PowerUpCostsType {\n\t\t\t\t\tboost {\n\t\t\t\t\t\tcycles\n\t\t\t \t\t\texplanation\n\t\t\t\t\t}\n\t\t\t\t\talwaysOn {\n\t\t\t\t\t\tcycles\n\t\t\t \t\t\texplanation\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tisTutorial\n\t\t}}}",
    "notifications": "query notifications($after: String, $count: Int, $seen: Boolean) {notifications(after: $after, count: $count, seen: $seen) {items {...NotificationItems}}}, fragment NotificationItems on Notification {... on BasicNotification {id, ...BasicNotificationItemNotification}, ... on MentionedInPostNotification {id, ...NotificationItemMentionedInPostNotification}, ... on RepliedToPostNotification {id, ...NotificationItemRepliedToPostNotification}, ... on MentionedInCommentNotification {id, ...NotificationItemMentionedInCommentNotification}, ... on RepliedToCommentNotification {id, ...NotificationItemRepliedToCommentNotification}, ... on AnswerAcceptedNotification {id, ...NotificationItemAnswerAcceptedNotification}, ... on MultiplayerInvitedNotification {id, ...NotificationItemMultiplayerInvitedNotification}, ... on MultiplayerJoinedEmailNotification {id, ...NotificationItemMultiplayerJoinedEmailNotification}, ... on MultiplayerJoinedLinkNotification {id, ...NotificationItemMultiplayerJoinedLinkNotification}, ... on MultiplayerOverlimitNotification {id, ...NotificationItemMultiplayerOverlimitNotification}, ... on WarningNotification {id, ...NotificationItemWarningNotification}, ... on AnnotationNotification {id, ...NotificationItemAnnotationNotification}, ... on ThreadNotification {id, ...NotificationItemThreadNotification}, ... on TeamInviteNotification {id, ...NotificationItemTeamInviteNotification}, ... on TeamOrganizationInviteNotification {id, ...NotificationItemTeamOrganizationInviteNotification}, ... on TeamTemplateSubmittedNotification {id, ...NotificationTeamTemplateSubmittedNotification}, ... on TeamTemplateReviewedStatusNotification {id, ...NotificationTeamTemplateReviewedStatusNotification}, ... on EditRequestCreatedNotification {id, __typename}, ... on EditRequestAcceptedNotification {id, __typename}, ... on ReplCommentCreatedNotification {id, ...NotificationReplCommentCreatedNotification}, ... on ReplCommentReplyCreatedNotification {id, ...NotificationReplCommentReplyCreatedNotification}, ... on ReplCommentMentionNotification {id, ...NotificationReplCommentMentionNotification}, ... on NewFollowerNotification {id, ...NotificationItemNewFollower}}, fragment BasicNotificationItemNotification on BasicNotification {id, text, url, timeCreated, seen, context, __typename}, fragment NotificationItemMentionedInPostNotification on MentionedInPostNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, post {id, ...NotificationItemPost, board {id, ...NotificationItemBoard}}, __typename}, fragment NotificationItemCreator on User {username, image, __typename}, fragment NotificationItemPost on Post {id, title, url, __typename}, fragment NotificationItemBoard on Board {id, name, url, color, slug, __typename}, fragment NotificationItemRepliedToPostNotification on RepliedToPostNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, comment {id, post {id, ...NotificationItemPost, board {id, ...NotificationItemBoard}}}, __typename}, fragment NotificationItemMentionedInCommentNotification on MentionedInCommentNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, comment {id, post {id, ...NotificationItemPost, board {id, ...NotificationItemBoard}}}, __typename}, fragment NotificationItemRepliedToCommentNotification on RepliedToCommentNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, comment {id, body, post {id, ...NotificationItemPost, board {id, ...NotificationItemBoard}}}, __typename}, fragment NotificationItemAnswerAcceptedNotification on AnswerAcceptedNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, post {id, ...NotificationItemPost, board {id, ...NotificationItemBoard}}, __typename}, fragment NotificationItemMultiplayerInvitedNotification on MultiplayerInvitedNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, __typename}, fragment NotificationItemMultiplayerJoinedEmailNotification on MultiplayerJoinedEmailNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, __typename}, fragment NotificationItemMultiplayerJoinedLinkNotification on MultiplayerJoinedLinkNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, __typename}, fragment NotificationItemMultiplayerOverlimitNotification on MultiplayerOverlimitNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, __typename}, fragment NotificationItemWarningNotification on WarningNotification {id, text, url, timeCreated, seen, __typename}, fragment NotificationItemAnnotationNotification on AnnotationNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, __typename}, fragment NotificationItemThreadNotification on ThreadNotification {id, text, url, timeCreated, seen, creator {id, ...NotificationItemCreator}, participants {id, ...NotificationItemCreator}, thread {id, repl {id, url, slug, nextPagePathname, user {id, username}}}, __typename}, fragment NotificationItemTeamInviteNotification on TeamInviteNotification {id, text, url, timeCreated, seen, invite {id, ...NotificationItemTeamInvite}, __typename}, fragment NotificationItemTeamInvite on TeamInvite {id, team {id, displayName, username}, __typename}, fragment NotificationItemTeamOrganizationInviteNotification on TeamOrganizationInviteNotification {id, text, url, timeCreated, seen, invite {id, ...NotificationItemTeamOrganizationInvite}, __typename}, fragment NotificationItemTeamOrganizationInvite on TeamOrganizationInvite {id, organization {id, name}, __typename}, fragment NotificationTeamTemplateSubmittedNotification on TeamTemplateSubmittedNotification {id, text, url, timeCreated, seen, repl {id, url}, __typename}, fragment NotificationTeamTemplateReviewedStatusNotification on TeamTemplateReviewedStatusNotification {id, text, url, timeCreated, seen, repl {id, url}, __typename}, fragment NotificationReplCommentCreatedNotification on ReplCommentCreatedNotification {id, url, timeCreated, seen, replComment {id, ...NotificationReplCommentNotificationReplComment}, creator {id, ...NotificationItemCreator}, __typename}, fragment NotificationReplCommentNotificationReplComment on ReplComment {id, repl {title, url}, body, __typename}, fragment NotificationReplCommentReplyCreatedNotification on ReplCommentReplyCreatedNotification {id, timeCreated, seen, creator {id, ...NotificationItemCreator}, replComment {id, ...NotificationReplCommentNotificationReplComment}, __typename}, fragment NotificationReplCommentMentionNotification on ReplCommentMentionNotification {id, timeCreated, seen, creator {id, ...NotificationItemCreator}, replComment {id, parentComment {id, body, user {username, image}}, ...NotificationReplCommentNotificationReplComment}, __typename}, fragment NotificationItemNewFollower on NewFollowerNotification {id, timeCreated, seen, creator {...NotificationItemCreator}, __typename}",
    "replId": "query Repl($id: String!) {repl(id: $id) {... on Repl {id, title, slug, description, lang {id}, url, timeCreated, timeUpdated, hostedUrl}}}",
    "updateRepl": "mutation ReplsDashboardUpdateRepl($input: UpdateReplInput!) {updateRepl(input: $input) {repl {\n\t\t\ttitle\n\t \t\tdescription\n\t\t\timageUrl\n\t \t\ticonUrl\n\t\t\tisPrivate\n\t \t\tisStarred\n\t\t\tlanguage\n\t \t\tslug\n\t\t}}",
    "viewTrash": "query Query {clui {trash {view {...CluiOutput}}}}, fragment CluiOutput on CluiOutput {... on CluiSuccessOutput {message, json}, ... on CluiErrorOutput {error, json}, ... on CluiMarkdownOutput {markdown}, ... on CluiComponentOutput {component}, ... on CluiTableOutput {columns {label, key}, rows}}",
    "sendReplCommentReply": "mutation CreateReplCommentReply($input: CreateReplCommentReplyInput!) {createReplCommentReply(input: $input) {...on UserError {message} ...on ReplComment {\n\t\t\tid\n\t \t\tbody\n\t\t\ttimeCreated\n\t \t\ttimeUpdated\n\t\t\tuser {\n\t \t\t\tusername\n\t\t\t}\n\t \t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\tcanEdit\n\t\t}}}",
    "leaderboard": "query {leaderboard {items {username}}}",
    "replNews": "query ReplNews($count: Int!, $options: ReplPostsQueryOptions!, $username: String!) {\n      pinnedPosts { title repl { url } user { username } }\n      siteBanner { id message }\n      trendingReplPosts(count: $count) { repl { id title url description user { username } } }\n      replPosts(options: $options) { items { repl { title url description user { username } } } }\n      userByUsername(username: $username) { presenceStatus { lastSeen isOnline } }\n    }",
    "trending": "query ReplPosts($options: ReplPostsQueryOptions) {replPosts(options: $options) {\n\t\t\titems {\n\t \t\t\tid\n\t\t \t\ttitle\n\t\t\t\tshowHosted\n\t\t \t\tcommentCount\n\t\t\t\tisPinned\n\t\t \t\tisHidden\n\t\t\t\tisLocked\n\t\t \t\ttimeCreated\n\t\t\t\ttimeUpdated\n\t\t \t\tbody\n\t\t\t\turl\n\t\t \t\tuser {\n\t\t\t\t\tusername\n\t\t\t\t}\n\t\t \t\tboard {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\trepl {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t \t\treplComment {\n\t\t\t\t\tid\n\t\t \t\t\tuser {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}}",
    "follows": "query FollowModalFollows($username: String!, $after: String, $count: Int) {userByUsername(username: $username) {follows(after: $after, count: $count) {\n\t\t\titems {\n\t \t\t\tid\n\t\t\t\tusername\n\t\t\t\tfirstName\n\t\t\t\tlastName\n\t\t\t\tlocale\n\t\t\t\tisVerified\n\t\t\t\tdisplayName\n\t\t\t\tfullName\n\t\t\t\turl\n\t\t\t\tbio\n\t\t\t\tsocials {\n\t\t\t\t\tid\n\t\t\t \t\turl\n\t\t\t\t\ttype\n\t\t\t\t}\n\t\t\t\troles {\n\t\t\t\t\tid\n\t\t\t \t\tkey\n\t\t\t\t\tname\n\t\t\t \t\ttagline\n\t\t\t\t}\n\t\t\t\tisFollowedByCurrentUser\n\t\t\t\tisFollowingCurrentUser\n\t\t\t\tisBlockedByCurrentUser\n\t\t\t\tisBlockingCurrentUser\n\t\t\t\tisLoggedIn\n\t\t\t\tisSubscribed\n\t\t\t\ttimeCreated\n\t\t\t\tfollowerCount\n\t\t\t\tfollowCount\n\t\t\t\tisHacker\n\t\t\t\timage\n\t\t\t\tcoverImage {\n\t\t\t\t\turl\n\t\t\t \t\toffsetY\n\t\t\t\t}\n\t\t\t\tpresenceStatus {\n\t\t\t\t\tlastSeen\n\t\t\t \t\tisOnline\n\t\t\t\t}\n\t\t\t}\n\t \t\tpageInfo {\n\t\t \t\thasNextPage\n\t\t \t\tnextCursor\n\t\t\t}\n\t\t}}}",
    "addMultiplayer": "mutation AddMultiplayerUser($username: String!, $replId: String!, $type: String!) {addMultiplayerUser(username: $username, replId: $replId, type: $type) {id}}",
    "followers": "query FollowModalFollowers($username: String!, $after: String, $count: Int) {userByUsername(username: $username) {followers(after: $after, count: $count) {\n\t\t\titems {\n\t \t\t\tid\n\t\t\t\tusername\n\t\t\t\tfirstName\n\t\t\t\tlastName\n\t\t\t\tlocale\n\t\t\t\tisVerified\n\t\t\t\tdisplayName\n\t\t\t\tfullName\n\t\t\t\turl\n\t\t\t\tbio\n\t\t\t\tsocials {\n\t\t\t\t\tid\n\t\t\t \t\turl\n\t\t\t\t\ttype\n\t\t\t\t}\n\t\t\t\troles {\n\t\t\t\t\tid\n\t\t\t \t\tkey\n\t\t\t\t\tname\n\t\t\t \t\ttagline\n\t\t\t\t}\n\t\t\t\tisFollowedByCurrentUser\n\t\t\t\tisFollowingCurrentUser\n\t\t\t\tisBlockedByCurrentUser\n\t\t\t\tisBlockingCurrentUser\n\t\t\t\tisLoggedIn\n\t\t\t\tisSubscribed\n\t\t\t\ttimeCreated\n\t\t\t\tfollowerCount\n\t\t\t\tfollowCount\n\t\t\t\tisHacker\n\t\t\t\timage\n\t\t\t\tcoverImage {\n\t\t\t\t\turl\n\t\t\t \t\toffsetY\n\t\t\t\t}\n\t\t\t\tpresenceStatus {\n\t\t\t\t\tlastSeen\n\t\t\t \t\tisOnline\n\t\t\t\t}\n\t\t\t}\n\t \t\tpageInfo {\n\t\t \t\thasNextPage\n\t\t \t\tnextCursor\n\t\t\t}\n\t\t}}}",
    "profileRepls": "query ProfilePublicRepls($username: String!, $after: String, $search: String, $count: Int) {user: userByUsername(username: $username) {profileRepls: profileRepls(after: $after, search: $search, count: $count) {\n\t\t\titems {\n\t \t\t\tid\n\t\t\t \tisProject\n\t\t\t \tisPrivate\n\t\t\t \tisStarred\n\t\t\t \ttitle\n\t\t\t \tslug\n\t\t\t \timageUrl\n\t\t\t \tfolderId\n\t\t\t \tisRenamed\n\t\t\t \tcommentCount\n\t\t\t \tlikeCount\n\t\t\t \tcurrentUserDidLike\n\t\t\t \ttemplateCategory\n\t\t\t \twasPosted\n\t\t\t \twasPublished\n\t\t\t \tlayoutState\n\t\t\t \tlanguage\n\t\t\t \towner: user {\n\t\t\t \t\tid\n\t\t\t\t\tusername\n\t\t\t\t\tfirstName\n\t\t\t\t\tlastName\n\t\t\t\t\tlocale\n\t\t\t\t\tisVerified\n\t\t\t\t\tdisplayName\n\t\t\t\t\tfullName\n\t\t\t\t\turl\n\t\t\t\t\tbio\n\t\t\t\t\tsocials {\n\t\t\t\t\t\tid\n\t\t\t\t \t\turl\n\t\t\t\t\t\ttype\n\t\t\t\t\t}\n\t\t\t\t\troles {\n\t\t\t\t\t\tid\n\t\t\t\t \t\tkey\n\t\t\t\t\t\tname\n\t\t\t\t \t\ttagline\n\t\t\t\t\t}\n\t\t\t\t\tisFollowedByCurrentUser\n\t\t\t\t\tisFollowingCurrentUser\n\t\t\t\t\tisBlockedByCurrentUser\n\t\t\t\t\tisBlockingCurrentUser\n\t\t\t\t\tisLoggedIn\n\t\t\t\t\tisSubscribed\n\t\t\t\t\ttimeCreated\n\t\t\t\t\tfollowerCount\n\t\t\t\t\tfollowCount\n\t\t\t\t\tisHacker\n\t\t\t\t\timage\n\t\t\t\t\tcoverImage {\n\t\t\t\t\t\turl\n\t\t\t\t \t\toffsetY\n\t\t\t\t\t}\n\t\t\t\t\tpresenceStatus {\n\t\t\t\t\t\tlastSeen\n\t\t\t\t \t\tisOnline\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\torigin {\n\t\t\t\t\tid\n\t\t\t \t\ttitle\n\t\t\t\t}\n\t\t\t\tlang {\n\t\t\t\t\tid\n\t\t\t \t\tdisplayName\n\t\t\t\t\tcanUseShellRunner\n\t\t\t\t}\n\t\t\t\ticonUrl\n\t\t\t\ttemplateLabel\n\t\t\t\turl\n\t\t\t\tinviteUrl\n\t\t\t\tmultiplayerInvites {\n\t\t\t\t\temail\n\t\t\t \t\treplId\n\t\t\t\t\ttype\n\t\t\t\t}\n\t\t\t\thistoryUrl\n\t\t\t\tanalyticsUrl\n\t\t\t\trootOriginReplUrl\n\t\t\t\ttimeCreated\n\t\t\t\ttimeUpdated\n\t\t\t\tisOwner\n\t\t\t\tconfig {\n\t\t\t\t\tisServer\n\t\t\t \t\tgitRemoteUrl\n\t\t\t\t\tdomain\n\t\t\t \t\tisVnc\n\t\t\t \t\tdoClone\n\t\t\t\t}\n\t\t\t\tpinnedToProfile\n\t\t\t\tsize\n\t\t\t\thostedUrl\n\t\t\t\thostedUrlDotty: hostedUrl(dotty: true)\n\t\t\t\thostedUrlDev: hostedUrl(dev: true)\n\t\t\t\thostedUrlNoCustom: hostedUrl(noCustomDomain: true)\n\t\t\t\tterminalUrl\n\t\t\t\tcurrentUserPermissions {\n\t\t\t\t\tchangeTitle\n\t\t\t \t\tchangeDescription\n\t\t\t\t\tchangeImageUrl\n\t\t\t \t\tchangeIconUrl\n\t\t\t\t\tchangeTemplateLabel\n\t\t\t \t\tchangeLanguage\n\t\t\t\t\tchangeConfig\n\t\t\t \t\tchangePrivacy\n\t\t\t\t\tstar\n\t\t\t \t\tpin\n\t\t\t\t\tmove\n\t\t\t \t\tdelete\n\t\t\t\t\tleaveMultiplayer\n\t\t\t \t\teditMultiplayers\n\t\t\t\t\tviewHistory\t\n\t\t\t \t\tcontainerAttach\n\t\t\t\t\tcontainerWrite\n\t\t\t \t\tchangeAlwaysOn\n\t\t\t\t\tlinkDomain\n\t\t\t \t\twriteTests\n\t\t\t\t\tchangeCommentSettings\n\t\t\t \t\tinviteGuests\n\t\t\t\t\tpublish\n\t\t\t \t\tfork\n\t\t\t\t}\n\t\t\t\tdatabase {\n\t\t\t\t\tid\n\t\t\t \t\tkeysCount\n\t\t\t\t\tsizeMB\n\t\t \t\t\tjwt\n\t\t\t\t}\n\t\t\t\ttemplate {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t\t\tisProjectFork\n\t\t\t\tisModelSolution\n\t\t\t\tisModelSolutionFork\n\t\t\t\tworkspaceCta\n\t\t\t\tsubmission {\n\t\t\t\t\tid\n\t\t\t \t\ttimeSubmitted\n\t\t\t\t\ttimeLastReviewed\n\t\t\t \t\tisGroupSubmission\n\t\t\t\t\tauthor {\n\t\t\t \t\t\tusername\n\t\t\t\t\t}\n\t\t\t \t\tsubmissionGroup {\n\t\t\t\t\t\tusers {\n\t\t\t\t\t\t\tusername\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tcommentSettings {\n\t\t\t\t\tid\n\t\t\t \t\tenabled\n\t\t\t\t}\n\t\t\t\tpublicForkCount\n\t\t\t\trunCount\n\t\t\t\tisAlwaysOn\n\t\t\t\tisBoosted\n\t\t\t\ttags {\n\t\t\t\t\tid\n\t\t\t \t\tisOfficial\n\t\t\t\t}\n\t\t\t\tlastPublishedAt\n\t\t\t\tmultiplayers {\n\t\t\t\t\tusername\n\t\t\t\t}\n\t\t\t\tnixedLanguage\n\t\t\t\tpublishedAs\n\t\t\t\tattachments {\n\t\t\t\t\tid\n\t\t\t \t\tfileName\n\t\t\t\t\tmimeType\n\t\t\t \t\ttimeCreated\n\t\t\t\t\ttimeUpdated\n\t\t\t \t\tcontents\n\t\t\t\t}\n\t\t\t\tdescription(plainText: true)\n\t\t\t\tmarkdownDescription: description(plainText: false)\n\t\t\t\thasExplainCode\n\t\t\t\thasGenerateCode\n\t\t\t\ttemplateInfo {\n\t\t\t\t\tlabel\n\t\t\t \t\ticonUrl\n\t\t\t\t}\n\t\t\t\tdomains {\n\t\t\t\t\tdomain\n\t\t\t \t\tstate\n\t\t\t\t}\n\t\t\t\tapexProxy\n\t\t\t\treplViewSettings {\n\t\t\t\t\tid\n\t\t\t \t\tdefaultView\n\t\t\t\t\treplFile\n\t\t\t \t\treplImage\n\t\t\t\t}\n\t\t\t\tpowerUpCosts {\n\t\t\t\t\t...on UnauthorizedError {\n\t\t\t \t\t\tmessage\n\t\t\t\t\t}\n\t\t\t \t\t...on NotFoundError {\n\t\t\t\t\t\tmessage\n\t\t\t\t\t}\n\t\t\t \t\t...on PowerUpCostsType {\n\t\t\t\t\t\tboost {\n\t\t\t\t\t\t\tcycles\n\t\t\t\t \t\t\texplanation\n\t\t\t\t\t\t}\n\t\t\t\t\t\talwaysOn {\n\t\t\t\t\t\t\tcycles\n\t\t\t\t \t\t\texplanation\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tisTutorial\n\t\t\t},\n\t \t\tpageInfo {\n\t\t\t\thasNextPage\n\t\t\t\tnextCursor\n\t\t\t}\n\t\t}}}",
    "block": "mutation SetBlocking($input: SetBlockingInput!) {setBlocking(input: $input) {... on User {\n\t\t\tisBlockedByCurrentUser\n\t \t}, ... on NotFoundError {message}, ... on UnauthorizedError {message}}}",
    "search": "query Search($options: SearchQueryOptions!) {search(options: $options) {...on UserError {message} ...on UnauthorizedError {message} ...on SearchQueryResults {\n\t\t\treplResults {\n\t \t\t\tresults {\n\t\t \t\t\titems {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t \t\ttemplateResults {\n\t\t\t\tresults {\n\t\t\t\t\titems {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t \t\tfileResults {\n\t\t\t\tresults {\n\t\t\t\t\titems {\n\t\t \t\t\t\trepl {\n\t\t\t \t\t\t\tid\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t \t\tuserResults {\n\t\t\t\tresults {\n\t\t\t\t\titems {\n\t\t\t\t\t\tusername\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t \t\tpostResults {\n\t\t\t\tresults {\n\t\t\t\t\titems {\n\t\t\t\t\t\tid\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t \t\tdocResults {\n\t\t\t\tresults {\n\t\t\t\t\titems {\n\t\t \t\t\t\tpath\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t \t\ttagResults {\n\t\t\t\tresults {\n\t\t\t\t\titems {\n\t\t \t\t\t\ttag {\n\t\t\t \t\t\t\tid\n\t\t\t\t\t\t\tisOfficial\n\t\t\t\t\t\t}\n\t\t\t\t\t\ttimeLastUsed\n\t\t\t\t\t\treplsCount: numReplsTotal\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}}}",
    "dashboardCreateFolder": "mutation ReplsDashboardCreateReplFolder($name: String!, $parentId: String, $teamId: Int) {createReplFolder(name: $name, parentId: $parentId, teamId: $teamId) {id, ...ReplsDashboardFolderItemReplFolder, }}, fragment ReplsDashboardFolderItemReplFolder on ReplFolder {id, name, canEdit, pathnames, image, timeCreated, replsCount, folderType}",
    "replUrl": "query Repl($url: String!) {repl(url: $url) {... on Repl {id, title, slug, description, lang {id}, url, timeCreated, timeUpdated, hostedUrl}}}",
    "forkRepl": "mutation ForkReplCreateRepl($input: CreateReplInput!) {createRepl(input: $input) {... on Repl {id}}}",
    "userComments": "query UserByUsername($username: String!, $count: Int!) {userByUsername(username: $username){comments(count: $count) {items {id, body, voteCount, timeCreated, timeUpdated, user {username}, url, post {id}, parentComment {id}, isAuthor, canEdit, canVote, canComment, hasVoted, canReport, hasReported, isAnswer, canSelectAsAnswer, canUnselectAsAnswer}}}}",
    "sendReplComment": "mutation CreateReplComment($input: CreateReplCommentInput!) {createReplComment(input: $input) {...on UserError {message} ...on ReplComment {\n\t\t\tid\n\t \t\tbody\n\t\t\ttimeCreated\n\t \t\ttimeUpdated\n\t\t\tuser {\n\t \t\t\tusername\n\t\t\t}\n\t\t\tpost {\n\t \t\t\tid\n\t\t\t}\n\t \t\trepl {\n\t\t\t\tid\n\t\t\t}\n\t \t\tcanEdit\n\t\t}}}",
    "dashboardRepls": "query ReplsDashboardReplFolderList($path: String!, $starred: Boolean, $after: String, $count: Int) {currentUser {replFolderByPath(path: $path) {\n\t\t\tid\n\t \t\tuserId\n\t\t\tpathnames\n\t \t\tcanEdit\n\t\t\tcanCreateSubFolders\n\t \t\tparent {id}\n\t\t\tfolders {\n\t\t \t\tid\n\t\t \t\tname\n\t\t \t\tcanEdit\n\t\t \t\tpathnames\n\t\t \t\timage\n\t\t \t\ttimeCreated\n\t\t \t}\n\t\t\trepls(starred: $starred, after: $after, count: $count) {items {\n\t\t\t\tid\n\t\t\t \tisProject\n\t\t\t \tisPrivate\n\t\t\t \tisStarred\n\t\t\t \ttitle\n\t\t\t \tslug\n\t\t\t \timageUrl\n\t\t\t \tfolderId\n\t\t\t \tisRenamed\n\t\t\t \tcommentCount\n\t\t\t \tlikeCount\n\t\t\t \tcurrentUserDidLike\n\t\t\t \ttemplateCategory\n\t\t\t \twasPosted\n\t\t\t \twasPublished\n\t\t\t \tlayoutState\n\t\t\t \tlanguage\n\t\t\t \towner: user {\n\t\t\t \t\tid\n\t\t\t\t\tusername\n\t\t\t\t\tfirstName\n\t\t\t\t\tlastName\n\t\t\t\t\tlocale\n\t\t\t\t\tisVerified\n\t\t\t\t\tdisplayName\n\t\t\t\t\tfullName\n\t\t\t\t\turl\n\t\t\t\t\tbio\n\t\t\t\t\tsocials {\n\t\t\t\t\t\tid\n\t\t\t\t \t\turl\n\t\t\t\t\t\ttype\n\t\t\t\t\t}\n\t\t\t\t\troles {\n\t\t\t\t\t\tid\n\t\t\t\t \t\tkey\n\t\t\t\t\t\tname\n\t\t\t\t \t\ttagline\n\t\t\t\t\t}\n\t\t\t\t\tisFollowedByCurrentUser\n\t\t\t\t\tisFollowingCurrentUser\n\t\t\t\t\tisBlockedByCurrentUser\n\t\t\t\t\tisBlockingCurrentUser\n\t\t\t\t\tisLoggedIn\n\t\t\t\t\tisSubscribed\n\t\t\t\t\ttimeCreated\n\t\t\t\t\tfollowerCount\n\t\t\t\t\tfollowCount\n\t\t\t\t\tisHacker\n\t\t\t\t\timage\n\t\t\t\t\tcoverImage {\n\t\t\t\t\t\turl\n\t\t\t\t \t\toffsetY\n\t\t\t\t\t}\n\t\t\t\t\tpresenceStatus {\n\t\t\t\t\t\tlastSeen\n\t\t\t\t \t\tisOnline\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\torigin {\n\t\t\t\t\tid\n\t\t\t \t\ttitle\n\t\t\t\t}\n\t\t\t\tlang {\n\t\t\t\t\tid\n\t\t\t \t\tdisplayName\n\t\t\t\t\tcanUseShellRunner\n\t\t\t\t}\n\t\t\t\ticonUrl\n\t\t\t\ttemplateLabel\n\t\t\t\turl\n\t\t\t\tinviteUrl\n\t\t\t\tmultiplayerInvites {\n\t\t\t\t\temail\n\t\t\t \t\treplId\n\t\t\t\t\ttype\n\t\t\t\t}\n\t\t\t\thistoryUrl\n\t\t\t\tanalyticsUrl\n\t\t\t\trootOriginReplUrl\n\t\t\t\ttimeCreated\n\t\t\t\ttimeUpdated\n\t\t\t\tisOwner\n\t\t\t\tconfig {\n\t\t\t\t\tisServer\n\t\t\t \t\tgitRemoteUrl\n\t\t\t\t\tdomain\n\t\t\t \t\tisVnc\n\t\t\t \t\tdoClone\n\t\t\t\t}\n\t\t\t\tpinnedToProfile\n\t\t\t\tsize\n\t\t\t\thostedUrl\n\t\t\t\thostedUrlDotty: hostedUrl(dotty: true)\n\t\t\t\thostedUrlDev: hostedUrl(dev: true)\n\t\t\t\thostedUrlNoCustom: hostedUrl(noCustomDomain: true)\n\t\t\t\tterminalUrl\n\t\t\t\tcurrentUserPermissions {\n\t\t\t\t\tchangeTitle\n\t\t\t \t\tchangeDescription\n\t\t\t\t\tchangeImageUrl\n\t\t\t \t\tchangeIconUrl\n\t\t\t\t\tchangeTemplateLabel\n\t\t\t \t\tchangeLanguage\n\t\t\t\t\tchangeConfig\n\t\t\t \t\tchangePrivacy\n\t\t\t\t\tstar\n\t\t\t \t\tpin\n\t\t\t\t\tmove\n\t\t\t \t\tdelete\n\t\t\t\t\tleaveMultiplayer\n\t\t\t \t\teditMultiplayers\n\t\t\t\t\tviewHistory\t\n\t\t\t \t\tcontainerAttach\n\t\t\t\t\tcontainerWrite\n\t\t\t \t\tchangeAlwaysOn\n\t\t\t\t\tlinkDomain\n\t\t\t \t\twriteTests\n\t\t\t\t\tchangeCommentSettings\n\t\t\t \t\tinviteGuests\n\t\t\t\t\tpublish\n\t\t\t \t\tfork\n\t\t\t\t}\n\t\t\t\tdatabase {\n\t\t\t\t\tid\n\t\t\t \t\tkeysCount\n\t\t\t\t\tsizeMB\n\t\t \t\t\tjwt\n\t\t\t\t}\n\t\t\t\ttemplate {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t\t\tisProjectFork\n\t\t\t\tisModelSolution\n\t\t\t\tisModelSolutionFork\n\t\t\t\tworkspaceCta\n\t\t\t\tsubmission {\n\t\t\t\t\tid\n\t\t\t \t\ttimeSubmitted\n\t\t\t\t\ttimeLastReviewed\n\t\t\t \t\tisGroupSubmission\n\t\t\t\t\tauthor {\n\t\t\t \t\t\tusername\n\t\t\t\t\t}\n\t\t\t \t\tsubmissionGroup {\n\t\t\t\t\t\tusers {\n\t\t\t\t\t\t\tusername\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tcommentSettings {\n\t\t\t\t\tid\n\t\t\t \t\tenabled\n\t\t\t\t}\n\t\t\t\tpublicForkCount\n\t\t\t\trunCount\n\t\t\t\tisAlwaysOn\n\t\t\t\tisBoosted\n\t\t\t\ttags {\n\t\t\t\t\tid\n\t\t\t \t\tisOfficial\n\t\t\t\t}\n\t\t\t\tlastPublishedAt\n\t\t\t\tmultiplayers {\n\t\t\t\t\tusername\n\t\t\t\t}\n\t\t\t\tnixedLanguage\n\t\t\t\tpublishedAs\n\t\t\t\tattachments {\n\t\t\t\t\tid\n\t\t\t \t\tfileName\n\t\t\t\t\tmimeType\n\t\t\t \t\ttimeCreated\n\t\t\t\t\ttimeUpdated\n\t\t\t \t\tcontents\n\t\t\t\t}\n\t\t\t\tdescription(plainText: true)\n\t\t\t\tmarkdownDescription: description(plainText: false)\n\t\t\t\thasExplainCode\n\t\t\t\thasGenerateCode\n\t\t\t\ttemplateInfo {\n\t\t\t\t\tlabel\n\t\t\t \t\ticonUrl\n\t\t\t\t}\n\t\t\t\tdomains {\n\t\t\t\t\tdomain\n\t\t\t \t\tstate\n\t\t\t\t}\n\t\t\t\tapexProxy\n\t\t\t\treplViewSettings {\n\t\t\t\t\tid\n\t\t\t \t\tdefaultView\n\t\t\t\t\treplFile\n\t\t\t \t\treplImage\n\t\t\t\t}\n\t\t\t\tpowerUpCosts {\n\t\t\t\t\t...on UnauthorizedError {\n\t\t\t \t\t\tmessage\n\t\t\t\t\t}\n\t\t\t \t\t...on NotFoundError {\n\t\t\t\t\t\tmessage\n\t\t\t\t\t}\n\t\t\t \t\t...on PowerUpCostsType {\n\t\t\t\t\t\tboost {\n\t\t\t\t\t\t\tcycles\n\t\t\t\t \t\t\texplanation\n\t\t\t\t\t\t}\n\t\t\t\t\t\talwaysOn {\n\t\t\t\t\t\t\tcycles\n\t\t\t\t \t\t\texplanation\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tisTutorial\n\t\t\t}\n\t \t\tpageInfo {nextCursor}\n\t\t}}}}",
    "follow": "mutation SetFollowing($input: setFollowingInput!) {setFollowing(input: $input) {... on FollowResult {targetUser {\n\t\t\tisFollowedByCurrentUser, followerCount\n\t \t}}, ... on NotFoundError {message}, ... on UnauthorizedError {message}, ... on UserError {message}}}",
    "restoreRepl": "mutation Mutation($title: String!) {clui {trash {restore(title: $title) {...CluiOutput}}}}, fragment CluiOutput on CluiOutput {... on CluiSuccessOutput {message, json}, ... on CluiErrorOutput {error, json}, ... on CluiMarkdownOutput {markdown}, ... on CluiComponentOutput {component}, ... on CluiTableOutput {columns {label, key}, rows}}",
    "login": "'mutation Login($username: String!, $password: String!) {\n  login(username: $username, password: $password) {\n    ... on Auth {\n      token\n      user {\n        email\n        username\n      }\n    }\n\n    ... on UserError {\n      message\n    }\n\n\t\t__typename\n  }\n}'",
    "usersWhoLikedRepl": "query Votes($url: String, $after: String) {repl(url: $url) {...on Repl {posts(count: 100) {items {votes(count: 100, after: $after) {items {user {username}} pageInfo {nextCursor}}}}}}}",
    "generateCode": """query GenerateCode($input: GenerateCodeInput!) {currentUser{id}generateCode(input: $input){...on GenerateCodeResult{code}}}""",
    "reportRepl": """mutation ReportRepl($replId: String, $reason: String!) { createBoardReport(replId: $replId, reason: $reason) { id } }""",
}
