pyrae
=====

Perform searches against the RAE dictionary.
--------------------------------------------
**pyrae** is a simple library providing functionality to
search for words or terms in the RAE (Real Academia
Española) online dictionary.

The RAE does not provide a public API, so this library
makes HTML requests to the dle.rae.es domain and parses
the responses to assemble the search results.

Installation
------------
The easiest is to use pip, so that :

```
$ pip install pyrae
```

Usage
-----
To search for a word or term in Spanish:

```
>>> from pyrae import dle
>>> res = dle.search_by_word(word='hola')
>>> res.to_dict()
{'title': 'hola | Definición | Diccionario de la lengua española | RAE - ASALE', 'articles': [{'id': 'KYtLWBc', 'lema': {'lema': 'hola', 'index': 0, 'female_suffix': ''}, 'supplementary_info': [{'text': 'Voz expr. (Voz expresiva); cf. (confer) ingl. (inglés o inglesa) hello, al. (alemán o alemana) hallo.'}], 'definitions': [{'index': 1, 'category': {'abbr': 'interj.', 'text': 'interjección'}, 'abbreviations': [{'abbr': 'U.', 'text': 'Usado, usada, usados o usadas'}], 'sentence': {'text': 'como salutación familiar.'}, 'examples': []}, {'index': 2, 'category': {'abbr': 'interj.', 'text': 'interjección'}, 'abbreviations': [{'abbr': 'p. us.', 'text': 'poco usado o usada, poco usados o usadas'}, {'abbr': 'U.', 'text': 'Usado, usada, usados o usadas'}, {'abbr': 'U. t. repetida.', 'text': 'Usada también repetida'}], 'sentence': {'text': 'para denotar extrañeza, placentera o desagradable.'}, 'examples': []}, {'index': 3, 'category': {'abbr': 'interj.', 'text': 'interjección'}, 'abbreviations': [{'abbr': 'desus.', 'text': 'desusado, desusada, desusados o desusadas'}, {'abbr': 'Era u.', 'text': 'Era usado o usada'}], 'sentence': {'text': 'para llamar a los inferiores.'}, 'examples': []}], 'complex_forms': [], 'other_entries': []}]}
```

Starting from version 0.1.2 if the functions in the **dle** module are used,
the search results are cached automatically in memory. The caching functionality
is provided by [dogpile.cache](https://github.com/sqlalchemy/dogpile.cache).

The **dle** module defines a `cache_region` attribute that by default is a
dogpile.cache region in memory with an expiration of 1 day. You
can re-define the `cache_region` to create a region that better suits
your needs (like caching values in disk instead of memory and using a
different expiration value). Refer to the dogpile.cache documentation
to understand how cache regions work.

Here is an example of 2 consecutive calls of the `dle.search_by_word`
function. Note the second time it runs how the execution is
almost immediate:

```
import time
from pyrae import dle

for i in range(0, 2):
    start = time.monotonic()
    result = dle.search_by_word(word='silla')
    end = time.monotonic()
    print(result.to_dict())
    print(f'Took {end - start} seconds')
```

Executing that code returns:

```
{'title': 'silla | Definición | Diccionario de la lengua española | RAE - ASALE', 'articles': [{'id': 'XtQvCwh', 'lema': {'lema': 'silla', 'index': 0, 'female_suffix': ''}, 'supplementary_info': [{'text': 'Del lat. (latín) sella.'}], 'is': {'verb': False}, 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Asiento con respaldo, por lo general con cuatro patas, y en que solo cabe una persona.'}, 'examples': []}, {'index': 2, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'silla de niño.'}, 'examples': []}, {'index': 3, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Aparejo para montar a caballo, formado por una armazón de madera, cubierta generalmente de cuero y rellena de crin o pelote.'}, 'examples': []}, {'index': 4, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'sede (‖ asiento de un prelado).'}, 'examples': []}, {'index': 5, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Dignidad de papa y otras eclesiásticas.'}, 'examples': []}, {'index': 6, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'coloq.', 'text': 'coloquial'}], 'sentence': {'text': 'ano.'}, 'examples': []}], 'complex_forms': [{'lema': {'lema': 'silla bastarda'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'usada en tiempos antiguos, y que se distinguía principalmente porque en ella se llevaban las piernas menos estiradas que cabalgando a la brida y más que cabalgando a la jineta.'}, 'examples': []}]}, {'lema': {'lema': 'silla curul'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Asiento semicircular con incrustaciones de marfil que ocupaban los ediles romanos.'}, 'examples': []}]}, {'lema': {'lema': 'silla de caderas'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f. desus.', 'text': 'nombre femenino desusado'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'con respaldo y brazos para recostarse.'}, 'examples': []}]}, {'lema': {'lema': 'silla de extensión'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'Cuba y Ven.', 'text': 'Cuba y Venezuela'}], 'sentence': {'text': 'tumbona.'}, 'examples': []}]}, {'lema': {'lema': 'silla de la reina'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Asiento que forman entre dos personas con las cuatro manos, asiendo cada uno su muñeca y la del otro.'}, 'examples': []}]}, {'lema': {'lema': 'silla de manos'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Vehículo con asiento para una persona, a manera de caja de coche, y el cual, sostenido en dos varas largas, era llevado por hombres.'}, 'examples': []}, {'index': 2, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'Chile, Col., C. Rica y R. Dom.', 'text': 'Chile, Colombia, Costa Rica y República Dominicana'}], 'sentence': {'text': 'silla de la reina.'}, 'examples': []}]}, {'lema': {'lema': 'silla de montar'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'silla (‖ aparejo para montar a caballo).'}, 'examples': []}]}, {'lema': {'lema': 'silla de niño'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'baja sobre ruedas, que, empujada por una persona, permite transportar a un niño acostado o sentado.'}, 'examples': []}]}, {'lema': {'lema': 'silla de posta'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Carruaje, de dos o de cuatro ruedas, en que se corría la posta.'}, 'examples': []}]}, {'lema': {'lema': 'silla de ruedas'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que, con ruedas laterales grandes, permite que se desplace una persona imposibilitada.'}, 'examples': []}]}, {'lema': {'lema': 'silla de tijera'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que tiene el asiento por lo general de tela y las patas cruzadas en aspa de manera que puede plegarse.'}, 'examples': []}]}, {'lema': {'lema': 'silla eléctrica'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que se usa para electrocutar a los condenados a muerte.'}, 'examples': []}]}, {'lema': {'lema': 'silla gestatoria'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'portátil que usa el papa en ciertos actos de gran ceremonia.'}, 'examples': []}]}, {'lema': {'lema': 'silla jineta'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que sirve para montar a la jineta y que solo se distingue de la común en que los borrenes son más altos y menos distantes, las aciones más cortas y mayores los estribos.'}, 'examples': []}]}, {'lema': {'lema': 'silla poltrona'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'más baja de brazos que la común, y de más amplitud y comodidad.'}, 'examples': []}]}, {'lema': {'lema': 'silla turca'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'Anat.', 'text': 'Anatomía'}], 'sentence': {'text': 'Escotadura en forma de  que ofrece el hueso esfenoides.'}, 'examples': []}]}, {'lema': {'lema': 'silla volante'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Carruaje de dos ruedas y de dos asientos, puesto sobre dos varas, de que regularmente tira un caballo, sobre cuyo sillín entra el correón.'}, 'examples': []}]}, {'lema': {'lema': 'dar silla alguien a otra persona'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb.', 'text': 'locución verbal'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Hacer que se siente en su presencia.'}, 'examples': []}]}, {'lema': {'lema': 'de silla a silla'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. adv.', 'text': 'locución adverbial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Dicho del modo de hablar de dos o más personas: En conferencia privada.'}, 'examples': []}]}, {'lema': {'lema': 'mover la silla a alguien'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Intrigar para hacerle perder su puesto.'}, 'examples': []}]}, {'lema': {'lema': 'no ser alguien para silla ni para albarda'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'No ser a propósito para algo, o ser enteramente inhábil.'}, 'examples': []}]}, {'lema': {'lema': 'pegársele a alguien la silla'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Estarse mucho tiempo en una parte, detenerse mucho en una visita.'}, 'examples': []}]}, {'lema': {'lema': 'quitar la silla a alguien'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Hacerle perder su puesto.'}, 'examples': []}]}], 'other_entries': [{'text': 'caballo de silla', 'link': 'https://dle.rae.es/?id=6OPHOdx#6j0NIIB'}, {'text': 'juez de silla', 'link': 'https://dle.rae.es/?id=MaZWBEH#Cpn7hEN'}, {'text': 'obispo de la primera silla', 'link': 'https://dle.rae.es/?id=QmRzobj#2nccCmf'}]}]}
Took 1.367619363 seconds
{'title': 'silla | Definición | Diccionario de la lengua española | RAE - ASALE', 'articles': [{'id': 'XtQvCwh', 'lema': {'lema': 'silla', 'index': 0, 'female_suffix': ''}, 'supplementary_info': [{'text': 'Del lat. (latín) sella.'}], 'is': {'verb': False}, 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Asiento con respaldo, por lo general con cuatro patas, y en que solo cabe una persona.'}, 'examples': []}, {'index': 2, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'silla de niño.'}, 'examples': []}, {'index': 3, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Aparejo para montar a caballo, formado por una armazón de madera, cubierta generalmente de cuero y rellena de crin o pelote.'}, 'examples': []}, {'index': 4, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'sede (‖ asiento de un prelado).'}, 'examples': []}, {'index': 5, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Dignidad de papa y otras eclesiásticas.'}, 'examples': []}, {'index': 6, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'coloq.', 'text': 'coloquial'}], 'sentence': {'text': 'ano.'}, 'examples': []}], 'complex_forms': [{'lema': {'lema': 'silla bastarda'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'usada en tiempos antiguos, y que se distinguía principalmente porque en ella se llevaban las piernas menos estiradas que cabalgando a la brida y más que cabalgando a la jineta.'}, 'examples': []}]}, {'lema': {'lema': 'silla curul'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Asiento semicircular con incrustaciones de marfil que ocupaban los ediles romanos.'}, 'examples': []}]}, {'lema': {'lema': 'silla de caderas'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f. desus.', 'text': 'nombre femenino desusado'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'con respaldo y brazos para recostarse.'}, 'examples': []}]}, {'lema': {'lema': 'silla de extensión'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'Cuba y Ven.', 'text': 'Cuba y Venezuela'}], 'sentence': {'text': 'tumbona.'}, 'examples': []}]}, {'lema': {'lema': 'silla de la reina'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Asiento que forman entre dos personas con las cuatro manos, asiendo cada uno su muñeca y la del otro.'}, 'examples': []}]}, {'lema': {'lema': 'silla de manos'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Vehículo con asiento para una persona, a manera de caja de coche, y el cual, sostenido en dos varas largas, era llevado por hombres.'}, 'examples': []}, {'index': 2, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'Chile, Col., C. Rica y R. Dom.', 'text': 'Chile, Colombia, Costa Rica y República Dominicana'}], 'sentence': {'text': 'silla de la reina.'}, 'examples': []}]}, {'lema': {'lema': 'silla de montar'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'silla (‖ aparejo para montar a caballo).'}, 'examples': []}]}, {'lema': {'lema': 'silla de niño'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'baja sobre ruedas, que, empujada por una persona, permite transportar a un niño acostado o sentado.'}, 'examples': []}]}, {'lema': {'lema': 'silla de posta'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Carruaje, de dos o de cuatro ruedas, en que se corría la posta.'}, 'examples': []}]}, {'lema': {'lema': 'silla de ruedas'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que, con ruedas laterales grandes, permite que se desplace una persona imposibilitada.'}, 'examples': []}]}, {'lema': {'lema': 'silla de tijera'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que tiene el asiento por lo general de tela y las patas cruzadas en aspa de manera que puede plegarse.'}, 'examples': []}]}, {'lema': {'lema': 'silla eléctrica'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que se usa para electrocutar a los condenados a muerte.'}, 'examples': []}]}, {'lema': {'lema': 'silla gestatoria'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'portátil que usa el papa en ciertos actos de gran ceremonia.'}, 'examples': []}]}, {'lema': {'lema': 'silla jineta'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'que sirve para montar a la jineta y que solo se distingue de la común en que los borrenes son más altos y menos distantes, las aciones más cortas y mayores los estribos.'}, 'examples': []}]}, {'lema': {'lema': 'silla poltrona'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'más baja de brazos que la común, y de más amplitud y comodidad.'}, 'examples': []}]}, {'lema': {'lema': 'silla turca'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [{'abbr': 'Anat.', 'text': 'Anatomía'}], 'sentence': {'text': 'Escotadura en forma de  que ofrece el hueso esfenoides.'}, 'examples': []}]}, {'lema': {'lema': 'silla volante'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'f.', 'text': 'nombre femenino'}, 'is': {'adjective': False, 'adverb': False, 'noun': True, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Carruaje de dos ruedas y de dos asientos, puesto sobre dos varas, de que regularmente tira un caballo, sobre cuyo sillín entra el correón.'}, 'examples': []}]}, {'lema': {'lema': 'dar silla alguien a otra persona'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb.', 'text': 'locución verbal'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Hacer que se siente en su presencia.'}, 'examples': []}]}, {'lema': {'lema': 'de silla a silla'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. adv.', 'text': 'locución adverbial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Dicho del modo de hablar de dos o más personas: En conferencia privada.'}, 'examples': []}]}, {'lema': {'lema': 'mover la silla a alguien'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Intrigar para hacerle perder su puesto.'}, 'examples': []}]}, {'lema': {'lema': 'no ser alguien para silla ni para albarda'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'No ser a propósito para algo, o ser enteramente inhábil.'}, 'examples': []}]}, {'lema': {'lema': 'pegársele a alguien la silla'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Estarse mucho tiempo en una parte, detenerse mucho en una visita.'}, 'examples': []}]}, {'lema': {'lema': 'quitar la silla a alguien'}, 'supplementary_info': [], 'definitions': [{'index': 1, 'category': {'abbr': 'loc. verb. coloq.', 'text': 'locución verbal coloquial'}, 'is': {'adjective': False, 'adverb': False, 'noun': False, 'pronoun': False, 'verb': False}, 'abbreviations': [], 'sentence': {'text': 'Hacerle perder su puesto.'}, 'examples': []}]}], 'other_entries': [{'text': 'caballo de silla', 'link': 'https://dle.rae.es/?id=6OPHOdx#6j0NIIB'}, {'text': 'juez de silla', 'link': 'https://dle.rae.es/?id=MaZWBEH#Cpn7hEN'}, {'text': 'obispo de la primera silla', 'link': 'https://dle.rae.es/?id=QmRzobj#2nccCmf'}]}]}
Took 0.00011630299999998428 seconds
```

Other use cases offered by the RAE will be covered in future versions.