
from typeguard import typechecked
from azure.common.credentials import ServicePrincipalCredentials
from azure.mgmt.compute import ComputeManagementClient
from benchmark_runner.common.logger.logger_time_stamp import logger_time_stamp, logger


class AzureOperations:
    """
    This class is responsible to all the operations against Azure vms
    """
    def __init__(self, azure_clientid: str, azure_secret: str, azure_tenantid: str, azure_subscriptionid: str, azure_resource_group_name: str):
        self.__azure_clientid = azure_clientid
        self.__azure_secret = azure_secret
        self.__azure_tenantid = azure_tenantid
        self.__azure_subscriptionid = azure_subscriptionid
        self.__azure_resource_group_name = azure_resource_group_name
        self.__credentials = ServicePrincipalCredentials(client_id=self.__azure_clientid, secret=self.__azure_secret,
                                                         tenant=self.__azure_tenantid)
        self.__compute_client = ComputeManagementClient(self.__credentials, self.__azure_subscriptionid)

    @typechecked()
    @logger_time_stamp
    def restart_vm(self, vm_name: str = ''):
        """
        This method restart azure vm
        :return:
        """
        vm_restart = self.__compute_client.virtual_machines.restart(self.__azure_resource_group_name, vm_name)
        logger.info('Waiting till VM restart')
        vm_restart.wait()
        vm_instance = self.__compute_client.virtual_machines.get(self.__azure_resource_group_name, vm_name)
        return vm_instance

    @typechecked()
    @logger_time_stamp
    def start_vm(self, vm_name: str = ''):
        """
        This method start azure vm
        :return:
        """
        vm_start = self.__compute_client.virtual_machines.start(self.__azure_resource_group_name, vm_name)
        logger.info('Waiting till VM running')
        vm_start.wait()
        vm_instance = self.__compute_client.virtual_machines.get(self.__azure_resource_group_name, vm_name)
        return vm_instance

    @typechecked()
    @logger_time_stamp
    def stop_vm(self, vm_name: str = ''):
        """
        This method stop azure vm
        :return:
        """
        vm_stop = self.__compute_client.virtual_machines.deallocate(self.__azure_resource_group_name, vm_name)
        logger.info('Waiting till VM Stopped (deallocated)')
        vm_stop.wait()
        vm_instance = self.__compute_client.virtual_machines.get(self.__azure_resource_group_name, vm_name)
        return vm_instance

    @typechecked()
    @logger_time_stamp
    def get_vm_status(self, vm_name: str = ''):
        """
        This method return vm status
        :return:
        """
        vm_instance = self.__compute_client.virtual_machines.get(self.__azure_resource_group_name, vm_name)
        return vm_instance
