# coding: utf-8

"""
    Mainnet Cash

    A developer friendly bitcoin cash wallet api  This API is currently in *active* development, breaking changes may be made prior to official release of version 1.0.0.   # noqa: E501

    The version of the OpenAPI document: 0.4.23
    Contact: hello@mainnet.cash
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mainnet.api_client import ApiClient
from mainnet.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SmartbchSep20Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def smart_bch_sep20_balance(self, smart_bch_sep20_balance_request, **kwargs):  # noqa: E501
        """Get total SmartBch SEP20 token balance of the wallet  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_balance(smart_bch_sep20_balance_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_balance_request: Request for a wallet SmartBch SEP20 token balance  (required)
        :type smart_bch_sep20_balance_request: SmartBchSep20BalanceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SmartBchSep20BalanceResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_balance_with_http_info(smart_bch_sep20_balance_request, **kwargs)  # noqa: E501

    def smart_bch_sep20_balance_with_http_info(self, smart_bch_sep20_balance_request, **kwargs):  # noqa: E501
        """Get total SmartBch SEP20 token balance of the wallet  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_balance_with_http_info(smart_bch_sep20_balance_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_balance_request: Request for a wallet SmartBch SEP20 token balance  (required)
        :type smart_bch_sep20_balance_request: SmartBchSep20BalanceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SmartBchSep20BalanceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'smart_bch_sep20_balance_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_balance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'smart_bch_sep20_balance_request' is set
        if self.api_client.client_side_validation and ('smart_bch_sep20_balance_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['smart_bch_sep20_balance_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `smart_bch_sep20_balance_request` when calling `smart_bch_sep20_balance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smart_bch_sep20_balance_request' in local_var_params:
            body_params = local_var_params['smart_bch_sep20_balance_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/balance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartBchSep20BalanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_deposit_address(self, serialized_wallet, **kwargs):  # noqa: E501
        """Get an SmartBch SEP20 deposit address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_deposit_address(serialized_wallet, async_req=True)
        >>> result = thread.get()

        :param serialized_wallet: Request for an SmartBch SEP20 deposit address given a wallet  (required)
        :type serialized_wallet: SerializedWallet
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SmartBchDepositAddressResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_deposit_address_with_http_info(serialized_wallet, **kwargs)  # noqa: E501

    def smart_bch_sep20_deposit_address_with_http_info(self, serialized_wallet, **kwargs):  # noqa: E501
        """Get an SmartBch SEP20 deposit address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_deposit_address_with_http_info(serialized_wallet, async_req=True)
        >>> result = thread.get()

        :param serialized_wallet: Request for an SmartBch SEP20 deposit address given a wallet  (required)
        :type serialized_wallet: SerializedWallet
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SmartBchDepositAddressResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'serialized_wallet'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_deposit_address" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'serialized_wallet' is set
        if self.api_client.client_side_validation and ('serialized_wallet' not in local_var_params or  # noqa: E501
                                                        local_var_params['serialized_wallet'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `serialized_wallet` when calling `smart_bch_sep20_deposit_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'serialized_wallet' in local_var_params:
            body_params = local_var_params['serialized_wallet']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/deposit_address', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartBchDepositAddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_deposit_qr(self, serialized_wallet, **kwargs):  # noqa: E501
        """Get an SmartBch SEP20 receiving address as a qrcode  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_deposit_qr(serialized_wallet, async_req=True)
        >>> result = thread.get()

        :param serialized_wallet: Request for a SmartBch SEP20 deposit address as a Quick Response code (qrcode)  (required)
        :type serialized_wallet: SerializedWallet
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScalableVectorGraphic
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_deposit_qr_with_http_info(serialized_wallet, **kwargs)  # noqa: E501

    def smart_bch_sep20_deposit_qr_with_http_info(self, serialized_wallet, **kwargs):  # noqa: E501
        """Get an SmartBch SEP20 receiving address as a qrcode  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_deposit_qr_with_http_info(serialized_wallet, async_req=True)
        >>> result = thread.get()

        :param serialized_wallet: Request for a SmartBch SEP20 deposit address as a Quick Response code (qrcode)  (required)
        :type serialized_wallet: SerializedWallet
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ScalableVectorGraphic, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'serialized_wallet'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_deposit_qr" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'serialized_wallet' is set
        if self.api_client.client_side_validation and ('serialized_wallet' not in local_var_params or  # noqa: E501
                                                        local_var_params['serialized_wallet'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `serialized_wallet` when calling `smart_bch_sep20_deposit_qr`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'serialized_wallet' in local_var_params:
            body_params = local_var_params['serialized_wallet']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/deposit_qr', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScalableVectorGraphic',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_genesis(self, smart_bch_sep20_genesis_request, **kwargs):  # noqa: E501
        """Get created tokenId back and new SmartBch SEP20 token balance of the wallet  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_genesis(smart_bch_sep20_genesis_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_genesis_request: Request to create a new SmartBch SEP20 token (genesis)  (required)
        :type smart_bch_sep20_genesis_request: SmartBchSep20GenesisRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SmartBchSep20GenesisResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_genesis_with_http_info(smart_bch_sep20_genesis_request, **kwargs)  # noqa: E501

    def smart_bch_sep20_genesis_with_http_info(self, smart_bch_sep20_genesis_request, **kwargs):  # noqa: E501
        """Get created tokenId back and new SmartBch SEP20 token balance of the wallet  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_genesis_with_http_info(smart_bch_sep20_genesis_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_genesis_request: Request to create a new SmartBch SEP20 token (genesis)  (required)
        :type smart_bch_sep20_genesis_request: SmartBchSep20GenesisRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SmartBchSep20GenesisResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'smart_bch_sep20_genesis_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_genesis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'smart_bch_sep20_genesis_request' is set
        if self.api_client.client_side_validation and ('smart_bch_sep20_genesis_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['smart_bch_sep20_genesis_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `smart_bch_sep20_genesis_request` when calling `smart_bch_sep20_genesis`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smart_bch_sep20_genesis_request' in local_var_params:
            body_params = local_var_params['smart_bch_sep20_genesis_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/genesis', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartBchSep20GenesisResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_mint(self, smart_bch_sep20_mint_request, **kwargs):  # noqa: E501
        """Get created tokenId back and new SmartBch SEP20 token balance of the wallet  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_mint(smart_bch_sep20_mint_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_mint_request: Request to mint more of SmartBch SEP20 tokens  (required)
        :type smart_bch_sep20_mint_request: SmartBchSep20MintRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SmartBchSep20MintResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_mint_with_http_info(smart_bch_sep20_mint_request, **kwargs)  # noqa: E501

    def smart_bch_sep20_mint_with_http_info(self, smart_bch_sep20_mint_request, **kwargs):  # noqa: E501
        """Get created tokenId back and new SmartBch SEP20 token balance of the wallet  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_mint_with_http_info(smart_bch_sep20_mint_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_mint_request: Request to mint more of SmartBch SEP20 tokens  (required)
        :type smart_bch_sep20_mint_request: SmartBchSep20MintRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SmartBchSep20MintResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'smart_bch_sep20_mint_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_mint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'smart_bch_sep20_mint_request' is set
        if self.api_client.client_side_validation and ('smart_bch_sep20_mint_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['smart_bch_sep20_mint_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `smart_bch_sep20_mint_request` when calling `smart_bch_sep20_mint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smart_bch_sep20_mint_request' in local_var_params:
            body_params = local_var_params['smart_bch_sep20_mint_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/mint', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartBchSep20MintResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_send(self, smart_bch_sep20_send_request, **kwargs):  # noqa: E501
        """Send some SmartBch SEP20 token amount to a given address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_send(smart_bch_sep20_send_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_send_request: place a SmartBch SEP20 token send request (required)
        :type smart_bch_sep20_send_request: SmartBchSep20SendRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[object]
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_send_with_http_info(smart_bch_sep20_send_request, **kwargs)  # noqa: E501

    def smart_bch_sep20_send_with_http_info(self, smart_bch_sep20_send_request, **kwargs):  # noqa: E501
        """Send some SmartBch SEP20 token amount to a given address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_send_with_http_info(smart_bch_sep20_send_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_send_request: place a SmartBch SEP20 token send request (required)
        :type smart_bch_sep20_send_request: SmartBchSep20SendRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[object], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'smart_bch_sep20_send_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_send" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'smart_bch_sep20_send_request' is set
        if self.api_client.client_side_validation and ('smart_bch_sep20_send_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['smart_bch_sep20_send_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `smart_bch_sep20_send_request` when calling `smart_bch_sep20_send`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smart_bch_sep20_send_request' in local_var_params:
            body_params = local_var_params['smart_bch_sep20_send_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_send_max(self, smart_bch_sep20_send_max_request, **kwargs):  # noqa: E501
        """Send all available SmartBch SEP20 token funds to a given address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_send_max(smart_bch_sep20_send_max_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_send_max_request: Request to send all available SmartBch SEP20 token funds to a given address (required)
        :type smart_bch_sep20_send_max_request: SmartBchSep20SendMaxRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[object]
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_send_max_with_http_info(smart_bch_sep20_send_max_request, **kwargs)  # noqa: E501

    def smart_bch_sep20_send_max_with_http_info(self, smart_bch_sep20_send_max_request, **kwargs):  # noqa: E501
        """Send all available SmartBch SEP20 token funds to a given address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_send_max_with_http_info(smart_bch_sep20_send_max_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_send_max_request: Request to send all available SmartBch SEP20 token funds to a given address (required)
        :type smart_bch_sep20_send_max_request: SmartBchSep20SendMaxRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[object], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'smart_bch_sep20_send_max_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_send_max" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'smart_bch_sep20_send_max_request' is set
        if self.api_client.client_side_validation and ('smart_bch_sep20_send_max_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['smart_bch_sep20_send_max_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `smart_bch_sep20_send_max_request` when calling `smart_bch_sep20_send_max`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smart_bch_sep20_send_max_request' in local_var_params:
            body_params = local_var_params['smart_bch_sep20_send_max_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/send_max', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def smart_bch_sep20_token_info(self, smart_bch_sep20_token_info_request, **kwargs):  # noqa: E501
        """Get information about the SmartBch SEP20 token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_token_info(smart_bch_sep20_token_info_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_token_info_request: Request to get information about the SmartBch SEP20 token  (required)
        :type smart_bch_sep20_token_info_request: SmartBchSep20TokenInfoRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SmartBchSep20TokenInfoResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.smart_bch_sep20_token_info_with_http_info(smart_bch_sep20_token_info_request, **kwargs)  # noqa: E501

    def smart_bch_sep20_token_info_with_http_info(self, smart_bch_sep20_token_info_request, **kwargs):  # noqa: E501
        """Get information about the SmartBch SEP20 token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.smart_bch_sep20_token_info_with_http_info(smart_bch_sep20_token_info_request, async_req=True)
        >>> result = thread.get()

        :param smart_bch_sep20_token_info_request: Request to get information about the SmartBch SEP20 token  (required)
        :type smart_bch_sep20_token_info_request: SmartBchSep20TokenInfoRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SmartBchSep20TokenInfoResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'smart_bch_sep20_token_info_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method smart_bch_sep20_token_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'smart_bch_sep20_token_info_request' is set
        if self.api_client.client_side_validation and ('smart_bch_sep20_token_info_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['smart_bch_sep20_token_info_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `smart_bch_sep20_token_info_request` when calling `smart_bch_sep20_token_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'smart_bch_sep20_token_info_request' in local_var_params:
            body_params = local_var_params['smart_bch_sep20_token_info_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/smartbch/sep20/token_info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SmartBchSep20TokenInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
