"use strict";
(self["webpackChunkobservacode"] = self["webpackChunkobservacode"] || []).push([["node_modules_levenshtein-edit-distance_index_js"],{

/***/ "./node_modules/levenshtein-edit-distance/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/levenshtein-edit-distance/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "levenshteinEditDistance": () => (/* binding */ levenshteinEditDistance)
/* harmony export */ });
/** @type {Array.<number>} */
var codes = []
/** @type {Array.<number>} */
var cache = []

/**
 * @param {string} value
 * @param {string} other
 * @param {boolean} [insensitive]
 * @returns {number}
 */
function levenshteinEditDistance(value, other, insensitive) {
  /** @type {number} */
  var code
  /** @type {number} */
  var result
  /** @type {number} */
  var distance
  /** @type {number} */
  var distanceOther
  /** @type {number} */
  var index
  /** @type {number} */
  var indexOther

  if (value === other) {
    return 0
  }

  if (value.length === 0) {
    return other.length
  }

  if (other.length === 0) {
    return value.length
  }

  if (insensitive) {
    value = value.toLowerCase()
    other = other.toLowerCase()
  }

  index = 0

  while (index < value.length) {
    codes[index] = value.charCodeAt(index)
    cache[index] = ++index
  }

  indexOther = 0

  while (indexOther < other.length) {
    code = other.charCodeAt(indexOther)
    result = distance = indexOther++
    index = -1

    while (++index < value.length) {
      distanceOther = code === codes[index] ? distance : distance + 1
      distance = cache[index]
      cache[index] = result =
        distance > result
          ? distanceOther > result
            ? result + 1
            : distanceOther
          : distanceOther > distance
          ? distance + 1
          : distanceOther
    }
  }

  return result
}


/***/ })

}]);
//# sourceMappingURL=node_modules_levenshtein-edit-distance_index_js.aa92ce9aa78d05d2d564.js.map