find_path(NGHTTP2_INCLUDE_DIR "nghttp2/nghttp2.h")
find_library(NGHTTP2_LIBRARY NAMES nghttp2)

include(FindPackageHandleStandardArgs)
find_package_handle_Standard_args(
  NGHTTP2 DEFAULT_MSG
  NGHTTP2_LIBRARY NGHTTP2_INCLUDE_DIR
  )

if (NGHTTP2_FOUND AND NOT TARGET NGHTTP2::NGHTTP2)
  add_library(NGHTTP2::NGHTTP2 UNKNOWN IMPORTED)
  set_target_properties(NGHTTP2::NGHTTP2 PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES ${NGHTTP2_INCLUDE_DIR}
    IMPORTED_LINK_INTERFACE_LANGUAGES C)

  set_target_properties(NGHTTP2::NGHTTP2 PROPERTIES
    IMPORTED_LOCATION "${NGHTTP2_LIBRARY}")
endif()

mark_as_advanced(NGHTTP2_INCLUDE_DIR NGHTTP2_LIBRARY)
