import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { CfnRepository } from '@aws-cdk/aws-codeartifact';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import type { IPackageSource, PackageSourceBindOptions, PackageSourceBindResult } from '../package-source';
/**
 * @experimental
 */
export interface CodeArtifactProps {
    /**
     * (experimental) The CodeArtifact repository where packages are obtained from.
     *
     * @experimental
     */
    readonly repository: CfnRepository;
    /**
     * (experimental) The S3 bucket where packages will be staged.
     *
     * @experimental
     */
    readonly bucket?: IBucket;
}
/**
 * (experimental) A package source that obtains package data from an npm CodeArtifact repository.
 *
 * @experimental
 */
export declare class CodeArtifact implements IPackageSource {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: CodeArtifactProps);
    /**
     * (experimental) Binds the package source to a scope and target queue.
     *
     * @experimental
     */
    bind(scope: Construct, { denyList, ingestion, licenseList, monitoring, queue }: PackageSourceBindOptions): PackageSourceBindResult;
    /**
     * (experimental) The count of package versions that were ignored due to being in the deny list.
     *
     * @experimental
     */
    metricDenyListedCount(opts?: MetricOptions): Metric;
    /**
     * (experimental) The number of package versions that were ignored due to using an ineloigible license.
     *
     * @experimental
     */
    metricIneligibleLicense(opts?: MetricOptions): Metric;
    /**
     * (experimental) The number of package versions that were deleted from CodeArtifact (those events are not handled currently).
     *
     * @experimental
     */
    metricDeletedCount(opts?: MetricOptions): Metric;
    /**
     * (experimental) The number of package versions that do not have a jsii assembly in the package.
     *
     * @experimental
     */
    metricNotJsiiEnabledCount(opts?: MetricOptions): Metric;
}
