"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeFile = void 0;
const fs = require("fs");
async function writeFile(filePath, readStream) {
    return new Promise((ok, ko) => {
        const writeStream = fs.createWriteStream(filePath);
        readStream.pipe(writeStream);
        readStream.once('error', ko);
        writeStream.once('error', ko);
        writeStream.once('finish', () => {
            ok();
        });
    });
}
exports.writeFile = writeFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9iYWNrZW5kL3RyYW5zbGl0ZXJhdG9yL3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEseUJBQXlCO0FBR2xCLEtBQUssVUFBVSxTQUFTLENBQUMsUUFBZ0IsRUFBRSxVQUE2QjtJQUM3RSxPQUFPLElBQUksT0FBTyxDQUFPLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFO1FBQ2xDLE1BQU0sV0FBVyxHQUFHLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUNuRCxVQUFVLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzdCLFVBQVUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdCLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzlCLFdBQVcsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtZQUM5QixFQUFFLEVBQUUsQ0FBQztRQUNQLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDO0FBVkQsOEJBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgKiBhcyBpbnRlcm5hbCBmcm9tICdzdHJlYW0nO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gd3JpdGVGaWxlKGZpbGVQYXRoOiBzdHJpbmcsIHJlYWRTdHJlYW06IGludGVybmFsLlJlYWRhYmxlKTogUHJvbWlzZTx2b2lkPiB7XG4gIHJldHVybiBuZXcgUHJvbWlzZTx2b2lkPigob2ssIGtvKSA9PiB7XG4gICAgY29uc3Qgd3JpdGVTdHJlYW0gPSBmcy5jcmVhdGVXcml0ZVN0cmVhbShmaWxlUGF0aCk7XG4gICAgcmVhZFN0cmVhbS5waXBlKHdyaXRlU3RyZWFtKTtcbiAgICByZWFkU3RyZWFtLm9uY2UoJ2Vycm9yJywga28pO1xuICAgIHdyaXRlU3RyZWFtLm9uY2UoJ2Vycm9yJywga28pO1xuICAgIHdyaXRlU3RyZWFtLm9uY2UoJ2ZpbmlzaCcsICgpID0+IHtcbiAgICAgIG9rKCk7XG4gICAgfSk7XG4gIH0pO1xufVxuIl19