# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class PredictionTaskSchema(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'TaskName',
        'type': 'TaskType',
        'categories': 'list[PredictionTaskSchemaCategory]'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'categories': 'categories'
    }

    def __init__(self, name=None, type=None, categories=None, _configuration=None):  # noqa: E501
        """PredictionTaskSchema - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._name = None
        self._type = None
        self._categories = None
        self.discriminator = None

        self.name = name
        self.type = type
        self.categories = categories

    @property
    def name(self):
        """Gets the name of this PredictionTaskSchema.  # noqa: E501


        :return: The name of this PredictionTaskSchema.  # noqa: E501
        :rtype: TaskName
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PredictionTaskSchema.


        :param name: The name of this PredictionTaskSchema.  # noqa: E501
        :type: TaskName
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def type(self):
        """Gets the type of this PredictionTaskSchema.  # noqa: E501


        :return: The type of this PredictionTaskSchema.  # noqa: E501
        :rtype: TaskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this PredictionTaskSchema.


        :param type: The type of this PredictionTaskSchema.  # noqa: E501
        :type: TaskType
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def categories(self):
        """Gets the categories of this PredictionTaskSchema.  # noqa: E501

        An array of the categories that exist for this prediction task. The id needs to be unique  # noqa: E501

        :return: The categories of this PredictionTaskSchema.  # noqa: E501
        :rtype: list[PredictionTaskSchemaCategory]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this PredictionTaskSchema.

        An array of the categories that exist for this prediction task. The id needs to be unique  # noqa: E501

        :param categories: The categories of this PredictionTaskSchema.  # noqa: E501
        :type: list[PredictionTaskSchemaCategory]
        """
        if self._configuration.client_side_validation and categories is None:
            raise ValueError("Invalid value for `categories`, must not be `None`")  # noqa: E501

        self._categories = categories

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PredictionTaskSchema, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PredictionTaskSchema):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PredictionTaskSchema):
            return True

        return self.to_dict() != other.to_dict()
