# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class CropData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'parent_id': 'MongoObjectID',
        'prediction_uuid_timestamp': 'Timestamp',
        'prediction_index': 'int',
        'prediction_task_name': 'TaskName',
        'prediction_task_category_id': 'CategoryId',
        'prediction_task_score': 'Score'
    }

    attribute_map = {
        'parent_id': 'parentId',
        'prediction_uuid_timestamp': 'predictionUUIDTimestamp',
        'prediction_index': 'predictionIndex',
        'prediction_task_name': 'predictionTaskName',
        'prediction_task_category_id': 'predictionTaskCategoryId',
        'prediction_task_score': 'predictionTaskScore'
    }

    def __init__(self, parent_id=None, prediction_uuid_timestamp=None, prediction_index=None, prediction_task_name=None, prediction_task_category_id=None, prediction_task_score=None, _configuration=None):  # noqa: E501
        """CropData - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._parent_id = None
        self._prediction_uuid_timestamp = None
        self._prediction_index = None
        self._prediction_task_name = None
        self._prediction_task_category_id = None
        self._prediction_task_score = None
        self.discriminator = None

        self.parent_id = parent_id
        self.prediction_uuid_timestamp = prediction_uuid_timestamp
        self.prediction_index = prediction_index
        self.prediction_task_name = prediction_task_name
        self.prediction_task_category_id = prediction_task_category_id
        self.prediction_task_score = prediction_task_score

    @property
    def parent_id(self):
        """Gets the parent_id of this CropData.  # noqa: E501


        :return: The parent_id of this CropData.  # noqa: E501
        :rtype: MongoObjectID
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this CropData.


        :param parent_id: The parent_id of this CropData.  # noqa: E501
        :type: MongoObjectID
        """
        if self._configuration.client_side_validation and parent_id is None:
            raise ValueError("Invalid value for `parent_id`, must not be `None`")  # noqa: E501

        self._parent_id = parent_id

    @property
    def prediction_uuid_timestamp(self):
        """Gets the prediction_uuid_timestamp of this CropData.  # noqa: E501


        :return: The prediction_uuid_timestamp of this CropData.  # noqa: E501
        :rtype: Timestamp
        """
        return self._prediction_uuid_timestamp

    @prediction_uuid_timestamp.setter
    def prediction_uuid_timestamp(self, prediction_uuid_timestamp):
        """Sets the prediction_uuid_timestamp of this CropData.


        :param prediction_uuid_timestamp: The prediction_uuid_timestamp of this CropData.  # noqa: E501
        :type: Timestamp
        """
        if self._configuration.client_side_validation and prediction_uuid_timestamp is None:
            raise ValueError("Invalid value for `prediction_uuid_timestamp`, must not be `None`")  # noqa: E501

        self._prediction_uuid_timestamp = prediction_uuid_timestamp

    @property
    def prediction_index(self):
        """Gets the prediction_index of this CropData.  # noqa: E501

        the index of this crop within all found prediction singletons of a sampleId (the parentId)  # noqa: E501

        :return: The prediction_index of this CropData.  # noqa: E501
        :rtype: int
        """
        return self._prediction_index

    @prediction_index.setter
    def prediction_index(self, prediction_index):
        """Sets the prediction_index of this CropData.

        the index of this crop within all found prediction singletons of a sampleId (the parentId)  # noqa: E501

        :param prediction_index: The prediction_index of this CropData.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and prediction_index is None:
            raise ValueError("Invalid value for `prediction_index`, must not be `None`")  # noqa: E501

        self._prediction_index = prediction_index

    @property
    def prediction_task_name(self):
        """Gets the prediction_task_name of this CropData.  # noqa: E501


        :return: The prediction_task_name of this CropData.  # noqa: E501
        :rtype: TaskName
        """
        return self._prediction_task_name

    @prediction_task_name.setter
    def prediction_task_name(self, prediction_task_name):
        """Sets the prediction_task_name of this CropData.


        :param prediction_task_name: The prediction_task_name of this CropData.  # noqa: E501
        :type: TaskName
        """
        if self._configuration.client_side_validation and prediction_task_name is None:
            raise ValueError("Invalid value for `prediction_task_name`, must not be `None`")  # noqa: E501

        self._prediction_task_name = prediction_task_name

    @property
    def prediction_task_category_id(self):
        """Gets the prediction_task_category_id of this CropData.  # noqa: E501


        :return: The prediction_task_category_id of this CropData.  # noqa: E501
        :rtype: CategoryId
        """
        return self._prediction_task_category_id

    @prediction_task_category_id.setter
    def prediction_task_category_id(self, prediction_task_category_id):
        """Sets the prediction_task_category_id of this CropData.


        :param prediction_task_category_id: The prediction_task_category_id of this CropData.  # noqa: E501
        :type: CategoryId
        """
        if self._configuration.client_side_validation and prediction_task_category_id is None:
            raise ValueError("Invalid value for `prediction_task_category_id`, must not be `None`")  # noqa: E501

        self._prediction_task_category_id = prediction_task_category_id

    @property
    def prediction_task_score(self):
        """Gets the prediction_task_score of this CropData.  # noqa: E501


        :return: The prediction_task_score of this CropData.  # noqa: E501
        :rtype: Score
        """
        return self._prediction_task_score

    @prediction_task_score.setter
    def prediction_task_score(self, prediction_task_score):
        """Sets the prediction_task_score of this CropData.


        :param prediction_task_score: The prediction_task_score of this CropData.  # noqa: E501
        :type: Score
        """
        if self._configuration.client_side_validation and prediction_task_score is None:
            raise ValueError("Invalid value for `prediction_task_score`, must not be `None`")  # noqa: E501

        self._prediction_task_score = prediction_task_score

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CropData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CropData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CropData):
            return True

        return self.to_dict() != other.to_dict()
