"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'default-dir-index-demo');
// create the cloudfront distribution with extension(s)
const defaultDirIndex = new extensions.DefaultDirIndex(stack, 'DefaultDirIndexDemo');
// create Demo S3 Bucket.
const bucket = new s3.Bucket(defaultDirIndex, 'demoBucket', {
    autoDeleteObjects: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
    websiteIndexDocument: 'index.html',
    websiteErrorDocument: 'index.html',
});
// create index.html in the demo folder
fs.mkdirSync(path.join(__dirname, 'a/b/c'), {
    recursive: true,
});
fs.writeFileSync(path.join(__dirname, 'a/b/c/index.html'), '<h1>Hello CDK!</h1>');
fs.writeFileSync(path.join(__dirname, 'index.html'), '<h1>Hello CDK!!! From root directory </h1>');
// Put demo Object to Bucket.
new aws_s3_deployment_1.BucketDeployment(defaultDirIndex, 'Deployment', {
    sources: [aws_s3_deployment_1.Source.asset(path.join(__dirname, './'))],
    destinationBucket: bucket,
    retainOnDelete: false,
});
// CloudFront OriginAccessIdentity for Bucket
const originAccessIdentity = new cf.OriginAccessIdentity(defaultDirIndex, 'OriginAccessIdentity', {
    comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
});
// CloudfrontWebDistribution
const cloudfrontWebDistribution = new cf.CloudFrontWebDistribution(stack, 'CloudFrontWebDistribution', {
    originConfigs: [
        {
            s3OriginSource: {
                originAccessIdentity,
                s3BucketSource: bucket,
            },
            behaviors: [{
                    isDefaultBehavior: true,
                    lambdaFunctionAssociations: [defaultDirIndex],
                }],
        },
    ],
});
// CloudfrontWebDistribution Error
const cloudfrontWebDistributionError = new cf.CloudFrontWebDistribution(stack, 'cloudfrontWebDistributionError', {
    originConfigs: [
        {
            s3OriginSource: {
                originAccessIdentity,
                s3BucketSource: bucket,
            },
            behaviors: [{
                    isDefaultBehavior: true,
                }],
        },
    ],
});
new cdk.CfnOutput(stack, 'distributionDomainName', {
    value: `https://${cloudfrontWebDistribution.distributionDomainName}`,
});
new cdk.CfnOutput(stack, 'errorDistributionDomainName', {
    value: `https://${cloudfrontWebDistributionError.distributionDomainName}`,
});
//# sourceMappingURL=data:application/json;base64,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