"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../extensions");
test('minimal usage', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'demo-stack');
    // WHEN
    // create the cloudfront distribution with extension(s)
    const ext = new extensions.RedirectByGeolocation(stack, 'RedirectByGeolocation', {
        countryTable: {
            US: 'mock-api.com',
            CN: 'mock-api.com.cn',
        },
    });
    const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
        headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
    });
    // create the cloudfront distribution with extension(s)
    const dist = new cf.Distribution(stack, 'dist', {
        defaultBehavior: {
            origin: new origins.HttpOrigin('aws.amazon.com'),
            edgeLambdas: [ext],
            originRequestPolicy: {
                originRequestPolicyId: policy.originRequestPolicyId,
            },
        },
    });
    new cdk.CfnOutput(stack, 'distributionDomainName', {
        value: dist.distributionDomainName,
    });
    // THEN
    expect(assert_1.SynthUtils.synthesize(stack).template).toMatchSnapshot();
    expect(stack).toHaveResourceLike('AWS::CloudFront::Distribution', {
        DistributionConfig: {
            DefaultCacheBehavior: {
                LambdaFunctionAssociations: [
                    {
                        EventType: 'origin-request',
                    },
                ],
                ViewerProtocolPolicy: 'allow-all',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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