
<h2 align="center">
  <br>
  <p align="center"><img src="https://avatars.githubusercontent.com/u/32068152?s=200&v=4"></p>
</h2>

<h4 align="center">Chaos Toolkit - Chaos Engineering for Everyone</h4>

<p align="center">
   <a href="https://github.com/chaostoolkit/chaostoolkit-lib/releases">
   <img alt="Release" src="https://img.shields.io/pypi/v/chaostoolkit-lib.svg">
   <a href="#">
   <img alt="Build" src="https://github.com/chaostoolkit/chaostoolkit-lib/actions/workflows/build.yaml/badge.svg">
   <a href="https://github.com/chaostoolkit/chaostoolkit-lib/issues">
   <img alt="GitHub issues" src="https://img.shields.io/github/issues/chaostoolkit/chaostoolkit-lib?style=flat-square&logo=github&logoColor=white">
   <a href="https://github.com/chaostoolkit/chaostoolkit-lib/blob/master/LICENSE.md">
   <img alt="License" src="https://img.shields.io/github/license/chaostoolkit/chaostoolkit-lib">
   <a href="#">
   <img alt="Python version" src="https://img.shields.io/pypi/pyversions/chaostoolkit-lib.svg">
   <a href="https://pkg.go.dev/github.com/chaostoolkit/chaostoolkit-lib">
</p>

<p align="center">
  <a href="https://join.slack.com/t/chaostoolkit/shared_invite/zt-22c5isqi9-3YjYzucVTNFFVIG~Kzns8g">Community</a> •
  <a href="https://github.com/chaostoolkit/chaostoolkit-lib/blob/master/CHANGELOG.md">ChangeLog</a>
</p>

---

## Purpose

The purpose of this library is to provide the core of the Chaos Toolkit 
[model][concepts] and functions it needs to render its services.

[concepts]: https://docs.chaostoolkit.org/reference/concepts/

## Features

The library provides the followings features:

* discover capabilities from extensions
  Allows you to explore the support from an extension that would help you
  initialize an experiment against the system this extension targets

* validate a given experiment syntax
  The validation looks at various keys in the experiment and raises errors
  whenever something doesn't look right.
  As a nice addition, when a probe calls a Python function with arguments,
  it tries to validate the given argument list matches the signature of the
  function to apply.

* run your steady state before and after the method. The former as a gate to
  decide if the experiment can be executed. The latter to see if the system
  deviated from normal.

* run probes and actions declared in an experiment
  It runs the steps in a experiment method sequentially, applying first steady
  probes, then actions and finally close probes.

  A journal, as a JSON payload, is return of the experiment run.

  The library supports running probes and actions defined as Python functions,
  from importable Python modules, processes and HTTP calls.

* run experiment's rollbacks when provided

* Load secrets from the experiments, the environ or [vault][vault]

* Provides event notification from Chaos Toolkit flow (although the actual
  events are published by the CLI itself, not from this library), supported
  events are:
  * on experiment validation: started, failed or completed
  * on discovery: started, failed or completed
  * on initialization of experiments: started, failed or completed
  * on experiment runs: started, failed or completed

  For each event, the according payload is part of the event as well as a UTC
  timestamp.

[vault]: https://www.vaultproject.io/

## Install

If you are user of the Chaos Toolkit, you probably do not need to install this
package yourself as it comes along with the [chaostoolkit cli][cli].

[cli]: https://github.com/chaostoolkit/chaostoolkit

However, should you wish to integrate this library in your own Python code,
please install it as usual:

```
$ pip install -U chaostoolkit-lib
```

### Specific dependencies

In addition to essential dependencies, the package can install a couple of
other extra dependencies for specific use-cases. They are not mandatory and
the library will warn you if you try to use a feature that requires them.

### Vault

If you need [Vault][vault] support to read secrets from, run the following
command:

[vault]: https://www.vaultproject.io/
```
$ pip install -U chaostoolkit-lib[vault]
```

To authenticate with Vault, you can either:
* Use a token through the `vault_token` configuration key
* Use an [AppRole][approle] via the `vault_role_id`, `vault_secret_id` pair of configuration keys
* Use a [service account][serviceaccount] configured with an appropriate [role][role] via the `vault_sa_role` configuration key. The `vault_sa_token_path`, `vault_k8s_mount_point`, and `vault_secrets_mount_point` configuration keys can optionally be specified to point to a location containing a service account [token][sa-token], a different Kubernetes authentication method [mount point][k8s-mount], or a different secrets [mount point][secrets-mount], respectively.

[approle]: https://www.vaultproject.io/docs/auth/approle.html
[serviceaccount]: https://www.vaultproject.io/api/auth/kubernetes/index.html
[role]: https://www.vaultproject.io/api/auth/kubernetes/index.html#create-role
[sa-token]: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#service-account-token-volume-projection
[k8s-mount]: https://www.vaultproject.io/docs/auth/kubernetes.html
[secrets-mount]: https://www.vaultproject.io/api/secret/kv/kv-v1.htm


### JSON Path

If you need [JSON Path support][jpath] for tolerance probes in the hypothesis,
also run the following command:

[jpath]: http://goessner.net/articles/JsonPath/

```
$ pip install -U chaostoolkit-lib[jsonpath]
```

## Contribute

Contributors to this project are welcome as this is an open-source effort that
seeks [discussions][join] and continuous improvement.

[join]: https://join.chaostoolkit.org/

From a code perspective, if you wish to contribute, you will need to run a 
Python 3.6+ environment. Please, fork this project, write unit tests to cover
the proposed changes, implement the changes, ensure they meet the formatting
standards set out by `black`, `flake8`, and `isort`, add an entry into 
`CHANGELOG.md`, and then raise a PR to the repository for review.

Please refer to the [formatting](#formatting-and-linting) section for more
information on the formatting standards.

The Chaos Toolkit projects require all contributors must sign a
[Developer Certificate of Origin][dco] on each commit they would like to merge
into the master branch of the repository. Please, make sure you can abide by
the rules of the DCO before submitting a PR.

[dco]: https://github.com/probot/dco#how-it-works


### Develop

If you wish to develop on this project, make sure to install the development
dependencies. To do so, first install [pdm](https://pdm-project.org/latest/).


```console
$ pdm install --dev
```

Now, you can edit the files and they will be automatically be seen by your
environment, even when running from the `chaos` command locally.

### Test

To run the tests for the project execute the following:

```
$ pdm run test
```

### Formatting and Linting

We use [ruff]() to perform linting and code style.

[ruff]: https://astral.sh/ruff

Before raising a Pull Request, we recommend you run formatting against your
code with:

```console
$ pdm run format
```

This will automatically format any code that doesn't adhere to the formatting
standards.

As some things are not picked up by the formatting, we also recommend you run:

```console
$ pdm run lint
```

To ensure that any unused import statements/strings that are too long, etc.
are also picked up.
