"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateJobExecutor = exports.FargateRunner = exports.JobExecutorImage = exports.FargateCapacityProviderType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Amazon ECS Capacity Providers for AWS Fargate.
 *
 * @stability stable
 */
var FargateCapacityProviderType;
(function (FargateCapacityProviderType) {
    FargateCapacityProviderType["FARGATE"] = "FARGATE";
    FargateCapacityProviderType["FARGATE_SPOT"] = "FARGATE_SPOT";
})(FargateCapacityProviderType = exports.FargateCapacityProviderType || (exports.FargateCapacityProviderType = {}));
/**
 * The docker image for the job executor.
 *
 * @stability stable
 */
class JobExecutorImage {
    /**
     *
     * @param image job executor image URI
     */
    constructor(uri) {
        this.uri = uri;
    }
    /**
     * Custom image.
     *
     * @param image custom image registry URI.
     * @stability stable
     */
    static of(image) { return new JobExecutorImage(image); }
}
exports.JobExecutorImage = JobExecutorImage;
_a = JSII_RTTI_SYMBOL_1;
JobExecutorImage[_a] = { fqn: "cdk-gitlab.JobExecutorImage", version: "0.1.138" };
/**
 * Debian.
 *
 * @see https://gitlab.com/tmaczukin-test-projects/fargate-driver-debian
 * @stability stable
 */
JobExecutorImage.DEBIAN = JobExecutorImage.of('registry.gitlab.com/tmaczukin-test-projects/fargate-driver-debian:latest');
/**
 * Node.
 *
 * @see https://gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate
 * @stability stable
 */
JobExecutorImage.NODE = JobExecutorImage.of('registry.gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate:latest');
/**
 * JSII for AWS CDK.
 *
 * @see https://gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate
 * @stability stable
 */
JobExecutorImage.JSII = JobExecutorImage.of('registry.gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate:latest');
const CLUSTER_DEFAULT_CAPACITY_PROVIDER = [
    FargateCapacityProviderType.FARGATE,
    FargateCapacityProviderType.FARGATE_SPOT,
];
const DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY = [{
        base: 0,
        weight: 1,
        capacityProvider: FargateCapacityProviderType.FARGATE_SPOT,
    }];
const DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY = [
    { base: 0, weight: 0, capacityProvider: FargateCapacityProviderType.FARGATE },
    { weight: 1, capacityProvider: FargateCapacityProviderType.FARGATE_SPOT },
];
/**
 * The FargateRunner.
 *
 * @stability stable
 */
class FargateRunner extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
        super(scope, id);
        this.vpc = props.vpc;
        const stack = cdk.Stack.of(this);
        const fargateSubnet = this.vpc.selectSubnets(props.fargateJobSubnet);
        const cluster = new ecs.Cluster(this, 'Cluster', { vpc: this.vpc });
        const cfnCluster = cluster.node.tryFindChild('Resource');
        cfnCluster.addPropertyOverride('CapacityProviders', CLUSTER_DEFAULT_CAPACITY_PROVIDER);
        cfnCluster.addPropertyOverride('DefaultCapacityProviderStrategy', (_d = props.serviceDefaultCapacityProviderStrategy) !== null && _d !== void 0 ? _d : DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY);
        const runnerTask = new ecs.FargateTaskDefinition(this, 'RunnerTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        const fargateSecurityGroup = (_e = props.securityGroup) !== null && _e !== void 0 ? _e : this.createSecurityGroup();
        const registrationToken = (_f = props.registrationToken) !== null && _f !== void 0 ? _f : (this.node.tryGetContext('GITLAB_REGISTRATION_TOKEN') || process.env.GITLAB_REGISTRATION_TOKEN);
        if (!registrationToken) {
            throw new Error('missing GITLAB_REGISTRATION_TOKEN in the context variable');
        }
        runnerTask.addContainer('runner', {
            image: ecs.ContainerImage.fromRegistry('registry.gitlab.com/pahud/docker-gitlab-runner-fargate-driver'),
            logging: new ecs.AwsLogDriver({ streamPrefix: 'GitlabRunnerManager', logRetention: 7 }),
            environment: {
                GITLAB_REGISTRATION_TOKEN: registrationToken,
                GITLAB_URL: (_g = props.gitlabURL) !== null && _g !== void 0 ? _g : 'https://gitlab.com',
                FARGATE_REGION: (_j = (_h = props.executor) === null || _h === void 0 ? void 0 : _h.region) !== null && _j !== void 0 ? _j : stack.region,
                FARGATE_CLUSTER: (_m = (_l = (_k = props.executor) === null || _k === void 0 ? void 0 : _k.cluster) === null || _l === void 0 ? void 0 : _l.clusterName) !== null && _m !== void 0 ? _m : cluster.clusterName,
                FARGATE_SUBNET: (_q = (_p = (_o = props.executor) === null || _o === void 0 ? void 0 : _o.subnet) === null || _p === void 0 ? void 0 : _p.subnetId) !== null && _q !== void 0 ? _q : fargateSubnet.subnetIds[0],
                FARGATE_SECURITY_GROUP: (_t = (_s = (_r = props.executor) === null || _r === void 0 ? void 0 : _r.securityGroup) === null || _s === void 0 ? void 0 : _s.securityGroupId) !== null && _t !== void 0 ? _t : fargateSecurityGroup.securityGroupId,
                FARGATE_TASK_DEFINITION: ((_u = props.executor) === null || _u === void 0 ? void 0 : _u.taskDefinitionArn) || new FargateJobExecutor(this, 'JobExecutor').taskDefinitionArn,
                RUNNER_TAG_LIST: this.synthesizeTags((_v = props.tags) !== null && _v !== void 0 ? _v : ['fargate', 'gitlab', 'aws', 'docker']),
            },
        });
        runnerTask.taskRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonECS_FullAccess'));
        const svc = new ecs.FargateService(this, 'RunnerManagerService', {
            cluster,
            taskDefinition: runnerTask,
            securityGroups: [fargateSecurityGroup],
        });
        const cfnService = svc.node.tryFindChild('Service');
        cfnService.addPropertyDeletionOverride('LaunchType');
        cfnService.addPropertyOverride('CapacityProviderStrategy', (_w = props.serviceDefaultCapacityProviderStrategy) !== null && _w !== void 0 ? _w : DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY);
    }
    synthesizeTags(tags) {
        return tags.join(',');
    }
    createSecurityGroup() {
        const sg = new ec2.SecurityGroup(this, 'FargateSecurityGroup', { vpc: this.vpc });
        sg.connections.allowInternally(ec2.Port.allTraffic());
        return sg;
    }
}
exports.FargateRunner = FargateRunner;
_b = JSII_RTTI_SYMBOL_1;
FargateRunner[_b] = { fqn: "cdk-gitlab.FargateRunner", version: "0.1.138" };
/**
 * The FargateJobExecutor.
 *
 * @stability stable
 */
class FargateJobExecutor extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _d, _e;
        super(scope, id);
        this.region = (_d = props.region) !== null && _d !== void 0 ? _d : cdk.Stack.of(this).region;
        this.cluster = props.cluster;
        this.subnet = props.subnet;
        this.securityGroup = props.securityGroup;
        const task = new ecs.FargateTaskDefinition(this, 'JobsTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        this.taskDefinitionArn = task.taskDefinitionArn;
        const image = (_e = props.image) !== null && _e !== void 0 ? _e : JobExecutorImage.DEBIAN;
        task.addContainer('ci-coordinator', {
            image: ecs.ContainerImage.fromRegistry(image.uri.toString()),
            logging: new ecs.AwsLogDriver({ streamPrefix: 'GitlabRunnerJob', logRetention: 7 }),
        }).addPortMappings({ containerPort: 22 });
    }
}
exports.FargateJobExecutor = FargateJobExecutor;
_c = JSII_RTTI_SYMBOL_1;
FargateJobExecutor[_c] = { fqn: "cdk-gitlab.FargateJobExecutor", version: "0.1.138" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVubmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3J1bm5lci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHdDQUF3QztBQUN4Qyx3Q0FBd0M7QUFDeEMsd0NBQXdDO0FBQ3hDLHFDQUFxQzs7Ozs7O0FBR3JDLElBQVksMkJBR1g7QUFIRCxXQUFZLDJCQUEyQjtJQUNyQyxrREFBbUIsQ0FBQTtJQUNuQiw0REFBNkIsQ0FBQTtBQUMvQixDQUFDLEVBSFcsMkJBQTJCLEdBQTNCLG1DQUEyQixLQUEzQixtQ0FBMkIsUUFHdEM7Ozs7OztBQXVDRCxNQUFhLGdCQUFnQjtJQVMzQjs7O09BR0c7SUFDSCxZQUFvQyxHQUFXO1FBQVgsUUFBRyxHQUFILEdBQUcsQ0FBUTtJQUFJLENBQUM7Ozs7Ozs7SUFMN0MsTUFBTSxDQUFDLEVBQUUsQ0FBQyxLQUFhLElBQUksT0FBTyxJQUFJLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQzs7QUFSekUsNENBY0M7Ozs7Ozs7OztBQVp3Qix1QkFBTSxHQUFHLGdCQUFnQixDQUFDLEVBQUUsQ0FBQywwRUFBMEUsQ0FBQyxDQUFDOzs7Ozs7O0FBRXpHLHFCQUFJLEdBQUcsZ0JBQWdCLENBQUMsRUFBRSxDQUFDLG9GQUFvRixDQUFDLENBQUM7Ozs7Ozs7QUFFakgscUJBQUksR0FBRyxnQkFBZ0IsQ0FBQyxFQUFFLENBQUMsb0VBQW9FLENBQUMsQ0FBQztBQVUxSCxNQUFNLGlDQUFpQyxHQUFHO0lBQ3hDLDJCQUEyQixDQUFDLE9BQU87SUFDbkMsMkJBQTJCLENBQUMsWUFBWTtDQUN6QyxDQUFDO0FBRUYsTUFBTSwwQ0FBMEMsR0FBbUMsQ0FBQztRQUNsRixJQUFJLEVBQUUsQ0FBQztRQUNQLE1BQU0sRUFBRSxDQUFDO1FBQ1QsZ0JBQWdCLEVBQUUsMkJBQTJCLENBQUMsWUFBWTtLQUMzRCxDQUFDLENBQUM7QUFFSCxNQUFNLDBDQUEwQyxHQUFtQztJQUNqRixFQUFFLElBQUksRUFBRSxDQUFDLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxnQkFBZ0IsRUFBRSwyQkFBMkIsQ0FBQyxPQUFPLEVBQUU7SUFDN0UsRUFBRSxNQUFNLEVBQUUsQ0FBQyxFQUFFLGdCQUFnQixFQUFFLDJCQUEyQixDQUFDLFlBQVksRUFBRTtDQUMxRSxDQUFDOzs7Ozs7QUFJRixNQUFhLGFBQWMsU0FBUSxHQUFHLENBQUMsU0FBUzs7OztJQUU5QyxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXlCOztRQUNyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztRQUVyQixNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVqQyxNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUVyRSxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUNwRSxNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVLENBQW1CLENBQUM7UUFDM0UsVUFBVSxDQUFDLG1CQUFtQixDQUFDLG1CQUFtQixFQUFFLGlDQUFpQyxDQUFDLENBQUM7UUFDdkYsVUFBVSxDQUFDLG1CQUFtQixDQUFDLGlDQUFpQyxRQUFFLEtBQUssQ0FBQyxzQ0FBc0MsbUNBQUksMENBQTBDLENBQUMsQ0FBQztRQUU5SixNQUFNLFVBQVUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQ25FLEdBQUcsRUFBRSxHQUFHO1lBQ1IsY0FBYyxFQUFFLEdBQUc7U0FDcEIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxvQkFBb0IsU0FBRyxLQUFLLENBQUMsYUFBYSxtQ0FBSSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztRQUUvRSxNQUFNLGlCQUFpQixTQUFHLEtBQUssQ0FBQyxpQkFBaUIsbUNBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQywyQkFBMkIsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUVySixJQUFJLENBQUMsaUJBQWlCLEVBQUU7WUFDdEIsTUFBTSxJQUFJLEtBQUssQ0FBQywyREFBMkQsQ0FBQyxDQUFDO1NBQzlFO1FBRUQsVUFBVSxDQUFDLFlBQVksQ0FBQyxRQUFRLEVBQUU7WUFDaEMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLCtEQUErRCxDQUFDO1lBQ3ZHLE9BQU8sRUFBRSxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsRUFBRSxZQUFZLEVBQUUscUJBQXFCLEVBQUUsWUFBWSxFQUFFLENBQUMsRUFBRSxDQUFDO1lBQ3ZGLFdBQVcsRUFBRTtnQkFDWCx5QkFBeUIsRUFBRSxpQkFBaUI7Z0JBQzVDLFVBQVUsUUFBRSxLQUFLLENBQUMsU0FBUyxtQ0FBSSxvQkFBb0I7Z0JBQ25ELGNBQWMsY0FBRSxLQUFLLENBQUMsUUFBUSwwQ0FBRSxNQUFNLG1DQUFJLEtBQUssQ0FBQyxNQUFNO2dCQUN0RCxlQUFlLG9CQUFFLEtBQUssQ0FBQyxRQUFRLDBDQUFFLE9BQU8sMENBQUUsV0FBVyxtQ0FBSSxPQUFPLENBQUMsV0FBVztnQkFDNUUsY0FBYyxvQkFBRSxLQUFLLENBQUMsUUFBUSwwQ0FBRSxNQUFNLDBDQUFFLFFBQVEsbUNBQUksYUFBYSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7Z0JBQzlFLHNCQUFzQixvQkFBRSxLQUFLLENBQUMsUUFBUSwwQ0FBRSxhQUFhLDBDQUFFLGVBQWUsbUNBQUksb0JBQW9CLENBQUMsZUFBZTtnQkFDOUcsdUJBQXVCLEVBQUUsT0FBQSxLQUFLLENBQUMsUUFBUSwwQ0FBRSxpQkFBaUIsS0FBSSxJQUFJLGtCQUFrQixDQUFDLElBQUksRUFBRSxhQUFhLENBQUMsQ0FBQyxpQkFBaUI7Z0JBQzNILGVBQWUsRUFBRSxJQUFJLENBQUMsY0FBYyxPQUFDLEtBQUssQ0FBQyxJQUFJLG1DQUFJLENBQUMsU0FBUyxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7YUFDM0Y7U0FDRixDQUFDLENBQUM7UUFFSCxVQUFVLENBQUMsUUFBUSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDO1FBRXpHLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsc0JBQXNCLEVBQUU7WUFDL0QsT0FBTztZQUNQLGNBQWMsRUFBRSxVQUFVO1lBQzFCLGNBQWMsRUFBRSxDQUFDLG9CQUFvQixDQUFDO1NBQ3ZDLENBQUMsQ0FBQztRQUNILE1BQU0sVUFBVSxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBbUIsQ0FBQztRQUN0RSxVQUFVLENBQUMsMkJBQTJCLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDckQsVUFBVSxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQixRQUFFLEtBQUssQ0FBQyxzQ0FBc0MsbUNBQUksMENBQTBDLENBQUMsQ0FBQztJQUN6SixDQUFDO0lBQ08sY0FBYyxDQUFDLElBQWM7UUFDbkMsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3hCLENBQUM7SUFDTyxtQkFBbUI7UUFDekIsTUFBTSxFQUFFLEdBQUcsSUFBSSxHQUFHLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxzQkFBc0IsRUFBRSxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUNsRixFQUFFLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7UUFDdEQsT0FBTyxFQUFFLENBQUM7SUFDWixDQUFDOztBQTlESCxzQ0ErREM7Ozs7Ozs7O0FBY0QsTUFBYSxrQkFBbUIsU0FBUSxHQUFHLENBQUMsU0FBUzs7OztJQU9uRCxZQUFZLEtBQW9CLEVBQUUsRUFBUyxFQUFFLFFBQWlDLEVBQUU7O1FBQzlFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLE1BQU0sU0FBRyxLQUFLLENBQUMsTUFBTSxtQ0FBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNLENBQUM7UUFDeEQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFFekMsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMscUJBQXFCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMzRCxHQUFHLEVBQUUsR0FBRztZQUNSLGNBQWMsRUFBRSxHQUFHO1NBQ3BCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUM7UUFFaEQsTUFBTSxLQUFLLFNBQUcsS0FBSyxDQUFDLEtBQUssbUNBQUksZ0JBQWdCLENBQUMsTUFBTSxDQUFDO1FBRXJELElBQUksQ0FBQyxZQUFZLENBQUMsZ0JBQWdCLEVBQUU7WUFDbEMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDNUQsT0FBTyxFQUFFLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxFQUFFLFlBQVksRUFBRSxpQkFBaUIsRUFBRSxZQUFZLEVBQUUsQ0FBQyxFQUFFLENBQUM7U0FDcEYsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxFQUFFLGFBQWEsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQzVDLENBQUM7O0FBNUJILGdEQTZCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGVjcyBmcm9tICdAYXdzLWNkay9hd3MtZWNzJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIEZhcmdhdGVDYXBhY2l0eVByb3ZpZGVyVHlwZSB7XG4gIEZBUkdBVEUgPSAnRkFSR0FURScsXG4gIEZBUkdBVEVfU1BPVCA9ICdGQVJHQVRFX1NQT1QnXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIENhcGFjaXR5UHJvdmlkZXJTdHJhdGVneUl0ZW0ge1xuICByZWFkb25seSBiYXNlPzogbnVtYmVyO1xuICByZWFkb25seSB3ZWlnaHQ6IG51bWJlcjtcbiAgcmVhZG9ubHkgY2FwYWNpdHlQcm92aWRlcjogRmFyZ2F0ZUNhcGFjaXR5UHJvdmlkZXJUeXBlO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEZhcmdhdGVSdW5uZXJQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRhZ3M/OiBzdHJpbmdbXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZWN1cml0eUdyb3VwPzogZWMyLklTZWN1cml0eUdyb3VwO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZhcmdhdGVKb2JTdWJuZXQ/OiBlYzIuU3VibmV0U2VsZWN0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVnaXN0cmF0aW9uVG9rZW4/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2l0bGFiVVJMPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZXhlY3V0b3I/OiBGYXJnYXRlSm9iRXhlY3V0b3I7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNsdXN0ZXJEZWZhdWx0Q2FwYWNpdHlQcm92aWRlclN0cmF0ZWd5PzogQ2FwYWNpdHlQcm92aWRlclN0cmF0ZWd5SXRlbVtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2VydmljZURlZmF1bHRDYXBhY2l0eVByb3ZpZGVyU3RyYXRlZ3k/OiBDYXBhY2l0eVByb3ZpZGVyU3RyYXRlZ3lJdGVtW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEpvYkV4ZWN1dG9ySW1hZ2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBERUJJQU4gPSBKb2JFeGVjdXRvckltYWdlLm9mKCdyZWdpc3RyeS5naXRsYWIuY29tL3RtYWN6dWtpbi10ZXN0LXByb2plY3RzL2ZhcmdhdGUtZHJpdmVyLWRlYmlhbjpsYXRlc3QnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBOT0RFID0gSm9iRXhlY3V0b3JJbWFnZS5vZigncmVnaXN0cnkuZ2l0bGFiLmNvbS9hd3MtZmFyZ2F0ZS1kcml2ZXItZGVtby9kb2NrZXItbm9kZWpzLWdpdGxhYi1jaS1mYXJnYXRlOmxhdGVzdCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBKU0lJID0gSm9iRXhlY3V0b3JJbWFnZS5vZigncmVnaXN0cnkuZ2l0bGFiLmNvbS9wYWh1ZC9kb2NrZXItanNpaS1jZGstZ2l0bGFiLWNpLWZhcmdhdGU6bGF0ZXN0Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgb2YoaW1hZ2U6IHN0cmluZykgeyByZXR1cm4gbmV3IEpvYkV4ZWN1dG9ySW1hZ2UoaW1hZ2UpOyB9XG4gIC8qKlxuICAgKlxuICAgKiBAcGFyYW0gaW1hZ2Ugam9iIGV4ZWN1dG9yIGltYWdlIFVSSVxuICAgKi9cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihwdWJsaWMgcmVhZG9ubHkgdXJpOiBzdHJpbmcpIHsgfVxufVxuXG5jb25zdCBDTFVTVEVSX0RFRkFVTFRfQ0FQQUNJVFlfUFJPVklERVIgPSBbXG4gIEZhcmdhdGVDYXBhY2l0eVByb3ZpZGVyVHlwZS5GQVJHQVRFLFxuICBGYXJnYXRlQ2FwYWNpdHlQcm92aWRlclR5cGUuRkFSR0FURV9TUE9ULFxuXTtcblxuY29uc3QgREVGQVVMVF9DTFVTVEVSX0NBUEFDSVRZX1BST1ZJREVSX1NUUkFURUdZOiBDYXBhY2l0eVByb3ZpZGVyU3RyYXRlZ3lJdGVtW10gPSBbe1xuICBiYXNlOiAwLFxuICB3ZWlnaHQ6IDEsXG4gIGNhcGFjaXR5UHJvdmlkZXI6IEZhcmdhdGVDYXBhY2l0eVByb3ZpZGVyVHlwZS5GQVJHQVRFX1NQT1QsXG59XTtcblxuY29uc3QgREVGQVVMVF9TRVJWSUNFX0NBUEFDSVRZX1BST1ZJREVSX1NUUkFURUdZOiBDYXBhY2l0eVByb3ZpZGVyU3RyYXRlZ3lJdGVtW10gPSBbXG4gIHsgYmFzZTogMCwgd2VpZ2h0OiAwLCBjYXBhY2l0eVByb3ZpZGVyOiBGYXJnYXRlQ2FwYWNpdHlQcm92aWRlclR5cGUuRkFSR0FURSB9LFxuICB7IHdlaWdodDogMSwgY2FwYWNpdHlQcm92aWRlcjogRmFyZ2F0ZUNhcGFjaXR5UHJvdmlkZXJUeXBlLkZBUkdBVEVfU1BPVCB9LFxuXTtcblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgRmFyZ2F0ZVJ1bm5lciBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICByZWFkb25seSB2cGM6IGVjMi5JVnBjO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEZhcmdhdGVSdW5uZXJQcm9wcyApIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy52cGMgPSBwcm9wcy52cGM7XG5cbiAgICBjb25zdCBzdGFjayA9IGNkay5TdGFjay5vZih0aGlzKTtcblxuICAgIGNvbnN0IGZhcmdhdGVTdWJuZXQgPSB0aGlzLnZwYy5zZWxlY3RTdWJuZXRzKHByb3BzLmZhcmdhdGVKb2JTdWJuZXQpO1xuXG4gICAgY29uc3QgY2x1c3RlciA9IG5ldyBlY3MuQ2x1c3Rlcih0aGlzLCAnQ2x1c3RlcicsIHsgdnBjOiB0aGlzLnZwYyB9KTtcbiAgICBjb25zdCBjZm5DbHVzdGVyID0gY2x1c3Rlci5ub2RlLnRyeUZpbmRDaGlsZCgnUmVzb3VyY2UnKSBhcyBlY3MuQ2ZuQ2x1c3RlcjtcbiAgICBjZm5DbHVzdGVyLmFkZFByb3BlcnR5T3ZlcnJpZGUoJ0NhcGFjaXR5UHJvdmlkZXJzJywgQ0xVU1RFUl9ERUZBVUxUX0NBUEFDSVRZX1BST1ZJREVSKTtcbiAgICBjZm5DbHVzdGVyLmFkZFByb3BlcnR5T3ZlcnJpZGUoJ0RlZmF1bHRDYXBhY2l0eVByb3ZpZGVyU3RyYXRlZ3knLCBwcm9wcy5zZXJ2aWNlRGVmYXVsdENhcGFjaXR5UHJvdmlkZXJTdHJhdGVneSA/PyBERUZBVUxUX0NMVVNURVJfQ0FQQUNJVFlfUFJPVklERVJfU1RSQVRFR1kpO1xuXG4gICAgY29uc3QgcnVubmVyVGFzayA9IG5ldyBlY3MuRmFyZ2F0ZVRhc2tEZWZpbml0aW9uKHRoaXMsICdSdW5uZXJUYXNrJywge1xuICAgICAgY3B1OiAyNTYsXG4gICAgICBtZW1vcnlMaW1pdE1pQjogNTEyLFxuICAgIH0pO1xuXG4gICAgY29uc3QgZmFyZ2F0ZVNlY3VyaXR5R3JvdXAgPSBwcm9wcy5zZWN1cml0eUdyb3VwID8/IHRoaXMuY3JlYXRlU2VjdXJpdHlHcm91cCgpO1xuXG4gICAgY29uc3QgcmVnaXN0cmF0aW9uVG9rZW4gPSBwcm9wcy5yZWdpc3RyYXRpb25Ub2tlbiA/PyAodGhpcy5ub2RlLnRyeUdldENvbnRleHQoJ0dJVExBQl9SRUdJU1RSQVRJT05fVE9LRU4nKSB8fCBwcm9jZXNzLmVudi5HSVRMQUJfUkVHSVNUUkFUSU9OX1RPS0VOKTtcblxuICAgIGlmICghcmVnaXN0cmF0aW9uVG9rZW4pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignbWlzc2luZyBHSVRMQUJfUkVHSVNUUkFUSU9OX1RPS0VOIGluIHRoZSBjb250ZXh0IHZhcmlhYmxlJyk7XG4gICAgfVxuXG4gICAgcnVubmVyVGFzay5hZGRDb250YWluZXIoJ3J1bm5lcicsIHtcbiAgICAgIGltYWdlOiBlY3MuQ29udGFpbmVySW1hZ2UuZnJvbVJlZ2lzdHJ5KCdyZWdpc3RyeS5naXRsYWIuY29tL3BhaHVkL2RvY2tlci1naXRsYWItcnVubmVyLWZhcmdhdGUtZHJpdmVyJyksXG4gICAgICBsb2dnaW5nOiBuZXcgZWNzLkF3c0xvZ0RyaXZlcih7IHN0cmVhbVByZWZpeDogJ0dpdGxhYlJ1bm5lck1hbmFnZXInLCBsb2dSZXRlbnRpb246IDcgfSksXG4gICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICBHSVRMQUJfUkVHSVNUUkFUSU9OX1RPS0VOOiByZWdpc3RyYXRpb25Ub2tlbixcbiAgICAgICAgR0lUTEFCX1VSTDogcHJvcHMuZ2l0bGFiVVJMID8/ICdodHRwczovL2dpdGxhYi5jb20nLFxuICAgICAgICBGQVJHQVRFX1JFR0lPTjogcHJvcHMuZXhlY3V0b3I/LnJlZ2lvbiA/PyBzdGFjay5yZWdpb24sXG4gICAgICAgIEZBUkdBVEVfQ0xVU1RFUjogcHJvcHMuZXhlY3V0b3I/LmNsdXN0ZXI/LmNsdXN0ZXJOYW1lID8/IGNsdXN0ZXIuY2x1c3Rlck5hbWUsXG4gICAgICAgIEZBUkdBVEVfU1VCTkVUOiBwcm9wcy5leGVjdXRvcj8uc3VibmV0Py5zdWJuZXRJZCA/PyBmYXJnYXRlU3VibmV0LnN1Ym5ldElkc1swXSxcbiAgICAgICAgRkFSR0FURV9TRUNVUklUWV9HUk9VUDogcHJvcHMuZXhlY3V0b3I/LnNlY3VyaXR5R3JvdXA/LnNlY3VyaXR5R3JvdXBJZCA/PyBmYXJnYXRlU2VjdXJpdHlHcm91cC5zZWN1cml0eUdyb3VwSWQsXG4gICAgICAgIEZBUkdBVEVfVEFTS19ERUZJTklUSU9OOiBwcm9wcy5leGVjdXRvcj8udGFza0RlZmluaXRpb25Bcm4gfHwgbmV3IEZhcmdhdGVKb2JFeGVjdXRvcih0aGlzLCAnSm9iRXhlY3V0b3InKS50YXNrRGVmaW5pdGlvbkFybixcbiAgICAgICAgUlVOTkVSX1RBR19MSVNUOiB0aGlzLnN5bnRoZXNpemVUYWdzKHByb3BzLnRhZ3MgPz8gWydmYXJnYXRlJywgJ2dpdGxhYicsICdhd3MnLCAnZG9ja2VyJ10pLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHJ1bm5lclRhc2sudGFza1JvbGUuYWRkTWFuYWdlZFBvbGljeShpYW0uTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ0FtYXpvbkVDU19GdWxsQWNjZXNzJykpO1xuXG4gICAgY29uc3Qgc3ZjID0gbmV3IGVjcy5GYXJnYXRlU2VydmljZSh0aGlzLCAnUnVubmVyTWFuYWdlclNlcnZpY2UnLCB7XG4gICAgICBjbHVzdGVyLFxuICAgICAgdGFza0RlZmluaXRpb246IHJ1bm5lclRhc2ssXG4gICAgICBzZWN1cml0eUdyb3VwczogW2ZhcmdhdGVTZWN1cml0eUdyb3VwXSxcbiAgICB9KTtcbiAgICBjb25zdCBjZm5TZXJ2aWNlID0gc3ZjLm5vZGUudHJ5RmluZENoaWxkKCdTZXJ2aWNlJykgYXMgZWNzLkNmblNlcnZpY2U7XG4gICAgY2ZuU2VydmljZS5hZGRQcm9wZXJ0eURlbGV0aW9uT3ZlcnJpZGUoJ0xhdW5jaFR5cGUnKTtcbiAgICBjZm5TZXJ2aWNlLmFkZFByb3BlcnR5T3ZlcnJpZGUoJ0NhcGFjaXR5UHJvdmlkZXJTdHJhdGVneScsIHByb3BzLnNlcnZpY2VEZWZhdWx0Q2FwYWNpdHlQcm92aWRlclN0cmF0ZWd5ID8/IERFRkFVTFRfU0VSVklDRV9DQVBBQ0lUWV9QUk9WSURFUl9TVFJBVEVHWSk7XG4gIH1cbiAgcHJpdmF0ZSBzeW50aGVzaXplVGFncyh0YWdzOiBzdHJpbmdbXSk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRhZ3Muam9pbignLCcpO1xuICB9XG4gIHByaXZhdGUgY3JlYXRlU2VjdXJpdHlHcm91cCgpOiBlYzIuSVNlY3VyaXR5R3JvdXAge1xuICAgIGNvbnN0IHNnID0gbmV3IGVjMi5TZWN1cml0eUdyb3VwKHRoaXMsICdGYXJnYXRlU2VjdXJpdHlHcm91cCcsIHsgdnBjOiB0aGlzLnZwYyB9KTtcbiAgICBzZy5jb25uZWN0aW9ucy5hbGxvd0ludGVybmFsbHkoZWMyLlBvcnQuYWxsVHJhZmZpYygpKTtcbiAgICByZXR1cm4gc2c7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBGYXJnYXRlSm9iRXhlY3V0b3JQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGltYWdlPzogSm9iRXhlY3V0b3JJbWFnZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGNsdXN0ZXI/OiBlY3MuSUNsdXN0ZXI7XG4gIHJlYWRvbmx5IHN1Ym5ldD86IGVjMi5JU3VibmV0O1xuICByZWFkb25seSBzZWN1cml0eUdyb3VwPzogZWMyLklTZWN1cml0eUdyb3VwO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBGYXJnYXRlSm9iRXhlY3V0b3IgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0YXNrRGVmaW5pdGlvbkFybjogc3RyaW5nO1xuICByZWFkb25seSByZWdpb246IHN0cmluZztcbiAgcmVhZG9ubHkgY2x1c3Rlcj86IGVjcy5JQ2x1c3RlcjtcbiAgcmVhZG9ubHkgc3VibmV0PzogZWMyLklTdWJuZXQ7XG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXA/OiBlYzIuSVNlY3VyaXR5R3JvdXA7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDpzdHJpbmcsIHByb3BzOiBGYXJnYXRlSm9iRXhlY3V0b3JQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMucmVnaW9uID0gcHJvcHMucmVnaW9uID8/IGNkay5TdGFjay5vZih0aGlzKS5yZWdpb247XG4gICAgdGhpcy5jbHVzdGVyID0gcHJvcHMuY2x1c3RlcjtcbiAgICB0aGlzLnN1Ym5ldCA9IHByb3BzLnN1Ym5ldDtcbiAgICB0aGlzLnNlY3VyaXR5R3JvdXAgPSBwcm9wcy5zZWN1cml0eUdyb3VwO1xuXG4gICAgY29uc3QgdGFzayA9IG5ldyBlY3MuRmFyZ2F0ZVRhc2tEZWZpbml0aW9uKHRoaXMsICdKb2JzVGFzaycsIHtcbiAgICAgIGNwdTogMjU2LFxuICAgICAgbWVtb3J5TGltaXRNaUI6IDUxMixcbiAgICB9KTtcblxuICAgIHRoaXMudGFza0RlZmluaXRpb25Bcm4gPSB0YXNrLnRhc2tEZWZpbml0aW9uQXJuO1xuXG4gICAgY29uc3QgaW1hZ2UgPSBwcm9wcy5pbWFnZSA/PyBKb2JFeGVjdXRvckltYWdlLkRFQklBTjtcblxuICAgIHRhc2suYWRkQ29udGFpbmVyKCdjaS1jb29yZGluYXRvcicsIHtcbiAgICAgIGltYWdlOiBlY3MuQ29udGFpbmVySW1hZ2UuZnJvbVJlZ2lzdHJ5KGltYWdlLnVyaS50b1N0cmluZygpKSxcbiAgICAgIGxvZ2dpbmc6IG5ldyBlY3MuQXdzTG9nRHJpdmVyKHsgc3RyZWFtUHJlZml4OiAnR2l0bGFiUnVubmVySm9iJywgbG9nUmV0ZW50aW9uOiA3IH0pLFxuICAgIH0pLmFkZFBvcnRNYXBwaW5ncyh7IGNvbnRhaW5lclBvcnQ6IDIyIH0pO1xuICB9XG59Il19