# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['typeddfs', 'typeddfs._mixins', 'typeddfs.utils']

package_data = \
{'': ['*']}

install_requires = \
['natsort>=8',
 'orjson>=3.6,<4.0',
 'pandas>=1.3,<2.0',
 'regex>=2021',
 'tabulate>=0.8,<0.9',
 'wcwidth>=0.2']

extras_require = \
{'all': ['pyarrow>=4',
         'lxml>=4',
         'openpyxl>=3',
         'pyxlsb>=1',
         'html5lib>=1',
         'beautifulsoup4>=4',
         'tomlkit>=0.7'],
 'excel': ['openpyxl>=3'],
 'feather': ['pyarrow>=4'],
 'html': ['html5lib>=1', 'beautifulsoup4>=4'],
 'main': ['pyarrow>=4', 'lxml>=4', 'openpyxl>=3', 'tomlkit>=0.7'],
 'parquet': ['pyarrow>=4'],
 'toml': ['tomlkit>=0.7'],
 'xlsb': ['pyxlsb>=1'],
 'xml': ['lxml>=4']}

setup_kwargs = {
    'name': 'typeddfs',
    'version': '0.16.2',
    'description': 'Pandas DataFrame subclasses that enforce structure and can self-organize.',
    'long_description': '# Typed DataFrames\n\n[![Version status](https://img.shields.io/pypi/status/typeddfs?label=status)](https://pypi.org/project/typeddfs)\n[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)\n[![Python version compatibility](https://img.shields.io/pypi/pyversions/typeddfs?label=Python)](https://pypi.org/project/typeddfs)\n[![Version on GitHub](https://img.shields.io/github/v/release/dmyersturnbull/typed-dfs?include_prereleases&label=GitHub)](https://github.com/dmyersturnbull/typed-dfs/releases)\n[![Version on PyPi](https://img.shields.io/pypi/v/typeddfs?label=PyPi)](https://pypi.org/project/typeddfs)  \n[![Build (Actions)](https://img.shields.io/github/workflow/status/dmyersturnbull/typed-dfs/Build%20&%20test?label=Tests)](https://github.com/dmyersturnbull/typed-dfs/actions)\n[![Coverage (coveralls)](https://coveralls.io/repos/github/dmyersturnbull/typed-dfs/badge.svg?branch=main&service=github)](https://coveralls.io/github/dmyersturnbull/typed-dfs?branch=main)\n[![Documentation status](https://readthedocs.org/projects/typed-dfs/badge)](https://typed-dfs.readthedocs.io/en/stable/)\n[![Maintainability](https://api.codeclimate.com/v1/badges/6b804351b6ba5e7694af/maintainability)](https://codeclimate.com/github/dmyersturnbull/typed-dfs/maintainability)\n[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/dmyersturnbull/typed-dfs/badges/quality-score.png?b=main)](https://scrutinizer-ci.com/g/dmyersturnbull/typed-dfs/?branch=main)\n[![Created with Tyrannosaurus](https://img.shields.io/badge/Created_with-Tyrannosaurus-0000ff.svg)](https://github.com/dmyersturnbull/tyrannosaurus)\n\nPandas DataFrame subclasses that self-organize and serialize robustly.\n\n```python\nFilm = TypedDfs.typed("Film").require("name", "studio", "year").build()\ndf = Film.read_csv("file.csv")\nassert df.columns.tolist() == ["name", "studio", "year"]\ntype(df)  # Film\n```\n\nYour types remember how to be read,\nincluding columns, dtypes, indices, and custom requirements.\nNo index_cols=, header=, set_index, or astype needed.\n\n**Read and write any format:**\n\n```python\npath = input("input file? [.csv/.tsv/.tab/.json/.xml.bz2/.feather/.snappy.h5/...]")\ndf = Film.read_file(path)\ndf.write_file("output.snappy")\n```\n\n**Need dataclasses?**\n\n```python\ninstances = df.to_dataclass_instances()\nFilm.from_dataclass_instances(instances)\n```\n\n**Save metadata?**\n\n```python\ndf = df.set_attrs(dataset="piano")\ndf.write_file("df.csv", attrs=True)\ndf = Film.read_file("df.csv", attrs=True)\nprint(df.attrs)  # e.g. {"dataset": "piano")\n```\n\n**Make dirs? Don\'t overwrite?**\n\n```python\ndf.write_file("df.csv", mkdirs=True, overwrite=False)\n```\n\n**Write and verify checksum?**\n\n```python\ndf.write_file("df.csv", file_hash=True)\ndf = Film.read_file("df.csv", file_hash=True)  # fails if wrong\n```\n\n**Example datasets?**\n\n```python\nprint(ExampleDataframes.penguins().df)\n#    species     island  bill_length_mm  ...  flipper_length_mm  body_mass_g     sex\n# 0    Adelie  Torgersen            39.1  ...              181.0       3750.0    MALE\n```\n\nAll standard DataFrame methods remain available.\nUse `.untyped()` or `.vanilla()` if needed, and `.of(df)` for the inverse.\n\n**[Read the docs 📚](https://typed-dfs.readthedocs.io/en/stable/)** for more info and examples.\n\n### 🐛 Pandas serialization bugs fixed\n\nPandas has several issues with serialization.\n\n<details>\n<summary><emph>See: Fixed issues</emph></summary>\nDepending on the format and columns, these issues occur:\n\n- columns being silently added or dropped,\n- errors on either read or write of empty DataFrames,\n- the inability to use DataFrames with indices in Feather,\n- writing to Parquet failing with half-precision,\n- lingering partially written files on error,\n- the buggy xlrd being preferred by read_excel,\n- the buggy odfpy also being preferred,\n- writing a file and reading it back results in a different DataFrame,\n- you can’t write fixed-width format,\n- and the platform text encoding being used rather than utf-8.\n- invalid JSON is written via the built-in json library\n  \n</details>\n\n### 🎁 Other features\n\nSee more in the [guided walkthrough ✏️](https://typed-dfs.readthedocs.io/en/latest/guide.html)\n\n<details>\n<summary><emph>See: Short feature list</emph></summary>\n  \n- Dtype-aware natural sorting\n- UTF-8 by default\n- Near-atomicity of read/write\n- Matrix-like typed dataframes and methods (e.g. `matrix.is_symmetric()`)\n- DataFrame-compatible frozen, hashable, ordered collections (dict, list, and set)\n- Serialize JSON robustly, preserving NaN, inf, −inf, enums, timezones, complex numbers, etc.\n- Serialize more formats like TOML and INI\n- Interpreting paths and formats (e.g. `FileFormat.split("dir/myfile.csv.gz").compression  # gz`)\n- Generate good CLI help text for input DataFrames\n- Parse/verify/add/update/delete files in a .shasum-like file\n  \n</details>\n\n### 💔 Limitations\n\n<details>\n  <summary><emph>See: List of limitations</emph></summary>\n  \n- Multi-level columns are not yet supported.\n- Columns and index levels cannot share names.\n- Duplicate column names are not supported. (These are strange anyway.)\n- A typed DF cannot have columns "level_0", "index", or "Unnamed: 0".\n- `inplace` is forbidden in some functions; avoid it or use `.vanilla()`.\n  \n</details>\n\n### 🔌 Serialization support\n\nTypedDfs provides the methods `read_file` and `write_file`, which guess the format from the\nfilename extension. For example, this will convert a gzipped, tab-delimited file to Feather:\n\n```python\nTastyDf = typeddfs.typed("TastyDf").build()\nTastyDf.read_file("myfile.tab.gz").write_file("myfile.feather")\n```\n\nPandas does most of the serialization, but some formats require extra packages.\nTyped-dfs specifies [extras](https://python-poetry.org/docs/pyproject/#extras) \nto help you get required packages and with compatible versions.\n\nHere are the extras:\n- `feather`: [Feather](https://arrow.apache.org/docs/python/feather.html) (uses: pyarrow)\n- `parquet`: [Parquet (e.g. .snappy)](https://github.com/apache/parquet-format) (uses: pyarrow)\n- `xml` (uses: lxml)\n- `excel`: Excel and LibreOffice .xlsx/.ods/.xls, etc. (uses: openpyxl, defusedxml)\n- `toml`: [TOML](https://toml.io/en/) (uses: tomlkit)\n- `html` (uses: html5lib, beautifulsoup4)\n- `xlsb`: rare binary Excel file (uses: pyxlsb)\n- [HDF5](https://www.hdfgroup.org/solutions/hdf5/) *{no extra provided}* (*use:* `tables`)\n\nFor example, for Feather and TOML support use: `typeddfs[feather,toml]`\nAs a shorthand for all formats, use `typeddfs[all]`.\n\n### 📊 Serialization in-depth\n\n<details>\n<summary><emph>See: Full table</emph></summary>\n  \n| format      | packages                     | extra     | sanity | speed | file sizes |\n| ----------- | ---------------------------- | --------- | ------ | ----- | ---------- |\n| Feather     | `pyarrow`                    | `feather` | +++    | ++++  | +++        |\n| Parquet     | `pyarrow` or `fastparquet` † | `parquet` | ++     | +++   | ++++       |\n| csv/tsv     | none                         | none      | ++     | −−    | −−         |\n| flexwf ‡    | none                         | none      | ++     | −−    | −−         |\n| .fwf        | none                         | none      | +      | −−    | −−         |\n| json        | none                         | none      | −−     | −−−   | −−−        |\n| xml         | `lxml`                       | `xml`     | −      | −−−   | −−−        |\n| .properties | none                         | none      | −−     | −−    | −−         |\n| toml        | `tomlkit`                    | `toml`    | −−     | −−    | −−         |\n| INI         | none                         | none      | −−−    | −−    | −−         |\n| .lines      | none                         | none      | ++     | −−    | −−         |\n| .npy        | none                         | none      | −      | +     | +++        |\n| .npz        | none                         | none      | −      | +     | +++        |\n| .html       | `html5lib,beautifulsoup4`    | `html`    | −−     | −−−   | −−−        |\n| pickle      | none                         | none      | −−     | −−−   | −−−        |\n| XLSX        | `openpyxl,defusedxml`        | `excel`   | +      | −−    | +          |\n| ODS         | `openpyxl,defusedxml`        | `excel`   | +      | −−    | +          |\n| XLS         | `openpyxl,defusedxml`        | `excel`   | −−     | −−    | +          |\n| XLSB        | `pyxlsb`                     | `xlsb`    | −−     | −−    | ++         |\n| HDF5        | `tables`                     | `hdf5`    | −−     | −     | ++         |\n\n**⚠ Note:** The `hdf5` extra is currently disabled.\n</details>\n\n<details>\n<summary><emph>See: serialization notes</emph></summary>\n  \n- † `fastparquet` can be used instead. It is slower but much smaller.\n- Parquet only supports str, float64, float32, int64, int32, and bool.\n  Other numeric types are automatically converted during write.\n- ‡ `.flexwf` is fixed-width with optional delimiters.\n- JSON has inconsistent handling of `None`. ([orjson](https://github.com/ijl/orjson) is more consistent).\n- XML requires Pandas 1.3+.\n- Not all JSON, XML, TOML, and HDF5 files can be read.\n- .ini and .properties can only be written with exactly 2 columns + index levels:\n  a key and a value. INI keys are in the form `section.name`.\n- .lines can only be written with exactly 1 column or index level.\n- .npy and .npz only serialize numpy objects.\n  They are not supported in `read_file` and `write_file`.\n- .html is not supported in `read_file` and `write_file`.\n- Pickle is insecure and not recommended.\n- Pandas supports odfpy for ODS and xlrd for XLS. In fact, it prefers those.\n  However, they are very buggy; openpyxl is much better.\n- XLSM, XLTX, XLTM, XLS, and XLSB files can contain macros, which Microsoft Excel will ingest.\n- XLS is a deprecated format.\n- XLSB is not fully supported in Pandas.\n- HDF may not work on all platforms yet due to a\n  [tables issue](https://github.com/PyTables/PyTables/issues/854).\n\nFeather offers massively better performance over CSV, gzipped CSV, and HDF5\nin read speed, write speed, memory overhead, and compression ratios.\nParquet typically results in smaller file sizes than Feather at some cost in speed.\nFeather is the preferred format for most cases.\n  \n</details>\n\n### 🔒 Security\n\nRefer to the [security policy](https://github.com/dmyersturnbull/typed-dfs/blob/main/SECURITY.md).\n\n### 📝 Extra notes\n\n<details>\n<summary><emph>See: Pinned versions</emph></summary>\n\nDependencies in the extras are only restricted to minimum version numbers;\nlibraries that use them can set their own version ranges.\nFor example, typed-dfs only requires tables >= 0.4, but Pandas can further restrict it.\n[natsort](https://github.com/SethMMorton/natsort) is also only assigned a minimum version number;\nthis is because it receives frequent major version bumps.\nThis means that the result of typed-df’s `sort_natural` could change.\nTo fix this, pin natsort to a specific major version;\ne.g. `natsort = "^8"` with [Poetry](https://python-poetry.org/) or `natsort>=8,<9` with pip.\n                                                                                   \n</details>\n\n### 🍁 Contributing\n\nTyped-Dfs is licensed under the [Apache License, version 2.0](https://www.apache.org/licenses/LICENSE-2.0).\n[New issues](https://github.com/dmyersturnbull/typed-dfs/issues) and pull requests are welcome.\nPlease refer to the [contributing guide](https://github.com/dmyersturnbull/typed-dfs/blob/main/CONTRIBUTING.md).\nGenerated with [Tyrannosaurus](https://github.com/dmyersturnbull/tyrannosaurus).\n',
    'author': 'Douglas Myers-Turnbull',
    'author_email': None,
    'maintainer': 'dmyersturnbull',
    'maintainer_email': None,
    'url': 'https://github.com/dmyersturnbull/typed-dfs',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
