"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Version = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("./component");
/**
 * @experimental
 */
class Version extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        super(project);
        this.changelogFileName = 'changelog.md';
        this.versionFileName = 'version.txt';
        this.releaseTagFileName = 'releasetag.txt';
        const versionInputFile = options.versionInputFile;
        // this command determines if there were any changes since the last release
        // (the top-most commit is not a bump). it is used as a condition for both
        // the `bump` and the `release` tasks.
        const changesSinceLastRelease = '! git log --oneline -1 | grep -q "chore(release):"';
        const changelogFile = path_1.posix.join(options.artifactsDirectory, this.changelogFileName);
        const bumpFile = path_1.posix.join(options.artifactsDirectory, this.versionFileName);
        const releaseTagFile = path_1.posix.join(options.artifactsDirectory, this.releaseTagFileName);
        const env = {
            OUTFILE: versionInputFile,
            CHANGELOG: changelogFile,
            BUMPFILE: bumpFile,
            RELEASETAG: releaseTagFile,
        };
        this.bumpTask = project.addTask('bump', {
            description: 'Bumps version based on latest git tag and generates a changelog entry',
            condition: changesSinceLastRelease,
            env: env,
        });
        this.bumpTask.builtin('release/bump-version');
        this.unbumpTask = project.addTask('unbump', {
            description: 'Restores version to 0.0.0',
            env: env,
        });
        this.unbumpTask.builtin('release/reset-version');
        project.addGitIgnore(`/${changelogFile}`);
        project.addGitIgnore(`/${bumpFile}`);
        project.addPackageIgnore(`/${changelogFile}`);
        project.addPackageIgnore(`/${bumpFile}`);
    }
}
exports.Version = Version;
_a = JSII_RTTI_SYMBOL_1;
Version[_a] = { fqn: "projen.Version", version: "0.29.3" };
/**
 * @experimental
 */
Version.STANDARD_VERSION = 'standard-version@^9';
//# sourceMappingURL=data:application/json;base64,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