"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpgradeDependenciesSchedule = exports.UpgradeDependencies = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const github_1 = require("./github");
const constants_1 = require("./github/constants");
function context(value) {
    return `\${{ ${value} }}`;
}
function setOutput(name, value) {
    return `echo "::set-output name=${name}::${value}"`;
}
const RUNNER_TEMP = context('runner.temp');
const DEFAULT_TOKEN = context('secrets.GITHUB_TOKEN');
const REPO = context('github.repository');
const RUN_ID = context('github.run_id');
const RUN_URL = `https://github.com/${REPO}/actions/runs/${RUN_ID}`;
const UBUNTU_LATEST = 'ubuntu-latest';
/**
 * (experimental) Upgrade node project dependencies.
 *
 * @experimental
 */
class UpgradeDependencies extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _c, _d;
        super(project);
        /**
         * (experimental) The workflows that execute the upgrades.
         *
         * One workflow per branch.
         *
         * @experimental
         */
        this.workflows = [];
        this._project = project;
        this.options = options;
        this.pullRequestTitle = (_c = options.pullRequestTitle) !== null && _c !== void 0 ? _c : 'upgrade dependencies';
        this.ignoresProjen = (_d = this.options.ignoreProjen) !== null && _d !== void 0 ? _d : true;
        project.addDevDeps('npm-check-updates@^11');
    }
    // create the upgrade task and a corresponding github workflow
    // for each requested branch.
    /**
     * (experimental) Called before synthesis.
     *
     * @experimental
     */
    preSynthesize() {
        var _c, _d, _e, _f, _g;
        const task = this.createTask();
        if (this._project.github && ((_c = this.options.workflow) !== null && _c !== void 0 ? _c : true)) {
            // represents the default reopsitory branch.
            // just like not specifying anything.
            const defaultBranch = undefined;
            const branches = (_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.branches) !== null && _e !== void 0 ? _e : ((_g = (_f = this._project.release) === null || _f === void 0 ? void 0 : _f.branches) !== null && _g !== void 0 ? _g : [defaultBranch]);
            for (const branch of branches) {
                this.workflows.push(this.createWorkflow(task, this._project.github, branch));
            }
        }
    }
    createTask() {
        var _c, _d;
        const taskName = (_c = this.options.taskName) !== null && _c !== void 0 ? _c : 'upgrade';
        const task = this._project.addTask(taskName, {
            // this task should not run in CI mode because its designed to
            // update package.json and lock files.
            env: { CI: '0' },
            description: this.pullRequestTitle,
        });
        const exclude = (_d = this.options.exclude) !== null && _d !== void 0 ? _d : [];
        if (this.ignoresProjen) {
            exclude.push('projen');
        }
        for (const dep of ['dev', 'optional', 'peer', 'prod', 'bundle']) {
            const ncuCommand = ['npm-check-updates', '--dep', dep, '--upgrade', '--target=minor'];
            if (exclude.length > 0) {
                ncuCommand.push(`--reject='${exclude.join(',')}'`);
            }
            if (this.options.include) {
                ncuCommand.push(`--filter='${this.options.include.join(',')}'`);
            }
            task.exec(ncuCommand.join(' '));
        }
        // run "yarn/npm install" to update the lockfile and install any deps (such as projen)
        task.exec(this._project.package.installAndUpdateLockfileCommand);
        // run upgrade command to upgrade transitive deps as well
        task.exec(this._project.package.renderUpgradePackagesCommand(exclude, this.options.include));
        // run "projen" to give projen a chance to update dependencies (it will also run "yarn install")
        task.exec(this._project.projenCommand);
        return task;
    }
    createWorkflow(task, github, branch) {
        var _c, _d;
        const schedule = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.schedule) !== null && _d !== void 0 ? _d : UpgradeDependenciesSchedule.DAILY;
        const workflowName = `${task.name}${branch ? `-${branch.replace(/\//g, '-')}` : ''}`;
        const workflow = github.addWorkflow(workflowName);
        const triggers = {
            workflowDispatch: {},
            schedule: schedule.cron ? schedule.cron.map(e => ({ cron: e })) : undefined,
        };
        workflow.on(triggers);
        const upgrade = this.createUpgrade(task, branch);
        const pr = this.createPr(workflow, upgrade);
        const jobs = {};
        jobs[upgrade.jobId] = upgrade.job;
        jobs[pr.jobId] = pr.job;
        workflow.addJobs(jobs);
        return workflow;
    }
    createUpgrade(task, branch) {
        var _c, _d, _e;
        const build = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.rebuild) !== null && _d !== void 0 ? _d : true;
        const patchFile = '.upgrade.tmp.patch';
        const buildStepId = 'build';
        const conclusion = 'conclusion';
        // thats all we should need at this stage since all we do is clone.
        // note that this also prevents new code that is introduced in the upgrade
        // to have write access to anything, in case its somehow executed. (for example during build)
        const permissions = {
            contents: github_1.workflows.JobPermission.READ,
        };
        const outputs = {};
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
                with: branch ? { ref: branch } : undefined,
            },
            constants_1.SET_GIT_IDENTITY_WORKFLOW_STEP,
            ...this._project.installWorkflowSteps,
            {
                name: 'Upgrade dependencies',
                run: this._project.runTaskCommand(task),
            },
        ];
        if (build) {
            steps.push({
                name: 'Build',
                id: buildStepId,
                run: `${this._project.runTaskCommand(this._project.buildTask)} && ${setOutput(conclusion, 'success')} || ${setOutput(conclusion, 'failure')}`,
            });
            outputs[conclusion] = {
                stepId: buildStepId,
                outputName: conclusion,
            };
        }
        steps.push({
            name: 'Create Patch',
            run: [
                'git add .',
                `git diff --patch --staged > ${patchFile}`,
            ].join('\n'),
        }, {
            name: 'Upload patch',
            uses: 'actions/upload-artifact@v2',
            with: { name: patchFile, path: patchFile },
        });
        return {
            job: {
                name: 'Upgrade',
                container: (_e = this.options.workflowOptions) === null || _e === void 0 ? void 0 : _e.container,
                permissions: permissions,
                runsOn: UBUNTU_LATEST,
                outputs: outputs,
                steps: steps,
            },
            jobId: 'upgrade',
            patchFile: patchFile,
            build: build,
            buildConclusionOutput: conclusion,
            ref: branch,
        };
    }
    createPr(workflow, upgrade) {
        var _c, _d, _e, _f;
        const customToken = ((_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.secret) ? context(`secrets.${this.options.workflowOptions.secret}`) : undefined;
        const workflowName = workflow.name;
        const branchName = `github-actions/${workflowName}`;
        const prStepId = 'create-pr';
        const title = `chore(deps): ${this.pullRequestTitle}`;
        const description = [
            'Upgrades project dependencies. See details in [workflow run].',
            '',
            `[Workflow Run]: ${RUN_URL}`,
            '',
            '------',
            '',
            `*Automatically created by projen via the "${workflow.name}" workflow*`,
        ].join('\n');
        const comitter = `${constants_1.GITHUB_ACTIONS_USER.name} <${constants_1.GITHUB_ACTIONS_USER.email}>`;
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
                with: upgrade.ref ? { ref: upgrade.ref } : undefined,
            },
            constants_1.SET_GIT_IDENTITY_WORKFLOW_STEP,
            {
                name: 'Download patch',
                uses: 'actions/download-artifact@v2',
                with: { name: upgrade.patchFile, path: RUNNER_TEMP },
            },
            {
                name: 'Apply patch',
                run: `[ -s ${RUNNER_TEMP}/${upgrade.patchFile} ] && git apply ${RUNNER_TEMP}/${upgrade.patchFile} || echo "Empty patch. Skipping."`,
            },
            {
                name: 'Create Pull Request',
                id: prStepId,
                uses: 'peter-evans/create-pull-request@v3',
                with: {
                    // the pr can modify workflow files, so we need to use the custom
                    // secret if one is configured.
                    'token': customToken !== null && customToken !== void 0 ? customToken : DEFAULT_TOKEN,
                    'commit-message': `${title}\n\n${description}`,
                    'branch': branchName,
                    'title': title,
                    'labels': ((_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.labels) === null || _e === void 0 ? void 0 : _e.join(',')) || undefined,
                    'body': description,
                    'author': comitter,
                    'committer': comitter,
                    'signoff': (_f = this.options.signoff) !== null && _f !== void 0 ? _f : true,
                },
            },
        ];
        let writeChecksPermission = false;
        if (this._project.buildWorkflowJobId && upgrade.build) {
            const body = {
                name: this._project.buildWorkflowJobId,
                head_sha: branchName,
                status: 'completed',
                conclusion: context(`needs.${upgrade.jobId}.outputs.${upgrade.buildConclusionOutput}`),
                output: {
                    title: `Created via the ${workflowName} workflow.`,
                    summary: `Action run URL: ${RUN_URL}`,
                },
            };
            steps.push({
                name: 'Update status check',
                if: `steps.${prStepId}.outputs.pull-request-url != \'\'`,
                run: 'curl -i --fail '
                    + '-X POST '
                    + '-H "Accept: application/vnd.github.v3+json" '
                    + `-H "Authorization: token \${GITHUB_TOKEN}" https://api.github.com/repos/${REPO}/check-runs `
                    + `-d '${JSON.stringify(body)}'`,
                env: { GITHUB_TOKEN: DEFAULT_TOKEN },
            });
            // necessary to update status checks
            writeChecksPermission = true;
        }
        return {
            job: {
                name: 'Create Pull Request',
                needs: [upgrade.jobId],
                permissions: {
                    contents: github_1.workflows.JobPermission.WRITE,
                    pullRequests: github_1.workflows.JobPermission.WRITE,
                    checks: writeChecksPermission ? github_1.workflows.JobPermission.WRITE : undefined,
                },
                runsOn: UBUNTU_LATEST,
                steps: steps,
            },
            jobId: 'pr',
        };
    }
}
exports.UpgradeDependencies = UpgradeDependencies;
_a = JSII_RTTI_SYMBOL_1;
UpgradeDependencies[_a] = { fqn: "projen.UpgradeDependencies", version: "0.29.3" };
/**
 * (experimental) How often to check for new versions and raise pull requests for version upgrades.
 *
 * @experimental
 */
class UpgradeDependenciesSchedule {
    constructor(cron) {
        this.cron = cron;
    }
    /**
     * (experimental) Create a schedule from a raw cron expression.
     *
     * @experimental
     */
    static expressions(cron) {
        return new UpgradeDependenciesSchedule(cron);
    }
}
exports.UpgradeDependenciesSchedule = UpgradeDependenciesSchedule;
_b = JSII_RTTI_SYMBOL_1;
UpgradeDependenciesSchedule[_b] = { fqn: "projen.UpgradeDependenciesSchedule", version: "0.29.3" };
/**
 * (experimental) Disables automatic upgrades.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.NEVER = new UpgradeDependenciesSchedule([]);
/**
 * (experimental) At 00:00.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.DAILY = new UpgradeDependenciesSchedule(['0 0 * * *']);
/**
 * (experimental) At 00:00 on every day-of-week from Monday through Friday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKDAY = new UpgradeDependenciesSchedule(['0 0 * * 1-5']);
/**
 * (experimental) At 00:00 on Monday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKLY = new UpgradeDependenciesSchedule(['0 0 * * 1']);
/**
 * (experimental) At 00:00 on day-of-month 1.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.MONTHLY = new UpgradeDependenciesSchedule(['0 0 1 * *']);
//# sourceMappingURL=data:application/json;base64,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