import { Component } from './component';
import { GithubWorkflow, workflows } from './github';
import { NodeProject } from './node-project';
/**
 * (experimental) Options for `UpgradeDependencies`.
 *
 * @experimental
 */
export interface UpgradeDependenciesOptions {
    /**
     * (experimental) List of package names to exclude during the upgrade.
     *
     * @default - Nothing is excluded.
     * @experimental
     */
    readonly exclude?: string[];
    /**
     * (experimental) List of package names to include during the upgrade.
     *
     * @default - Everything is included.
     * @experimental
     */
    readonly include?: string[];
    /**
     * (experimental) Include a github workflow for creating PR's that upgrades the required dependencies, either by manual dispatch, or by a schedule.
     *
     * If this is `false`, only a local projen task is created, which can be executed manually to
     * upgrade the dependencies.
     *
     * @default - true for root projects, false for sub-projects.
     * @experimental
     */
    readonly workflow?: boolean;
    /**
     * (experimental) Options for the github workflow.
     *
     * Only applies if `workflow` is true.
     *
     * @default - default options.
     * @experimental
     */
    readonly workflowOptions?: UpgradeDependenciesWorkflowOptions;
    /**
     * (experimental) The name of the task that will be created.
     *
     * This will also be the workflow name.
     *
     * @default "upgrade".
     * @experimental
     */
    readonly taskName?: string;
    /**
     * (experimental) Title of the pull request to use (should be all lower-case).
     *
     * @default "upgrade dependencies"
     * @experimental
     */
    readonly pullRequestTitle?: string;
    /**
     * (experimental) Whether or not to ignore projen upgrades.
     *
     * @default true
     * @experimental
     */
    readonly ignoreProjen?: boolean;
    /**
     * (experimental) Add Signed-off-by line by the committer at the end of the commit log message.
     *
     * @default true
     * @experimental
     */
    readonly signoff?: boolean;
}
/**
 * (experimental) Upgrade node project dependencies.
 *
 * @experimental
 */
export declare class UpgradeDependencies extends Component {
    /**
     * (experimental) The workflows that execute the upgrades.
     *
     * One workflow per branch.
     *
     * @experimental
     */
    readonly workflows: GithubWorkflow[];
    private readonly options;
    private readonly _project;
    private readonly pullRequestTitle;
    /**
     * (experimental) Whether or not projen is also upgraded in this workflow,.
     *
     * @experimental
     */
    readonly ignoresProjen: boolean;
    /**
     * @experimental
     */
    constructor(project: NodeProject, options?: UpgradeDependenciesOptions);
    /**
     * (experimental) Called before synthesis.
     *
     * @experimental
     */
    preSynthesize(): void;
    private createTask;
    private createWorkflow;
    private createUpgrade;
    private createPr;
}
/**
 * (experimental) Options for `UpgradeDependencies.workflowOptions`.
 *
 * @experimental
 */
export interface UpgradeDependenciesWorkflowOptions {
    /**
     * (experimental) Schedule to run on.
     *
     * @default UpgradeDependenciesSchedule.DAILY
     * @experimental
     */
    readonly schedule?: UpgradeDependenciesSchedule;
    /**
     * (experimental) Which secret to use when creating the PR.
     *
     * When using the default github token, PR's created by this workflow
     * will not trigger any subsequent workflows (i.e the build workflow).
     * This is why this workflow also runs 'build' by default, and manually updates
     * the status check of the PR.
     *
     * If you pass a token that has the `workflow` permissions, you can skip running
     * build in this workflow by specifying `rebuild: false`.
     *
     * @default - default github token.
     * @see https://github.com/peter-evans/create-pull-request/issues/48
     * @experimental
     */
    readonly secret?: string;
    /**
     * (experimental) Labels to apply on the PR.
     *
     * @default - no labels.
     * @experimental
     */
    readonly labels?: string[];
    /**
     * (experimental) Execute 'build' after the upgrade.
     *
     * When true, the workflow will run the project build task after the dependency upgrade.
     * This means that the PR created will include any changes caused by the `build` command,
     * (e.g project synth changes, test snapshots)
     *
     * This is necessary when using the default github token.
     *
     * @default true
     * @see `secret` for more details.
     * @experimental
     */
    readonly rebuild?: boolean;
    /**
     * (experimental) Job container options.
     *
     * @default - defaults
     * @experimental
     */
    readonly container?: workflows.ContainerOptions;
    /**
     * (experimental) List of branches to create PR's for.
     *
     * @default - All release branches configured for the project.
     * @experimental
     */
    readonly branches?: string[];
}
/**
 * (experimental) How often to check for new versions and raise pull requests for version upgrades.
 *
 * @experimental
 */
export declare class UpgradeDependenciesSchedule {
    readonly cron: string[];
    /**
     * (experimental) Disables automatic upgrades.
     *
     * @experimental
     */
    static readonly NEVER: UpgradeDependenciesSchedule;
    /**
     * (experimental) At 00:00.
     *
     * @experimental
     */
    static readonly DAILY: UpgradeDependenciesSchedule;
    /**
     * (experimental) At 00:00 on every day-of-week from Monday through Friday.
     *
     * @experimental
     */
    static readonly WEEKDAY: UpgradeDependenciesSchedule;
    /**
     * (experimental) At 00:00 on Monday.
     *
     * @experimental
     */
    static readonly WEEKLY: UpgradeDependenciesSchedule;
    /**
     * (experimental) At 00:00 on day-of-month 1.
     *
     * @experimental
     */
    static readonly MONTHLY: UpgradeDependenciesSchedule;
    /**
     * (experimental) Create a schedule from a raw cron expression.
     *
     * @experimental
     */
    static expressions(cron: string[]): UpgradeDependenciesSchedule;
    private constructor();
}
