"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
const typescript_1 = require("../typescript");
/**
 * (experimental) Sets up a typescript project to use TypeScript for projenrc.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : '.projenrc.ts';
        // tell eslint to take .projenrc.ts into account as a dev-dependency
        (_c = project.eslint) === null || _c === void 0 ? void 0 : _c.allowDevDeps(this.rcfile);
        (_d = project.eslint) === null || _d === void 0 ? void 0 : _d.addIgnorePattern(`!${this.rcfile}`);
        (_e = project.tsconfigEslint) === null || _e === void 0 ? void 0 : _e.addInclude(this.rcfile);
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps('ts-node@^9');
        // use the --skip-project flag to ensure ts-node doesn't use the
        // tsconfig.json settings intended for the project's source code
        // see: https://github.com/projen/projen/issues/948
        project.addTask(typescript_1.TypeScriptProject.DEFAULT_TASK, { exec: `ts-node --skip-project ${this.rcfile}` });
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split('.');
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join('.');
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(importName);
        const lines = new Array();
        lines.push(`import { ${[...imports].sort().join(', ')} } from '${moduleName}';`);
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push('project.synth();');
        fs_1.writeFileSync(rcfile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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