"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Publisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const constants_1 = require("../github/constants");
const workflows_model_1 = require("../github/workflows-model");
const node_package_1 = require("../node-package");
const JSII_RELEASE_VERSION = 'latest';
const GITHUB_PACKAGES_REGISTRY = 'npm.pkg.github.com';
const GITHUB_PACKAGES_MAVEN_REPOSITORY = 'https://maven.pkg.github.com';
const ARTIFACTS_DIR = 'dist';
const JSII_RELEASE_IMAGE = 'jsii/superchain:1-buster-slim-node14';
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
class Publisher extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c, _d;
        super(project);
        // the jobs to add to the release workflow
        this.jobs = {};
        this.buildJobId = options.buildJobId;
        this.artifactName = options.artifactName;
        this.jsiiReleaseVersion = (_b = options.jsiiReleaseVersion) !== null && _b !== void 0 ? _b : JSII_RELEASE_VERSION;
        this.condition = options.condition;
        this.failureIssue = (_c = options.failureIssue) !== null && _c !== void 0 ? _c : false;
        this.failureIssueLabel = (_d = options.failureIssueLabel) !== null && _d !== void 0 ? _d : 'failed-release';
    }
    /**
     * (experimental) Renders a set of workflow jobs for all the publishers.
     *
     * @returns GitHub workflow jobs
     * @experimental
     */
    render() {
        return { ...this.jobs };
    }
    /**
     * (experimental) Creates a GitHub Release.
     *
     * @param options Options.
     * @experimental
     */
    publishToGitHubReleases(options) {
        const changelogFile = `${ARTIFACTS_DIR}/${options.changelogFile}`;
        const releaseTagFile = `${ARTIFACTS_DIR}/${options.releaseTagFile}`;
        // create a github release
        const releaseTag = `$(cat ${releaseTagFile})`;
        const ghRelease = [
            `gh release create ${releaseTag}`,
            '-R $GITHUB_REPOSITORY',
            `-F ${changelogFile}`,
            `-t ${releaseTag}`,
            '--target $GITHUB_REF',
        ].join(' ');
        // release script that does not error when re-releasing a given version
        const idempotentRelease = [
            'errout=$(mktemp);',
            `${ghRelease} 2> $errout && true;`,
            'exitcode=$?;',
            'if [ $exitcode -ne 0 ] && ! grep -q "Release.tag_name already exists" $errout; then',
            'cat $errout;',
            'exit $exitcode;',
            'fi',
        ].join(' ');
        this.addPublishJob({
            name: 'github',
            registryName: 'GitHub Releases',
            permissions: {
                contents: workflows_model_1.JobPermission.WRITE,
            },
            workflowEnv: {
                GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                GITHUB_REPOSITORY: '${{ github.repository }}',
                GITHUB_REF: '${{ github.ref }}',
            },
            run: idempotentRelease,
        });
    }
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options = {}) {
        var _b;
        const isGitHubPackages = (_b = options.registry) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_REGISTRY);
        this.addPublishJob({
            name: 'npm',
            run: this.jsiiReleaseCommand('jsii-release-npm'),
            containerImage: JSII_RELEASE_IMAGE,
            registryName: 'npm',
            env: {
                NPM_DIST_TAG: options.distTag,
                NPM_REGISTRY: options.registry,
            },
            permissions: {
                contents: workflows_model_1.JobPermission.READ,
                packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
            },
            workflowEnv: {
                NPM_TOKEN: secret(node_package_1.defaultNpmToken(options.npmTokenSecret, options.registry)),
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options = {}) {
        var _b;
        this.addPublishJob({
            name: 'nuget',
            containerImage: JSII_RELEASE_IMAGE,
            run: this.jsiiReleaseCommand('jsii-release-nuget'),
            registryName: 'NuGet Gallery',
            workflowEnv: {
                NUGET_API_KEY: secret((_b = options.nugetApiKeySecret) !== null && _b !== void 0 ? _b : 'NUGET_API_KEY'),
            },
        });
    }
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        const isGitHubPackages = (_b = options.mavenRepositoryUrl) === null || _b === void 0 ? void 0 : _b.startsWith(GITHUB_PACKAGES_MAVEN_REPOSITORY);
        const isGitHubActor = isGitHubPackages && options.mavenUsername == undefined;
        const mavenServerId = (_c = options.mavenServerId) !== null && _c !== void 0 ? _c : (isGitHubPackages ? 'github' : undefined);
        if (isGitHubPackages && mavenServerId != 'github') {
            throw new Error('publishing to GitHub Packages requires the "mavenServerId" to be "github"');
        }
        this.addPublishJob({
            name: 'maven',
            registryName: 'Maven Central',
            containerImage: JSII_RELEASE_IMAGE,
            run: this.jsiiReleaseCommand('jsii-release-maven'),
            env: {
                MAVEN_ENDPOINT: options.mavenEndpoint,
                MAVEN_SERVER_ID: mavenServerId,
                MAVEN_REPOSITORY_URL: options.mavenRepositoryUrl,
            },
            workflowEnv: {
                MAVEN_GPG_PRIVATE_KEY: isGitHubPackages ? undefined : secret((_d = options.mavenGpgPrivateKeySecret) !== null && _d !== void 0 ? _d : 'MAVEN_GPG_PRIVATE_KEY'),
                MAVEN_GPG_PRIVATE_KEY_PASSPHRASE: isGitHubPackages ? undefined : secret((_e = options.mavenGpgPrivateKeyPassphrase) !== null && _e !== void 0 ? _e : 'MAVEN_GPG_PRIVATE_KEY_PASSPHRASE'),
                MAVEN_PASSWORD: secret((_f = options.mavenPassword) !== null && _f !== void 0 ? _f : (isGitHubPackages ? 'GITHUB_TOKEN' : 'MAVEN_PASSWORD')),
                MAVEN_USERNAME: isGitHubActor ? '${{ github.actor }}' : secret((_g = options.mavenUsername) !== null && _g !== void 0 ? _g : 'MAVEN_USERNAME'),
                MAVEN_STAGING_PROFILE_ID: isGitHubPackages ? undefined : secret((_h = options.mavenStagingProfileId) !== null && _h !== void 0 ? _h : 'MAVEN_STAGING_PROFILE_ID'),
            },
            permissions: {
                contents: workflows_model_1.JobPermission.READ,
                packages: isGitHubPackages ? workflows_model_1.JobPermission.WRITE : undefined,
            },
        });
    }
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options = {}) {
        var _b, _c;
        this.addPublishJob({
            name: 'pypi',
            registryName: 'PyPI',
            run: this.jsiiReleaseCommand('jsii-release-pypi'),
            containerImage: JSII_RELEASE_IMAGE,
            env: {
                TWINE_REPOSITORY_URL: options.twineRegistryUrl,
            },
            workflowEnv: {
                TWINE_USERNAME: secret((_b = options.twineUsernameSecret) !== null && _b !== void 0 ? _b : 'TWINE_USERNAME'),
                TWINE_PASSWORD: secret((_c = options.twinePasswordSecret) !== null && _c !== void 0 ? _c : 'TWINE_PASSWORD'),
            },
        });
    }
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options = {}) {
        var _b, _c, _d;
        this.addPublishJob({
            name: 'golang',
            run: this.jsiiReleaseCommand('jsii-release-golang'),
            containerImage: JSII_RELEASE_IMAGE,
            registryName: 'GitHub',
            env: {
                GITHUB_REPO: options.githubRepo,
                GIT_BRANCH: options.gitBranch,
                GIT_USER_NAME: (_b = options.gitUserName) !== null && _b !== void 0 ? _b : constants_1.GITHUB_ACTIONS_USER.name,
                GIT_USER_EMAIL: (_c = options.gitUserEmail) !== null && _c !== void 0 ? _c : constants_1.GITHUB_ACTIONS_USER.email,
                GIT_COMMIT_MESSAGE: options.gitCommitMessage,
            },
            workflowEnv: {
                GITHUB_TOKEN: secret((_d = options.githubTokenSecret) !== null && _d !== void 0 ? _d : 'GO_GITHUB_TOKEN'),
            },
        });
    }
    addPublishJob(opts) {
        var _b, _c;
        const jobname = `release_${opts.name}`;
        if (jobname in this.jobs) {
            throw new Error(`Duplicate job with name "${jobname}"`);
        }
        const requiredEnv = new Array();
        // jobEnv is the env we pass to the github job (task environment + secrets/expressions).
        const jobEnv = { ...opts.env };
        const workflowEnvEntries = Object.entries((_b = opts.workflowEnv) !== null && _b !== void 0 ? _b : {})
            .filter(([_, value]) => value != undefined);
        for (const [name, expression] of workflowEnvEntries) {
            requiredEnv.push(name);
            jobEnv[name] = expression;
        }
        // define a task which can be used through `projen publish:xxx`.
        this.project.addTask(`publish:${opts.name.toLocaleLowerCase()}`, {
            description: `Publish this package to ${opts.registryName}`,
            env: opts.env,
            requiredEnv: requiredEnv,
            exec: opts.run,
        });
        const steps = [
            {
                name: 'Download build artifacts',
                uses: 'actions/download-artifact@v2',
                with: {
                    name: this.artifactName,
                    path: ARTIFACTS_DIR,
                },
            },
            {
                name: 'Release',
                // it would have been nice if we could just run "projen publish:xxx" here but that is not possible because this job does not checkout sources
                run: opts.run,
                env: jobEnv,
            },
        ];
        const perms = (_c = opts.permissions) !== null && _c !== void 0 ? _c : { contents: workflows_model_1.JobPermission.READ };
        if (this.failureIssue) {
            steps.push(...[
                {
                    name: 'Extract Version',
                    if: '${{ failure() }}',
                    id: 'extract-version',
                    run: 'echo "::set-output name=VERSION::$(cat dist/version.txt)"',
                },
                {
                    name: 'Create Issue',
                    if: '${{ failure() }}',
                    uses: 'imjohnbo/issue-bot@v3',
                    with: {
                        labels: this.failureIssueLabel,
                        title: `Publishing v\${{ steps.extract-version.outputs.VERSION }} to ${opts.registryName} failed`,
                        body: 'See https://github.com/${{ github.repository }}/actions/runs/${{ github.run_id }}',
                    },
                    env: {
                        GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                    },
                },
            ]);
            Object.assign(perms, { issues: workflows_model_1.JobPermission.WRITE });
        }
        const job = {
            name: `Publish to ${opts.registryName}`,
            permissions: perms,
            if: this.condition,
            needs: [this.buildJobId],
            runsOn: 'ubuntu-latest',
            container: opts.containerImage ? {
                image: opts.containerImage,
            } : undefined,
            steps,
        };
        this.jobs[jobname] = job;
    }
    jsiiReleaseCommand(command) {
        return `npx -p jsii-release@${this.jsiiReleaseVersion} ${command}`;
    }
}
exports.Publisher = Publisher;
_a = JSII_RTTI_SYMBOL_1;
Publisher[_a] = { fqn: "projen.release.Publisher", version: "0.29.3" };
function secret(secretName) {
    return `\${{ secrets.${secretName} }}`;
}
//# sourceMappingURL=data:application/json;base64,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