"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pytest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
/**
 * @experimental
 */
class Pytest extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        const version = (_b = options.version) !== null && _b !== void 0 ? _b : '6.2.1';
        project.addDevDependency(`pytest@${version}`);
        this.testTask = project.addTask('test', {
            description: 'Runs tests',
            exec: [
                'pytest',
                ...(options.maxFailures ? [`--maxfail=${options.maxFailures}`] : []),
            ].join(' '),
        });
        new sample_file_1.SampleDir(project, 'tests', {
            files: {
                '__init__.py': '',
                'test_example.py': [
                    'import pytest',
                    '',
                    `from ${project.moduleName}.example import hello`,
                    '',
                    '@pytest.mark.parametrize(',
                    '    ("name", "expected"),',
                    '    [',
                    '        ("A. Musing", "Hello A. Musing!"),',
                    '        ("traveler", "Hello traveler!"),',
                    '        ("projen developer", "Hello projen developer!"),',
                    '    ],',
                    ')',
                    'def test_hello(name, expected):',
                    '    """Example test with parametrization."""',
                    '    assert hello(name) == expected',
                    '',
                ].join('\n'),
            },
        });
    }
}
exports.Pytest = Pytest;
_a = JSII_RTTI_SYMBOL_1;
Pytest[_a] = { fqn: "projen.python.Pytest", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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