"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const github_1 = require("./github");
const workflows_model_1 = require("./github/workflows-model");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const release_1 = require("./release");
const upgrade_dependencies_1 = require("./upgrade-dependencies");
const util_1 = require("./util");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.GitHubProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.workflowBootstrapSteps = (_b = options.workflowBootstrapSteps) !== null && _b !== void 0 ? _b : [];
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_c = options.workflowNodeVersion) !== null && _c !== void 0 ? _c : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
        });
        // first, execute projen as the first thing during build
        if ((_d = options.projenDuringBuild) !== null && _d !== void 0 ? _d : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_e = options.npmignoreEnabled) !== null && _e !== void 0 ? _e : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_f = options.gitignore) === null || _f === void 0 ? void 0 : _f.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_g = options.npmignore) === null || _g === void 0 ? void 0 : _g.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_RC}`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${common_1.PROJEN_DIR}/`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_k = options.projenDevDependency) !== null && _k !== void 0 ? _k : true;
        if (projen) {
            const postfix = options.projenVersion ? `@${options.projenVersion}` : '';
            this.addDevDeps(`projen${postfix}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true);
        const mutableBuilds = (_m = options.mutableBuild) !== null && _m !== void 0 ? _m : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_o = options.antitamper) !== null && _o !== void 0 ? _o : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_p = options.jest) !== null && _p !== void 0 ? _p : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if (buildEnabled) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const postBuildSteps = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            // disable anti-tamper if build workflow is mutable
            const antitamperSteps = ((_q = !mutableBuilds) !== null && _q !== void 0 ? _q : this.antitamper) ? [{
                    // anti-tamper check (fails if there were changes to committed files)
                    // this will identify any non-committed files generated during build (e.g. test snapshots)
                    name: 'Anti-tamper check',
                    run: 'git diff --ignore-space-at-eol --exit-code',
                }] : [];
            // run codecov if enabled or a secret token name is passed in
            // AND jest must be configured
            if ((options.codeCov || options.codeCovTokenSecret) && ((_r = this.jest) === null || _r === void 0 ? void 0 : _r.config)) {
                postBuildSteps.push({
                    name: 'Upload coverage to Codecov',
                    uses: 'codecov/codecov-action@v1',
                    with: options.codeCovTokenSecret ? {
                        token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                        directory: this.jest.config.coverageDirectory,
                    } : {
                        directory: this.jest.config.coverageDirectory,
                    },
                });
            }
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            postBuildSteps.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            postBuildSteps.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            postBuildSteps.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/${repo}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            // if we pushed changes, we need to mark the current commit as failed, so
            // that GitHub auto-merge does not risk merging this commit before the
            // event for the new commit has registered.
            postBuildSteps.push({
                if: hasChanges,
                name: 'Cancel workflow (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/${repo}/actions/runs/\${{ github.run_id }}/cancel`,
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            postBuildSteps.push(...antitamperSteps);
            if (this.github) {
                this.buildWorkflow = new github_1.TaskWorkflow(this.github, {
                    name: 'build',
                    jobId: buildJobId,
                    triggers: {
                        pullRequest: {},
                    },
                    env: {
                        CI: 'true',
                    },
                    permissions: {
                        checks: workflows_model_1.JobPermission.WRITE,
                        contents: workflows_model_1.JobPermission.WRITE,
                        actions: workflows_model_1.JobPermission.WRITE,
                    },
                    checkoutWith: mutableBuilds ? {
                        ref: branch,
                        repository: repo,
                    } : undefined,
                    preBuildSteps: [
                        ...antitamperSteps,
                        ...this.installWorkflowSteps,
                    ],
                    task: this.buildTask,
                    postBuildSteps,
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                });
                this.buildWorkflowJobId = buildJobId;
            }
        }
        const release = (_t = (_s = options.release) !== null && _s !== void 0 ? _s : options.releaseWorkflow) !== null && _t !== void 0 ? _t : (this.parent ? false : true);
        if (release) {
            this.addDevDeps(version_1.Version.STANDARD_VERSION);
            this.release = new release_1.Release(this, {
                versionFile: 'package.json',
                task: this.buildTask,
                branch: (_u = options.defaultReleaseBranch) !== null && _u !== void 0 ? _u : 'main',
                ...options,
                releaseWorkflowSetupSteps: [
                    ...this.installWorkflowSteps,
                    ...(_v = options.releaseWorkflowSetupSteps) !== null && _v !== void 0 ? _v : [],
                ],
            });
            this.publisher = this.release.publisher;
            if ((_w = options.releaseToNpm) !== null && _w !== void 0 ? _w : false) {
                this.release.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_x = this.github) === null || _x === void 0 ? void 0 : _x.mergify) {
            this.autoMerge = new github_1.AutoMerge(this.github, {
                buildJob: this.buildWorkflowJobId,
                ...options.autoMergeOptions,
            });
        }
        const dependabot = (_y = options.dependabot) !== null && _y !== void 0 ? _y : false;
        const depsUpgrade = (_z = options.depsUpgrade) !== null && _z !== void 0 ? _z : !dependabot;
        if (dependabot && depsUpgrade) {
            throw new Error("'dependabot' cannot be configured together with 'depsUpgrade'");
        }
        if (options.projenUpgradeAutoMerge !== undefined && options.autoApproveProjenUpgrades !== undefined) {
            throw new Error("'projenUpgradeAutoMerge' cannot be configured together with 'autoApproveProjenUpgrades'");
        }
        const projenAutoApprove = (_0 = options.autoApproveProjenUpgrades) !== null && _0 !== void 0 ? _0 : ((_1 = options.projenUpgradeAutoMerge) !== null && _1 !== void 0 ? _1 : false);
        const depsAutoApprove = (_2 = options.autoApproveUpgrades) !== null && _2 !== void 0 ? _2 : false;
        if (projenAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of projen upgrades requires configuring `autoApproveOptions`');
        }
        if (depsAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of dependencies upgrades requires configuring `autoApproveOptions`');
        }
        const autoApproveLabel = (condition) => { var _b; return (condition && ((_b = this.autoApprove) === null || _b === void 0 ? void 0 : _b.label)) ? [this.autoApprove.label] : undefined; };
        let ignoresProjen;
        if (dependabot) {
            const defaultOptions = {
                labels: autoApproveLabel(depsAutoApprove),
            };
            const dependabotConf = (_3 = this.github) === null || _3 === void 0 ? void 0 : _3.addDependabot(util_1.deepMerge([defaultOptions, (_4 = options.dependabotOptions) !== null && _4 !== void 0 ? _4 : {}]));
            ignoresProjen = dependabotConf === null || dependabotConf === void 0 ? void 0 : dependabotConf.ignoresProjen;
        }
        if (depsUpgrade) {
            const defaultOptions = {
                // if projen secret is defined we can also upgrade projen here.
                ignoreProjen: !options.projenUpgradeSecret,
                workflowOptions: {
                    // if projen secret is defined, use it (otherwise default to GITHUB_TOKEN).
                    secret: options.projenUpgradeSecret,
                    container: options.workflowContainerImage ? {
                        image: options.workflowContainerImage,
                    } : undefined,
                    labels: autoApproveLabel(depsAutoApprove),
                },
            };
            const upgradeDependencies = new upgrade_dependencies_1.UpgradeDependencies(this, util_1.deepMerge([defaultOptions, (_5 = options.depsUpgradeOptions) !== null && _5 !== void 0 ? _5 : {}]));
            ignoresProjen = upgradeDependencies.ignoresProjen;
        }
        // create a dedicated workflow to upgrade projen itself if needed
        if (ignoresProjen && this.package.packageName !== 'projen') {
            new upgrade_dependencies_1.UpgradeDependencies(this, {
                include: ['projen'],
                taskName: 'upgrade-projen',
                pullRequestTitle: 'upgrade projen',
                ignoreProjen: false,
                workflow: !!options.projenUpgradeSecret,
                workflowOptions: {
                    schedule: upgrade_dependencies_1.UpgradeDependenciesSchedule.expressions((_6 = options.projenUpgradeSchedule) !== null && _6 !== void 0 ? _6 : ['0 6 * * *']),
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                    secret: options.projenUpgradeSecret,
                    labels: autoApproveLabel(projenAutoApprove),
                },
            });
        }
        if ((_7 = options.pullRequestTemplate) !== null && _7 !== void 0 ? _7 : true) {
            (_8 = this.github) === null || _8 === void 0 ? void 0 : _8.addPullRequestTemplate(...(_9 = options.pullRequestTemplateContents) !== null && _9 !== void 0 ? _9 : []);
        }
        const projenrcJs = (_10 = options.projenrcJs) !== null && _10 !== void 0 ? _10 : !options.projenrcJson;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        // first run the workflow bootstrap steps
        install.push(...this.workflowBootstrapSteps);
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v2.2.0',
                with: { 'node-version': this.nodeVersion },
            });
        }
        if (this.package.packageManager === node_package_1.NodePackageManager.PNPM) {
            install.push({
                name: 'Setup pnpm',
                uses: 'pnpm/action-setup@v2.0.1',
                with: { version: '6.14.7' },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    /**
     * (experimental) Exclude these files from the bundled package.
     *
     * Implemented by project types based on the
     * packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.
     *
     * @experimental
     */
    addPackageIgnore(pattern) {
        var _b;
        (_b = this.npmignore) === null || _b === void 0 ? void 0 : _b.addPatterns(pattern);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, {
                spdx: this.package.license,
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * This will
     * typically be `npx projen TASK`.
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        return `${this.package.projenCommand} ${task.name}`;
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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