import { AutoMerge, DependabotOptions, TaskWorkflow } from './github';
import { MergifyOptions } from './github/mergify';
import { JobStep } from './github/workflows-model';
import { IgnoreFile } from './ignore-file';
import { ProjenrcOptions } from './javascript/projenrc';
import { Jest, JestOptions } from './jest';
import { NodePackage, NodePackageManager, NodePackageOptions } from './node-package';
import { GitHubProject, GitHubProjectOptions } from './project';
import { Release, ReleaseProjectOptions, Publisher } from './release';
import { Task } from './tasks';
import { UpgradeDependenciesOptions } from './upgrade-dependencies';
/**
 * @experimental
 */
export interface NodeProjectOptions extends GitHubProjectOptions, NodePackageOptions, ReleaseProjectOptions {
    /**
     * (experimental) License copyright owner.
     *
     * @default - defaults to the value of authorName or "" if `authorName` is undefined.
     * @experimental
     */
    readonly copyrightOwner?: string;
    /**
     * (experimental) The copyright years to put in the LICENSE file.
     *
     * @default - current year
     * @experimental
     */
    readonly copyrightPeriod?: string;
    /**
     * (experimental) Version of projen to install.
     *
     * @default - Defaults to the latest version.
     * @experimental
     */
    readonly projenVersion?: string;
    /**
     * (experimental) Indicates of "projen" should be installed as a devDependency.
     *
     * @default true
     * @experimental
     */
    readonly projenDevDependency?: boolean;
    /**
     * (experimental) Define a GitHub workflow for building PRs.
     *
     * @default - true if not a subproject
     * @experimental
     */
    readonly buildWorkflow?: boolean;
    /**
     * (experimental) Automatically update files modified during builds to pull-request branches.
     *
     * This means
     * that any files synthesized by projen or e.g. test snapshots will always be up-to-date
     * before a PR is merged.
     *
     * Implies that PR builds do not have anti-tamper checks.
     *
     * @default true
     * @experimental
     */
    readonly mutableBuild?: boolean;
    /**
     * (experimental) Define a GitHub workflow step for sending code coverage metrics to https://codecov.io/ Uses codecov/codecov-action@v1 A secret is required for private repos. Configured with @codeCovTokenSecret.
     *
     * @default false
     * @experimental
     */
    readonly codeCov?: boolean;
    /**
     * (experimental) Define the secret name for a specified https://codecov.io/ token A secret is required to send coverage for private repositories.
     *
     * @default - if this option is not specified, only public repositories are supported
     * @experimental
     */
    readonly codeCovTokenSecret?: string;
    /**
     * (deprecated) DEPRECATED: renamed to `release`.
     *
     * @default - true if not a subproject
     * @deprecated see `release`.
     */
    readonly releaseWorkflow?: boolean;
    /**
     * (experimental) Add release management to this project.
     *
     * @default - true (false for subprojects)
     * @experimental
     * @featured true
     */
    readonly release?: boolean;
    /**
     * (experimental) The name of the main release branch.
     *
     * @default "main"
     * @experimental
     */
    readonly defaultReleaseBranch: string;
    /**
     * (experimental) Workflow steps to use in order to bootstrap this repo.
     *
     * @default "yarn install --frozen-lockfile && yarn projen"
     * @experimental
     */
    readonly workflowBootstrapSteps?: any[];
    /**
     * (experimental) Automatically release to npm when new versions are introduced.
     *
     * @default false
     * @experimental
     */
    readonly releaseToNpm?: boolean;
    /**
     * (experimental) The node version to use in GitHub workflows.
     *
     * @default - same as `minNodeVersion`
     * @experimental
     */
    readonly workflowNodeVersion?: string;
    /**
     * (experimental) Use dependabot to handle dependency upgrades.
     *
     * Cannot be used in conjunction with `depsUpgrade`.
     *
     * @default false
     * @experimental
     */
    readonly dependabot?: boolean;
    /**
     * (experimental) Options for dependabot.
     *
     * @default - default options
     * @experimental
     */
    readonly dependabotOptions?: DependabotOptions;
    /**
     * (experimental) Use github workflows to handle dependency upgrades.
     *
     * Cannot be used in conjunction with `dependabot`.
     *
     * @default true
     * @experimental
     */
    readonly depsUpgrade?: boolean;
    /**
     * (experimental) Options for depsUpgrade.
     *
     * @default - default options
     * @experimental
     */
    readonly depsUpgradeOptions?: UpgradeDependenciesOptions;
    /**
     * (experimental) Options for mergify.
     *
     * @default - default options
     * @experimental
     */
    readonly mergifyOptions?: MergifyOptions;
    /**
     * (experimental) Periodically submits a pull request for projen upgrades (executes `yarn projen:upgrade`).
     *
     * This setting is a GitHub secret name which contains a GitHub Access Token
     * with `repo` and `workflow` permissions.
     *
     * This token is used to submit the upgrade pull request, which will likely
     * include workflow updates.
     *
     * To create a personal access token see https://github.com/settings/tokens
     *
     * @default - no automatic projen upgrade pull requests
     * @experimental
     */
    readonly projenUpgradeSecret?: string;
    /**
     * (deprecated) Automatically approve projen upgrade PRs, allowing them to be merged by mergify (if configued).
     *
     * Throw if set to true but `autoApproveOptions` are not defined.
     *
     * @default false
     * @deprecated use `autoApproveProjenUpgrades`.
     */
    readonly projenUpgradeAutoMerge?: boolean;
    /**
     * (experimental) Automatically approve projen upgrade PRs, allowing them to be merged by mergify (if configued).
     *
     * Throw if set to true but `autoApproveOptions` are not defined.
     *
     * @default false
     * @experimental
     */
    readonly autoApproveProjenUpgrades?: boolean;
    /**
     * (experimental) Automatically approve deps upgrade PRs, allowing them to be merged by mergify (if configued).
     *
     * Throw if set to true but `autoApproveOptions` are not defined.
     *
     * @default - true
     * @experimental
     */
    readonly autoApproveUpgrades?: boolean;
    /**
     * (experimental) Customize the projenUpgrade schedule in cron expression.
     *
     * @default [ "0 6 * * *" ]
     * @experimental
     */
    readonly projenUpgradeSchedule?: string[];
    /**
     * (experimental) Execute `projen` as the first step of the `build` task to synthesize project files.
     *
     * This applies both to local builds and to CI builds.
     *
     * Disabling this feature is NOT RECOMMENDED and means that manual changes to
     * synthesized project files will be persisted.
     *
     * @default true
     * @experimental
     */
    readonly projenDuringBuild?: boolean;
    /**
     * (experimental) Defines an .npmignore file. Normally this is only needed for libraries that are packaged as tarballs.
     *
     * @default true
     * @experimental
     */
    readonly npmignoreEnabled?: boolean;
    /**
     * (deprecated) Additional entries to .npmignore.
     *
     * @deprecated - use `project.addPackageIgnore`
     */
    readonly npmignore?: string[];
    /**
     * (experimental) Include a GitHub pull request template.
     *
     * @default true
     * @experimental
     */
    readonly pullRequestTemplate?: boolean;
    /**
     * (experimental) The contents of the pull request template.
     *
     * @default - default content
     * @experimental
     */
    readonly pullRequestTemplateContents?: string[];
    /**
     * (experimental) Additional entries to .gitignore.
     *
     * @experimental
     */
    readonly gitignore?: string[];
    /**
     * (experimental) Setup jest unit tests.
     *
     * @default true
     * @experimental
     */
    readonly jest?: boolean;
    /**
     * (experimental) Jest options.
     *
     * @default - default options
     * @experimental
     */
    readonly jestOptions?: JestOptions;
    /**
     * (experimental) Generate (once) .projenrc.js (in JavaScript). Set to `false` in order to disable .projenrc.js generation.
     *
     * @default - true if projenrcJson is false
     * @experimental
     */
    readonly projenrcJs?: boolean;
    /**
     * (experimental) Options for .projenrc.js.
     *
     * @default - default options
     * @experimental
     */
    readonly projenrcJsOptions?: ProjenrcOptions;
}
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
export declare enum AutoRelease {
    /**
     * (experimental) Automatically bump & release a new version for every commit to "main".
     *
     * @experimental
     */
    EVERY_COMMIT = 0,
    /**
     * (experimental) Automatically bump & release a new version on a daily basis.
     *
     * @experimental
     */
    DAILY = 1
}
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
export declare class NodeProject extends GitHubProject {
    /**
     * (experimental) API for managing the node package.
     *
     * @experimental
     */
    readonly package: NodePackage;
    /**
     * (experimental) The .npmignore file.
     *
     * @experimental
     */
    readonly npmignore?: IgnoreFile;
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies(): boolean;
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint(): string;
    /**
     * (experimental) Compiles the code.
     *
     * By default for node.js projects this task is empty.
     *
     * @experimental
     */
    readonly compileTask: Task;
    /**
     * (experimental) Tests the code.
     *
     * @experimental
     */
    readonly testTask: Task;
    /**
     * (experimental) Compiles the test code.
     *
     * @experimental
     */
    readonly testCompileTask: Task;
    /**
     * (experimental) The task responsible for a full release build.
     *
     * It spawns: compile + test + release + package
     *
     * @experimental
     */
    readonly buildTask: Task;
    /**
     * (experimental) Automatic PR merges.
     *
     * @experimental
     */
    readonly autoMerge?: AutoMerge;
    /**
     * (experimental) The PR build GitHub workflow.
     *
     * `undefined` if `buildWorkflow` is disabled.
     *
     * @experimental
     */
    readonly buildWorkflow?: TaskWorkflow;
    /**
     * @experimental
     */
    readonly buildWorkflowJobId?: string;
    /**
     * (deprecated) Package publisher.
     *
     * This will be `undefined` if the project does not have a
     * release workflow.
     *
     * @deprecated use `release.publisher`.
     */
    readonly publisher?: Publisher;
    /**
     * (experimental) Release management.
     *
     * @experimental
     */
    readonly release?: Release;
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion(): string | undefined;
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion(): string | undefined;
    private readonly nodeVersion?;
    /**
     * (experimental) Indicates if workflows have anti-tamper checks.
     *
     * @experimental
     */
    readonly antitamper: boolean;
    /**
     * @deprecated use `package.npmDistTag`
     */
    protected readonly npmDistTag: string;
    /**
     * @deprecated use `package.npmRegistry`
     */
    protected readonly npmRegistry: string;
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager(): NodePackageManager;
    /**
     * (experimental) The command to use to run scripts (e.g. `yarn run` or `npm run` depends on the package manager).
     *
     * @experimental
     */
    readonly runScriptCommand: string;
    /**
     * (experimental) The Jest configuration (if enabled).
     *
     * @experimental
     */
    readonly jest?: Jest;
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand(): string;
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest(): any;
    private readonly workflowBootstrapSteps;
    /**
     * @experimental
     */
    constructor(options: NodeProjectOptions);
    /**
     * @experimental
     */
    addBins(bins: Record<string, string>): void;
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name: string, command: string): void;
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name: string): void;
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name: string): boolean;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands: string[]): void;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands: string[]): void;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands: string[]): void;
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields: {
        [name: string]: any;
    }): void;
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords: string[]): void;
    /**
     * @experimental
     */
    get installWorkflowSteps(): JobStep[];
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps: string[]): void;
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps: string[]): void;
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps: string[]): void;
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps: string[]): void;
    /**
     * (experimental) Exclude these files from the bundled package.
     *
     * Implemented by project types based on the
     * packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.
     *
     * @experimental
     */
    addPackageIgnore(pattern: string): void;
    private addLicense;
    private addDefaultGitIgnore;
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * This will
     * typically be `npx projen TASK`.
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task: Task): string;
}
/**
 * @experimental
 */
export interface NodeWorkflowSteps {
    /**
     * @experimental
     */
    readonly antitamper: any[];
    /**
     * @experimental
     */
    readonly install: any[];
}
