"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Parses a projenrc.json file, uses it to generate a corresponding
 * projenrc.js file, and then run it to synthesize its contents.
 *
 * Environment variables:
 *
 * - PROJENRC_FILE: (optional) the name of the JSON file to parse from.
 *   Defaults to `.projenrc.json`.
 */
const fs = require("fs-extra");
const create_1 = require("../cli/create");
const inventory_1 = require("../inventory");
const option_hints_1 = require("../option-hints");
let filename = process.env.PROJENRC_FILE;
if (!filename || filename == '') {
    filename = '.projenrc.json';
}
const { type, ...json } = fs.readJsonSync(filename, { encoding: 'utf8' });
if (!type) {
    throw new Error('projenrc.json requires a "type" field with the fully qualified type name. e.g. projen.web.ReactProject');
}
const projectType = inventory_1.resolveProjectType(type);
if (!projectType) {
    throw new Error(`Could not find project type with the fully qualified name "${type}".`);
}
create_1.createProject({
    dir: '.',
    type: projectType,
    params: json,
    comments: option_hints_1.NewProjectOptionHints.NONE,
    synth: true,
    post: false,
});
//# sourceMappingURL=data:application/json;base64,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