"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiDocgen = void 0;
/**
 * Creates an API.md file based on the jsii manifest:
 * - Adds a `docgen` script to package.json
 * - Runs `jsii-docgen` after compilation
 * - Enforces that API.md is checked in
 */
class JsiiDocgen {
    constructor(project) {
        project.addDevDeps('jsii-docgen');
        const docgen = project.addTask('docgen', {
            description: 'Generate API.md from .jsii manifest',
            exec: 'jsii-docgen',
        });
        project.compileTask.spawn(docgen);
        project.gitignore.include('/API.md');
    }
}
exports.JsiiDocgen = JsiiDocgen;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoianNpaS1kb2NnZW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvanNpaS1kb2NnZW4udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7Ozs7O0dBS0c7QUFDSCxNQUFhLFVBQVU7SUFDckIsWUFBWSxPQUFvQjtRQUM5QixPQUFPLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRWxDLE1BQU0sTUFBTSxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFO1lBQ3ZDLFdBQVcsRUFBRSxxQ0FBcUM7WUFDbEQsSUFBSSxFQUFFLGFBQWE7U0FDcEIsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDbEMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdkMsQ0FBQztDQUNGO0FBWkQsZ0NBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBKc2lpUHJvamVjdCB9IGZyb20gJy4vanNpaS1wcm9qZWN0JztcblxuLyoqXG4gKiBDcmVhdGVzIGFuIEFQSS5tZCBmaWxlIGJhc2VkIG9uIHRoZSBqc2lpIG1hbmlmZXN0OlxuICogLSBBZGRzIGEgYGRvY2dlbmAgc2NyaXB0IHRvIHBhY2thZ2UuanNvblxuICogLSBSdW5zIGBqc2lpLWRvY2dlbmAgYWZ0ZXIgY29tcGlsYXRpb25cbiAqIC0gRW5mb3JjZXMgdGhhdCBBUEkubWQgaXMgY2hlY2tlZCBpblxuICovXG5leHBvcnQgY2xhc3MgSnNpaURvY2dlbiB7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IEpzaWlQcm9qZWN0KSB7XG4gICAgcHJvamVjdC5hZGREZXZEZXBzKCdqc2lpLWRvY2dlbicpO1xuXG4gICAgY29uc3QgZG9jZ2VuID0gcHJvamVjdC5hZGRUYXNrKCdkb2NnZW4nLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ0dlbmVyYXRlIEFQSS5tZCBmcm9tIC5qc2lpIG1hbmlmZXN0JyxcbiAgICAgIGV4ZWM6ICdqc2lpLWRvY2dlbicsXG4gICAgfSk7XG5cbiAgICBwcm9qZWN0LmNvbXBpbGVUYXNrLnNwYXduKGRvY2dlbik7XG4gICAgcHJvamVjdC5naXRpZ25vcmUuaW5jbHVkZSgnL0FQSS5tZCcpO1xuICB9XG59Il19