"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const semver = require("semver");
const json_1 = require("./json");
const typescript_config_1 = require("./typescript-config");
const DEFAULT_TEST_REPORTS_DIR = 'test-reports';
/**
 * (experimental) Installs the following npm scripts:.
 *
 * - `test` will run `jest --passWithNoTests`
 * - `test:watch` will run `jest --watch`
 * - `test:update` will run `jest -u`
 *
 * @experimental
 */
class Jest {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2;
        this.project = project;
        // Jest snapshot files are generated files!
        project.root.annotateGenerated('*.snap');
        const jestDep = options.jestVersion ? `jest@${options.jestVersion}` : 'jest';
        project.addDevDeps(jestDep);
        this.jestConfig = options.jestConfig;
        this.typescriptConfig = options.typescriptConfig;
        this.ignorePatterns = (_d = (_c = (_b = this.jestConfig) === null || _b === void 0 ? void 0 : _b.testPathIgnorePatterns) !== null && _c !== void 0 ? _c : options.ignorePatterns) !== null && _d !== void 0 ? _d : ['/node_modules/'];
        this.watchIgnorePatterns = (_f = (_e = this.jestConfig) === null || _e === void 0 ? void 0 : _e.watchPathIgnorePatterns) !== null && _f !== void 0 ? _f : ['/node_modules/'];
        this.coverageReporters = (_h = (_g = this.jestConfig) === null || _g === void 0 ? void 0 : _g.coverageReporters) !== null && _h !== void 0 ? _h : ['json', 'lcov', 'clover'];
        this.testMatch = (_k = (_j = this.jestConfig) === null || _j === void 0 ? void 0 : _j.testMatch) !== null && _k !== void 0 ? _k : ['**\/__tests__/**\/*.[jt]s?(x)', '**\/?(*.)+(spec|test).[tj]s?(x)'];
        const coverageDirectory = (_m = (_l = this.jestConfig) === null || _l === void 0 ? void 0 : _l.coverageDirectory) !== null && _m !== void 0 ? _m : 'coverage';
        this.reporters = [];
        if ((_o = options.preserveDefaultReporters) !== null && _o !== void 0 ? _o : true) {
            this.reporters.unshift('default');
        }
        this.config = {
            ...this.jestConfig,
            clearMocks: (_q = (_p = this.jestConfig) === null || _p === void 0 ? void 0 : _p.clearMocks) !== null && _q !== void 0 ? _q : true,
            collectCoverage: (_t = (_r = options.coverage) !== null && _r !== void 0 ? _r : (_s = this.jestConfig) === null || _s === void 0 ? void 0 : _s.collectCoverage) !== null && _t !== void 0 ? _t : true,
            coverageReporters: this.coverageReporters,
            coverageDirectory: coverageDirectory,
            coveragePathIgnorePatterns: (_v = (_u = this.jestConfig) === null || _u === void 0 ? void 0 : _u.coveragePathIgnorePatterns) !== null && _v !== void 0 ? _v : this.ignorePatterns,
            testPathIgnorePatterns: this.ignorePatterns,
            watchPathIgnorePatterns: this.watchIgnorePatterns,
            testMatch: this.testMatch,
            reporters: this.reporters,
            snapshotResolver: (() => this._snapshotResolver),
        };
        if ((_w = options.junitReporting) !== null && _w !== void 0 ? _w : true) {
            const reportsDir = DEFAULT_TEST_REPORTS_DIR;
            this.addReporter([
                'jest-junit',
                { outputDirectory: reportsDir },
            ]);
            project.addDevDeps('jest-junit@^12');
            project.gitignore.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
            (_x = project.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('# jest-junit artifacts', `/${reportsDir}/`, 'junit.xml');
        }
        if ((_y = this.jestConfig) === null || _y === void 0 ? void 0 : _y.reporters) {
            for (const reporter of this.jestConfig.reporters) {
                this.addReporter(reporter);
            }
        }
        if ((_z = this.jestConfig) === null || _z === void 0 ? void 0 : _z.coverageThreshold) {
            this.config.coverageThreshold = {
                global: (_0 = this.jestConfig) === null || _0 === void 0 ? void 0 : _0.coverageThreshold,
            };
        }
        this.configureTestCommand();
        if (options.configFilePath) {
            this.file = new json_1.JsonFile(project, options.configFilePath, {
                obj: this.config,
            });
        }
        else {
            project.addFields({ jest: this.config });
        }
        const coverageDirectoryPath = path.posix.join('/', coverageDirectory, '/');
        (_1 = project.npmignore) === null || _1 === void 0 ? void 0 : _1.exclude(coverageDirectoryPath);
        project.gitignore.exclude(coverageDirectoryPath);
        if ((_2 = options.coverageText) !== null && _2 !== void 0 ? _2 : true) {
            this.coverageReporters.push('text');
        }
    }
    /**
     * (experimental) Adds a test match pattern.
     *
     * @param pattern glob pattern to match for tests.
     * @experimental
     */
    addTestMatch(pattern) {
        this.testMatch.push(pattern);
    }
    /**
     * (experimental) Adds a watch ignore pattern.
     *
     * @param pattern The pattern (regular expression).
     * @experimental
     */
    addWatchIgnorePattern(pattern) {
        this.watchIgnorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addIgnorePattern(pattern) {
        this.ignorePatterns.push(pattern);
    }
    /**
     * @experimental
     */
    addReporter(reporter) {
        this.reporters.push(reporter);
    }
    /**
     * @experimental
     */
    addSnapshotResolver(file) {
        this._snapshotResolver = file;
    }
    /**
     * (experimental) Merges passed in typescript config options with jest configured typescript options from .projenrc Add Jest config settings for typescript options.
     *
     * @param options TypescriptConfigOptions.
     * @experimental
     */
    generateTypescriptConfig(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        const tsconfig = new typescript_config_1.TypescriptConfig(this.project, {
            fileName: (_b = options.fileName) !== null && _b !== void 0 ? _b : 'tsconfig.jest.json',
            include: [
                ...options.include ? options.include : [],
                ...((_c = this.typescriptConfig) === null || _c === void 0 ? void 0 : _c.include) ? (_d = this.typescriptConfig) === null || _d === void 0 ? void 0 : _d.include : [],
            ],
            exclude: [
                ...options.exclude ? options.exclude : [],
                ...((_e = this.typescriptConfig) === null || _e === void 0 ? void 0 : _e.exclude) ? (_f = this.typescriptConfig) === null || _f === void 0 ? void 0 : _f.exclude : [],
            ],
            compilerOptions: {
                ...options.compilerOptions,
                ...(_g = this.typescriptConfig) === null || _g === void 0 ? void 0 : _g.compilerOptions,
            },
        });
        this.config.preset = 'ts-jest';
        // only process .ts files
        this.config.testMatch = (_j = (_h = this.jestConfig) === null || _h === void 0 ? void 0 : _h.testMatch) !== null && _j !== void 0 ? _j : [
            '**/__tests__/**/*.ts?(x)',
            '**/?(*.)+(spec|test).ts?(x)',
        ];
        // specify tsconfig.json
        this.config.globals = {
            'ts-jest': {
                tsconfig: tsconfig.fileName,
            },
        };
        // add relevant deps
        this.project.addDevDeps('@types/jest', 'ts-jest');
        return tsconfig;
    }
    configureTestCommand() {
        const jestOpts = ['--passWithNoTests', '--all'];
        const jestConfigOpts = this.file && this.file.path != 'jest.config.json' ? ` -c ${this.file.path}` : '';
        // if the project has anti-tamper configured, it should be safe to always run tests
        // with --updateSnapshot because if we forget to commit a snapshot change the CI build will fail.
        if (this.project.antitamper) {
            jestOpts.push('--updateSnapshot');
        }
        // as recommended in the jest docs, node > 14 may use native v8 coverage collection
        // https://jestjs.io/docs/en/cli#--coverageproviderprovider
        if (this.project.package.minNodeVersion && semver.gte(this.project.package.minNodeVersion, '14.0.0')) {
            jestOpts.push('--coverageProvider=v8');
        }
        this.project.testTask.exec(`jest ${jestOpts.join(' ')}${jestConfigOpts}`);
        const testWatch = this.project.tasks.tryFind('test:watch');
        if (!testWatch) {
            this.project.addTask('test:watch', {
                description: 'Run jest in watch mode',
                exec: `jest --watch${jestConfigOpts}`,
            });
        }
        const testUpdate = this.project.tasks.tryFind('test:update');
        if (!testUpdate) {
            this.project.addTask('test:update', {
                description: 'Update jest snapshots',
                exec: `jest --updateSnapshot${jestConfigOpts}`,
            });
        }
    }
}
exports.Jest = Jest;
_a = JSII_RTTI_SYMBOL_1;
Jest[_a] = { fqn: "projen.Jest", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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