"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
const node_project_1 = require("../node-project");
/**
 * (experimental) Sets up a javascript project to use TypeScript for projenrc.
 *
 * @experimental
 */
class Projenrc extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        this.rcfile = (_b = options.filename) !== null && _b !== void 0 ? _b : '.projenrc.js';
        // this is the task projen executes when running `projen`
        project.addTask(node_project_1.NodeProject.DEFAULT_TASK, { exec: `node ${this.rcfile}` });
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.newProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split('.');
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join('.');
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            comments: bootstrap.comments,
            args: bootstrap.args,
            type: bootstrap.type,
        });
        imports.add(importName);
        const lines = new Array();
        lines.push(`const { ${[...imports].sort().join(', ')} } = require('${moduleName}');`);
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push('project.synth();');
        fs_1.writeFileSync(rcfile, lines.join('\n'));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.javascript.Projenrc", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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