"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenPackaging = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Configures a maven project to produce a .jar archive with sources and javadocs.
 *
 * @experimental
 */
class MavenPackaging extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, pom, options = {}) {
        var _b, _c, _d;
        super(project);
        pom.addPlugin('org.apache.maven.plugins/maven-jar-plugin@3.2.0', {
            configuration: {
                archive: {
                    index: true,
                    manifest: {
                        addDefaultImplementationEntries: true,
                        addDefaultSpecificationEntries: true,
                    },
                },
            },
        });
        if ((_b = options.sources) !== null && _b !== void 0 ? _b : true) {
            pom.addPlugin('org.apache.maven.plugins/maven-source-plugin@3.2.1', {
                executions: [
                    { id: 'attach-sources', goals: ['jar'] },
                ],
            });
        }
        if ((_c = options.javadocs) !== null && _c !== void 0 ? _c : true) {
            pom.addPlugin('org.apache.maven.plugins/maven-javadoc-plugin@3.2.0', {
                executions: [
                    { id: 'attach-javadocs', goals: ['jar'] },
                ],
                configuration: {
                    failOnError: false,
                    show: 'protected',
                    sourceFileExcludes: { exclude: options.javadocsExclude },
                    detectJavaApiLink: false,
                    additionalJOptions: {
                        additionalJOption: [
                            '-J-XX:+TieredCompilation',
                            '-J-XX:TieredStopAtLevel=1',
                        ],
                    },
                },
            });
        }
        const env = {
            MAVEN_OPTS: '-XX:+TieredCompilation -XX:TieredStopAtLevel=1',
        };
        const distdir = (_d = options.distdir) !== null && _d !== void 0 ? _d : 'dist/java';
        this.task = project.addTask('package', {
            description: `Creates a java deployment package under ${distdir}`,
            env,
        });
        this.task.exec(`mkdir -p ${distdir}`);
        this.task.exec(`mvn deploy -D=altDeploymentRepository=local::default::file:///$PWD/${distdir}`);
        project.gitignore.exclude(distdir);
    }
}
exports.MavenPackaging = MavenPackaging;
_a = JSII_RTTI_SYMBOL_1;
MavenPackaging[_a] = { fqn: "projen.java.MavenPackaging", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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