"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IgnoreFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * @experimental
 */
class IgnoreFile extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath) {
        super(project, filePath, { editGitignore: filePath !== '.gitignore' });
        this._patterns = new Array();
    }
    /**
     * (experimental) Add ignore patterns.
     *
     * Files that match this pattern will be ignored. If the
     * pattern starts with a negation mark `!`, files that match will _not_ be
     * ignored.
     *
     * Comment lines (start with `#`) are ignored.
     *
     * @param patterns Ignore patterns.
     * @experimental
     */
    addPatterns(...patterns) {
        for (const pattern of patterns) {
            // skip comments
            if (pattern.startsWith('#')) {
                continue;
            }
            this.normalizePatterns(pattern);
            this._patterns.push(pattern);
        }
    }
    normalizePatterns(pattern) {
        const opposite = pattern.startsWith('!') ? pattern.slice(1) : '!' + pattern;
        remove(this._patterns, pattern); // prevent duplicates
        remove(this._patterns, opposite);
        if (pattern.endsWith('/')) {
            const prefix = opposite;
            for (const p of [...this._patterns]) {
                if (p.startsWith(prefix)) {
                    remove(this._patterns, p);
                }
            }
        }
    }
    /**
     * (experimental) Removes patterns previously added from the ignore file.
     *
     * If `addPattern()` is called after this, the pattern will be added again.
     *
     * @param patterns patters to remove.
     * @experimental
     */
    removePatterns(...patterns) {
        for (const p of patterns) {
            remove(this._patterns, p);
        }
    }
    /**
     * (experimental) Ignore the files that match these patterns.
     *
     * @param patterns The patterns to match.
     * @experimental
     */
    exclude(...patterns) {
        return this.addPatterns(...patterns);
    }
    /**
     * (experimental) Always include the specified file patterns.
     *
     * @param patterns Patterns to include in git commits.
     * @experimental
     */
    include(...patterns) {
        for (let pattern of patterns) {
            if (!pattern.startsWith('!')) {
                pattern = '!' + pattern;
            }
            this.addPatterns(pattern);
        }
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(resolver) {
        const lines = [
            `# ${file_1.FileBase.PROJEN_MARKER}`,
            ...this._patterns,
        ];
        return `${resolver.resolve(lines).join('\n')}\n`;
    }
}
exports.IgnoreFile = IgnoreFile;
_a = JSII_RTTI_SYMBOL_1;
IgnoreFile[_a] = { fqn: "projen.IgnoreFile", version: "0.29.3" };
// O(n) hooray!
function remove(arr, value) {
    const idx = arr.indexOf(value);
    if (idx >= 0) {
        arr.splice(idx, 1);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWdub3JlLWZpbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaWdub3JlLWZpbGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxpQ0FBNkM7Ozs7QUFJN0MsTUFBYSxVQUFXLFNBQVEsZUFBUTs7OztJQUd0QyxZQUFZLE9BQWdCLEVBQUUsUUFBZ0I7UUFDNUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsRUFBRSxhQUFhLEVBQUUsUUFBUSxLQUFLLFlBQVksRUFBRSxDQUFDLENBQUM7UUFIeEQsY0FBUyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7SUFJakQsQ0FBQzs7Ozs7Ozs7Ozs7OztJQUdNLFdBQVcsQ0FBQyxHQUFHLFFBQWtCO1FBQ3RDLEtBQUssTUFBTSxPQUFPLElBQUksUUFBUSxFQUFFO1lBQzlCLGdCQUFnQjtZQUNoQixJQUFJLE9BQU8sQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEVBQUU7Z0JBQzNCLFNBQVM7YUFDVjtZQUVELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUVoQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUM5QjtJQUNILENBQUM7SUFFTyxpQkFBaUIsQ0FBQyxPQUFlO1FBQ3ZDLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRyxPQUFPLENBQUM7UUFDNUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsT0FBTyxDQUFDLENBQUMsQ0FBQyxxQkFBcUI7UUFDdEQsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFFakMsSUFBSSxPQUFPLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ3pCLE1BQU0sTUFBTSxHQUFHLFFBQVEsQ0FBQztZQUN4QixLQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUU7Z0JBQ25DLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtvQkFDeEIsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQyxDQUFDLENBQUM7aUJBQzNCO2FBQ0Y7U0FDRjtJQUNILENBQUM7Ozs7Ozs7OztJQUdNLGNBQWMsQ0FBQyxHQUFHLFFBQWtCO1FBQ3pDLEtBQUssTUFBTSxDQUFDLElBQUksUUFBUSxFQUFFO1lBQ3hCLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQzNCO0lBQ0gsQ0FBQzs7Ozs7OztJQUdNLE9BQU8sQ0FBQyxHQUFHLFFBQWtCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7Ozs7SUFHTSxPQUFPLENBQUMsR0FBRyxRQUFrQjtRQUNsQyxLQUFLLElBQUksT0FBTyxJQUFJLFFBQVEsRUFBRTtZQUM1QixJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsRUFBRTtnQkFDNUIsT0FBTyxHQUFHLEdBQUcsR0FBRyxPQUFPLENBQUM7YUFDekI7WUFFRCxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1NBQzNCO0lBQ0gsQ0FBQzs7Ozs7O0lBRVMsaUJBQWlCLENBQUMsUUFBbUI7UUFDN0MsTUFBTSxLQUFLLEdBQUc7WUFDWixLQUFLLGVBQVEsQ0FBQyxhQUFhLEVBQUU7WUFDN0IsR0FBRyxJQUFJLENBQUMsU0FBUztTQUNsQixDQUFDO1FBRUYsT0FBTyxHQUFHLFFBQVEsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkQsQ0FBQzs7QUFsRUgsZ0NBbUVDOzs7QUFFRCxlQUFlO0FBQ2YsU0FBUyxNQUFNLENBQUksR0FBUSxFQUFFLEtBQVU7SUFDckMsTUFBTSxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMvQixJQUFJLEdBQUcsSUFBSSxDQUFDLEVBQUU7UUFDWixHQUFHLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQztLQUNwQjtBQUNILENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBGaWxlQmFzZSwgSVJlc29sdmVyIH0gZnJvbSAnLi9maWxlJztcbmltcG9ydCB7IFByb2plY3QgfSBmcm9tICcuL3Byb2plY3QnO1xuXG5cbmV4cG9ydCBjbGFzcyBJZ25vcmVGaWxlIGV4dGVuZHMgRmlsZUJhc2Uge1xuICBwcml2YXRlIHJlYWRvbmx5IF9wYXR0ZXJucyA9IG5ldyBBcnJheTxzdHJpbmc+KCk7XG5cbiAgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCwgZmlsZVBhdGg6IHN0cmluZykge1xuICAgIHN1cGVyKHByb2plY3QsIGZpbGVQYXRoLCB7IGVkaXRHaXRpZ25vcmU6IGZpbGVQYXRoICE9PSAnLmdpdGlnbm9yZScgfSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhZGRQYXR0ZXJucyguLi5wYXR0ZXJuczogc3RyaW5nW10pIHtcbiAgICBmb3IgKGNvbnN0IHBhdHRlcm4gb2YgcGF0dGVybnMpIHtcbiAgICAgIC8vIHNraXAgY29tbWVudHNcbiAgICAgIGlmIChwYXR0ZXJuLnN0YXJ0c1dpdGgoJyMnKSkge1xuICAgICAgICBjb250aW51ZTtcbiAgICAgIH1cblxuICAgICAgdGhpcy5ub3JtYWxpemVQYXR0ZXJucyhwYXR0ZXJuKTtcblxuICAgICAgdGhpcy5fcGF0dGVybnMucHVzaChwYXR0ZXJuKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIG5vcm1hbGl6ZVBhdHRlcm5zKHBhdHRlcm46IHN0cmluZykge1xuICAgIGNvbnN0IG9wcG9zaXRlID0gcGF0dGVybi5zdGFydHNXaXRoKCchJykgPyBwYXR0ZXJuLnNsaWNlKDEpIDogJyEnICsgcGF0dGVybjtcbiAgICByZW1vdmUodGhpcy5fcGF0dGVybnMsIHBhdHRlcm4pOyAvLyBwcmV2ZW50IGR1cGxpY2F0ZXNcbiAgICByZW1vdmUodGhpcy5fcGF0dGVybnMsIG9wcG9zaXRlKTtcblxuICAgIGlmIChwYXR0ZXJuLmVuZHNXaXRoKCcvJykpIHtcbiAgICAgIGNvbnN0IHByZWZpeCA9IG9wcG9zaXRlO1xuICAgICAgZm9yIChjb25zdCBwIG9mIFsuLi50aGlzLl9wYXR0ZXJuc10pIHtcbiAgICAgICAgaWYgKHAuc3RhcnRzV2l0aChwcmVmaXgpKSB7XG4gICAgICAgICAgcmVtb3ZlKHRoaXMuX3BhdHRlcm5zLCBwKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVtb3ZlUGF0dGVybnMoLi4ucGF0dGVybnM6IHN0cmluZ1tdKSB7XG4gICAgZm9yIChjb25zdCBwIG9mIHBhdHRlcm5zKSB7XG4gICAgICByZW1vdmUodGhpcy5fcGF0dGVybnMsIHApO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZXhjbHVkZSguLi5wYXR0ZXJuczogc3RyaW5nW10pIHtcbiAgICByZXR1cm4gdGhpcy5hZGRQYXR0ZXJucyguLi5wYXR0ZXJucyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBpbmNsdWRlKC4uLnBhdHRlcm5zOiBzdHJpbmdbXSkge1xuICAgIGZvciAobGV0IHBhdHRlcm4gb2YgcGF0dGVybnMpIHtcbiAgICAgIGlmICghcGF0dGVybi5zdGFydHNXaXRoKCchJykpIHtcbiAgICAgICAgcGF0dGVybiA9ICchJyArIHBhdHRlcm47XG4gICAgICB9XG5cbiAgICAgIHRoaXMuYWRkUGF0dGVybnMocGF0dGVybik7XG4gICAgfVxuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVDb250ZW50KHJlc29sdmVyOiBJUmVzb2x2ZXIpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICAgIGNvbnN0IGxpbmVzID0gW1xuICAgICAgYCMgJHtGaWxlQmFzZS5QUk9KRU5fTUFSS0VSfWAsXG4gICAgICAuLi50aGlzLl9wYXR0ZXJucyxcbiAgICBdO1xuXG4gICAgcmV0dXJuIGAke3Jlc29sdmVyLnJlc29sdmUobGluZXMpLmpvaW4oJ1xcbicpfVxcbmA7XG4gIH1cbn1cblxuLy8gTyhuKSBob29yYXkhXG5mdW5jdGlvbiByZW1vdmU8VD4oYXJyOiBUW10sIHZhbHVlOiBhbnkpIHtcbiAgY29uc3QgaWR4ID0gYXJyLmluZGV4T2YodmFsdWUpO1xuICBpZiAoaWR4ID49IDApIHtcbiAgICBhcnIuc3BsaWNlKGlkeCwgMSk7XG4gIH1cbn1cbiJdfQ==