"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Gitpod = exports.GitpodPortVisibility = exports.GitpodOnOpen = exports.GitpodOpenIn = exports.GitpodOpenMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const yaml_1 = require("./yaml");
/**
  * Relative path of Gitpod file to generate
  */
const GITPOD_FILE = '.gitpod.yml';
/**
 * (experimental) Configure how the terminal should be opened relative to the previous task.
 *
 * @experimental
 */
var GitpodOpenMode;
(function (GitpodOpenMode) {
    GitpodOpenMode["TAB_AFTER"] = "tab-after";
    GitpodOpenMode["TAB_BEFORE"] = "tab-before";
    GitpodOpenMode["SPLIT_RIGHT"] = "split-right";
    GitpodOpenMode["SPLIT_LEFT"] = "split-left";
    GitpodOpenMode["SPLIT_TOP"] = "split-top";
    GitpodOpenMode["SPLIT_BOTTOM"] = "split-bottom";
})(GitpodOpenMode = exports.GitpodOpenMode || (exports.GitpodOpenMode = {}));
/**
 * (experimental) Configure where in the IDE the terminal should be opened.
 *
 * @experimental
 */
var GitpodOpenIn;
(function (GitpodOpenIn) {
    GitpodOpenIn["BOTTOM"] = "bottom";
    GitpodOpenIn["LEFT"] = "left";
    GitpodOpenIn["RIGHT"] = "right";
    GitpodOpenIn["MAIN"] = "main";
})(GitpodOpenIn = exports.GitpodOpenIn || (exports.GitpodOpenIn = {}));
/**
 * (experimental) What to do when a service on a port is detected.
 *
 * @experimental
 */
var GitpodOnOpen;
(function (GitpodOnOpen) {
    GitpodOnOpen["OPEN_BROWSER"] = "open-browser";
    GitpodOnOpen["OPEN_PREVIEW"] = "open-preview";
    GitpodOnOpen["NOTIFY"] = "notify";
    GitpodOnOpen["IGNORE"] = "ignore";
})(GitpodOnOpen = exports.GitpodOnOpen || (exports.GitpodOnOpen = {}));
/**
 * (experimental) Whether the port visibility should be private or public.
 *
 * @experimental
 */
var GitpodPortVisibility;
(function (GitpodPortVisibility) {
    GitpodPortVisibility["PUBLIC"] = "public";
    GitpodPortVisibility["PRIVATE"] = "private";
})(GitpodPortVisibility = exports.GitpodPortVisibility || (exports.GitpodPortVisibility = {}));
/**
 * (experimental) The Gitpod component which emits .gitpod.yml.
 *
 * @experimental
 */
class Gitpod extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        this.tasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.dockerImage = options === null || options === void 0 ? void 0 : options.dockerImage;
        if (options === null || options === void 0 ? void 0 : options.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options === null || options === void 0 ? void 0 : options.prebuilds) {
            this.addPrebuilds(options.prebuilds);
        }
        if (options === null || options === void 0 ? void 0 : options.ports) {
            this.addPorts(...options.ports);
        }
        if (options === null || options === void 0 ? void 0 : options.vscodeExtensions) {
            this.addVscodeExtensions(...options.vscodeExtensions);
        }
        this.config = {
            image: () => this.renderDockerImage(),
            tasks: this.tasks,
            github: () => this.renderPrebuilds(),
            ports: this.ports,
            vscode: {
                extensions: this.vscodeExtensions,
            },
        };
        new yaml_1.YamlFile(this.project, GITPOD_FILE, { obj: this.config, omitEmpty: true });
    }
    /**
     * (experimental) Add a custom Docker image or Dockerfile for the container.
     *
     * @param image The Docker image.
     * @experimental
     */
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error('dockerImage cannot be redefined.');
        }
        this.dockerImage = image;
    }
    /**
     * (experimental) Add tasks to run when gitpod starts.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and specify the other tasks as subtasks.
     *
     * @param tasks The new tasks.
     * @experimental
     */
    addTasks(...tasks) {
        this.tasks.push(...tasks.map(task => ({
            name: task.name,
            command: `npx projen ${task.name}`,
        })));
    }
    /**
     * (experimental) Add a prebuilds configuration for the Gitpod App.
     *
     * @param config The configuration.
     * @experimental
     */
    addPrebuilds(config) {
        this.prebuilds = config;
    }
    /**
     * (experimental) Add a task with more granular options.
     *
     * By default, all tasks will be run in parallel. To run tasks in sequence,
     * create a new `Task` and set the other tasks as subtasks.
     *
     * @param options The task parameters.
     * @experimental
     */
    addCustomTask(options) {
        this.tasks.push({
            name: options.name,
            command: options.command,
            openMode: options.openMode,
            openIn: options.openIn,
            before: options.before,
            init: options.init,
            prebuild: options.prebuild,
        });
    }
    /**
     * (experimental) Add ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports.
     * @experimental
     */
    addPorts(...ports) {
        this.ports.push(...ports.map(port => ({ port: port })));
    }
    /**
     * (experimental) Add a list of VSCode extensions that should be automatically installed in the container.
     *
     * These must be in the format defined in the Open VSX registry.
     *
     * @param extensions The extension IDs.
     * @see https://www.gitpod.io/docs/vscode-extensions/
     * @experimental
     * @example
     *
     * 'scala-lang.scala@0.3.9:O5XmjwY5Gz+0oDZAmqneJw=='
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    renderDockerImage() {
        var _b, _c;
        if ((_b = this.dockerImage) === null || _b === void 0 ? void 0 : _b.image) {
            return this.dockerImage.image;
        }
        else if ((_c = this.dockerImage) === null || _c === void 0 ? void 0 : _c.dockerFile) {
            return {
                file: this.dockerImage.dockerFile,
            };
        }
        else {
            return undefined;
        }
    }
    renderPrebuilds() {
        if (this.prebuilds) {
            return {
                prebuilds: this.prebuilds,
            };
        }
        else {
            return undefined;
        }
    }
}
exports.Gitpod = Gitpod;
_a = JSII_RTTI_SYMBOL_1;
Gitpod[_a] = { fqn: "projen.Gitpod", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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