import { Component } from '../component';
import { YamlFile } from '../yaml';
import { GitHub } from './github';
import * as workflows from './workflows-model';
/**
 * (experimental) Options for `GithubWorkflow`.
 *
 * @experimental
 */
export interface GithubWorkflowOptions {
    /**
     * (experimental) Force the creation of the workflow even if `workflows` is disabled in `GitHub`.
     *
     * @default false
     * @experimental
     */
    readonly force?: boolean;
    /**
     * (experimental) Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time.
     *
     * Currently in beta.
     *
     * @default - disabled
     * @see https://docs.github.com/en/actions/learn-github-actions/workflow-syntax-for-github-actions#concurrency
     * @experimental
     */
    readonly concurrency?: string;
}
/**
 * (experimental) Workflow for GitHub.
 *
 * A workflow is a configurable automated process made up of one or more jobs.
 *
 * @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
 * @experimental
 */
export declare class GithubWorkflow extends Component {
    /**
     * (experimental) The name of the workflow.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time.
     *
     * @default disabled
     * @experimental
     */
    readonly concurrency?: string;
    /**
     * (experimental) The workflow YAML file.
     *
     * @experimental
     */
    readonly file: YamlFile | undefined;
    private events;
    private jobs;
    /**
     * @experimental
     */
    constructor(github: GitHub, name: string, options?: GithubWorkflowOptions);
    /**
     * (experimental) Add events to triggers the workflow.
     *
     * @param events The event(s) to trigger the workflow.
     * @experimental
     */
    on(events: workflows.Triggers): void;
    /**
     * (experimental) Add jobs to the workflow.
     *
     * @param jobs Jobs to add.
     * @experimental
     */
    addJobs(jobs: Record<string, workflows.Job>): void;
    private renderWorkflow;
}
