"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflows_1 = require("./workflows");
const DEFAULT_JOB_ID = 'build';
const UBUNTU_LATEST = 'ubuntu-latest';
/**
 * (experimental) A GitHub workflow for common build tasks within a project.
 *
 * @experimental
 */
class TaskWorkflow extends workflows_1.GithubWorkflow {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c, _d, _e;
        super(github, options.name);
        this.jobId = (_b = options.jobId) !== null && _b !== void 0 ? _b : DEFAULT_JOB_ID;
        this.github = github;
        if (options.triggers) {
            if (options.triggers.issueComment) {
                // https://docs.github.com/en/actions/learn-github-actions/security-hardening-for-github-actions#potential-impact-of-a-compromised-runner
                throw new Error('Trigger "issueComment" should not be used due to a security concern');
            }
            this.on(options.triggers);
        }
        this.on({
            workflowDispatch: {},
        });
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const preBuildSteps = (_d = options.preBuildSteps) !== null && _d !== void 0 ? _d : [];
        const postBuildSteps = (_e = options.postBuildSteps) !== null && _e !== void 0 ? _e : [];
        if (options.artifactsDirectory) {
            postBuildSteps.push({
                name: 'Upload artifact',
                uses: 'actions/upload-artifact@v2.1.1',
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: 'always()',
                with: {
                    name: options.artifactsDirectory,
                    path: options.artifactsDirectory,
                },
            });
        }
        const job = {
            runsOn: UBUNTU_LATEST,
            container: options.container,
            env: options.env,
            permissions: options.permissions,
            if: options.condition,
            outputs: options.outputs,
            steps: [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // sets git identity so we can push later
                constants_1.SET_GIT_IDENTITY_WORKFLOW_STEP,
                ...preBuildSteps,
                // run the main build task
                {
                    name: options.task.name,
                    run: this.github.project.runTaskCommand(options.task),
                },
                ...postBuildSteps,
            ],
        };
        this.addJobs({ [this.jobId]: job });
    }
}
exports.TaskWorkflow = TaskWorkflow;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflow[_a] = { fqn: "projen.github.TaskWorkflow", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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