"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stale = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const stale_util_1 = require("./stale-util");
const workflows_model_1 = require("./workflows-model");
/**
 * (experimental) Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 *
 * The default configuration will:
 *
 *   * Add a "Stale" label to pull requests after 14 days and closed after 2 days
 *   * Add a "Stale" label to issues after 60 days and closed after 7 days
 *   * If a comment is added, the label will be removed and timer is restarted.
 *
 * @see https://github.com/actions/stale
 * @experimental
 */
class Stale extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        super(github.project);
        const stale = github.addWorkflow('stale');
        stale.on({
            schedule: [{ cron: '0 1 * * *' }],
            workflowDispatch: {},
        });
        const pullRequests = stale_util_1.renderBehavior(options.pullRequest, { stale: 14, close: 2, type: 'pull request' });
        const issues = stale_util_1.renderBehavior(options.issues, { stale: 60, close: 7, type: 'issue' });
        stale.addJobs({
            stale: {
                runsOn: 'ubuntu-latest',
                permissions: {
                    issues: workflows_model_1.JobPermission.WRITE,
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: 'actions/stale@v4',
                        with: {
                            // disable global
                            'days-before-stale': -1,
                            'days-before-close': -1,
                            // pull requests
                            'days-before-pr-stale': pullRequests.daysBeforeStale,
                            'days-before-pr-close': pullRequests.daysBeforeClose,
                            'stale-pr-message': pullRequests.staleMessage,
                            'close-pr-message': pullRequests.closeMessage,
                            'stale-pr-label': pullRequests.staleLabel,
                            // issues
                            'days-before-issue-stale': issues.daysBeforeStale,
                            'days-before-issue-close': issues.daysBeforeClose,
                            'stale-issue-message': issues.staleMessage,
                            'close-issue-message': issues.closeMessage,
                            'stale-issue-label': issues.staleLabel,
                        },
                    },
                ],
            },
        });
    }
}
exports.Stale = Stale;
_a = JSII_RTTI_SYMBOL_1;
Stale[_a] = { fqn: "projen.github.Stale", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ2l0aHViL3N0YWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNENBQXlDO0FBRXpDLDZDQUE4QztBQUM5Qyx1REFBa0Q7Ozs7Ozs7Ozs7Ozs7QUFpQ2xELE1BQWEsS0FBTSxTQUFRLHFCQUFTOzs7O0lBQ2xDLFlBQVksTUFBYyxFQUFFLFVBQXdCLEVBQUU7UUFDcEQsS0FBSyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUV0QixNQUFNLEtBQUssR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzFDLEtBQUssQ0FBQyxFQUFFLENBQUM7WUFDUCxRQUFRLEVBQUUsQ0FBQyxFQUFFLElBQUksRUFBRSxXQUFXLEVBQUUsQ0FBQztZQUNqQyxnQkFBZ0IsRUFBRSxFQUFFO1NBQ3JCLENBQUMsQ0FBQztRQUVILE1BQU0sWUFBWSxHQUFHLDJCQUFjLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxFQUFFLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQztRQUN4RyxNQUFNLE1BQU0sR0FBRywyQkFBYyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsRUFBRSxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssRUFBRSxDQUFDLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFFdEYsS0FBSyxDQUFDLE9BQU8sQ0FBQztZQUNaLEtBQUssRUFBRTtnQkFDTCxNQUFNLEVBQUUsZUFBZTtnQkFDdkIsV0FBVyxFQUFFO29CQUNYLE1BQU0sRUFBRSwrQkFBYSxDQUFDLEtBQUs7b0JBQzNCLFlBQVksRUFBRSwrQkFBYSxDQUFDLEtBQUs7aUJBQ2xDO2dCQUNELEtBQUssRUFBRTtvQkFDTDt3QkFDRSxJQUFJLEVBQUUsa0JBQWtCO3dCQUN4QixJQUFJLEVBQUU7NEJBQ0osaUJBQWlCOzRCQUNqQixtQkFBbUIsRUFBRSxDQUFDLENBQUM7NEJBQ3ZCLG1CQUFtQixFQUFFLENBQUMsQ0FBQzs0QkFFdkIsZ0JBQWdCOzRCQUNoQixzQkFBc0IsRUFBRSxZQUFZLENBQUMsZUFBZTs0QkFDcEQsc0JBQXNCLEVBQUUsWUFBWSxDQUFDLGVBQWU7NEJBQ3BELGtCQUFrQixFQUFFLFlBQVksQ0FBQyxZQUFZOzRCQUM3QyxrQkFBa0IsRUFBRSxZQUFZLENBQUMsWUFBWTs0QkFDN0MsZ0JBQWdCLEVBQUUsWUFBWSxDQUFDLFVBQVU7NEJBRXpDLFNBQVM7NEJBQ1QseUJBQXlCLEVBQUUsTUFBTSxDQUFDLGVBQWU7NEJBQ2pELHlCQUF5QixFQUFFLE1BQU0sQ0FBQyxlQUFlOzRCQUNqRCxxQkFBcUIsRUFBRSxNQUFNLENBQUMsWUFBWTs0QkFDMUMscUJBQXFCLEVBQUUsTUFBTSxDQUFDLFlBQVk7NEJBQzFDLG1CQUFtQixFQUFFLE1BQU0sQ0FBQyxVQUFVO3lCQUN2QztxQkFDRjtpQkFDRjthQUNGO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUE5Q0gsc0JBK0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSAnLi4vY29tcG9uZW50JztcbmltcG9ydCB7IEdpdEh1YiB9IGZyb20gJy4vZ2l0aHViJztcbmltcG9ydCB7IHJlbmRlckJlaGF2aW9yIH0gZnJvbSAnLi9zdGFsZS11dGlsJztcbmltcG9ydCB7IEpvYlBlcm1pc3Npb24gfSBmcm9tICcuL3dvcmtmbG93cy1tb2RlbCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU3RhbGVPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwdWxsUmVxdWVzdD86IFN0YWxlQmVoYXZpb3I7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGlzc3Vlcz86IFN0YWxlQmVoYXZpb3I7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFN0YWxlQmVoYXZpb3Ige1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRheXNCZWZvcmVTdGFsZT86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGF5c0JlZm9yZUNsb3NlPzogbnVtYmVyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdGFsZU1lc3NhZ2U/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjbG9zZU1lc3NhZ2U/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdGFsZUxhYmVsPzogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU3RhbGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBjb25zdHJ1Y3RvcihnaXRodWI6IEdpdEh1Yiwgb3B0aW9uczogU3RhbGVPcHRpb25zID0ge30pIHtcbiAgICBzdXBlcihnaXRodWIucHJvamVjdCk7XG5cbiAgICBjb25zdCBzdGFsZSA9IGdpdGh1Yi5hZGRXb3JrZmxvdygnc3RhbGUnKTtcbiAgICBzdGFsZS5vbih7XG4gICAgICBzY2hlZHVsZTogW3sgY3JvbjogJzAgMSAqICogKicgfV0sIC8vIGF0IDFhbSBldmVyeSBkYXlcbiAgICAgIHdvcmtmbG93RGlzcGF0Y2g6IHt9LFxuICAgIH0pO1xuXG4gICAgY29uc3QgcHVsbFJlcXVlc3RzID0gcmVuZGVyQmVoYXZpb3Iob3B0aW9ucy5wdWxsUmVxdWVzdCwgeyBzdGFsZTogMTQsIGNsb3NlOiAyLCB0eXBlOiAncHVsbCByZXF1ZXN0JyB9KTtcbiAgICBjb25zdCBpc3N1ZXMgPSByZW5kZXJCZWhhdmlvcihvcHRpb25zLmlzc3VlcywgeyBzdGFsZTogNjAsIGNsb3NlOiA3LCB0eXBlOiAnaXNzdWUnIH0pO1xuXG4gICAgc3RhbGUuYWRkSm9icyh7XG4gICAgICBzdGFsZToge1xuICAgICAgICBydW5zT246ICd1YnVudHUtbGF0ZXN0JyxcbiAgICAgICAgcGVybWlzc2lvbnM6IHtcbiAgICAgICAgICBpc3N1ZXM6IEpvYlBlcm1pc3Npb24uV1JJVEUsXG4gICAgICAgICAgcHVsbFJlcXVlc3RzOiBKb2JQZXJtaXNzaW9uLldSSVRFLFxuICAgICAgICB9LFxuICAgICAgICBzdGVwczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIHVzZXM6ICdhY3Rpb25zL3N0YWxlQHY0JyxcbiAgICAgICAgICAgIHdpdGg6IHtcbiAgICAgICAgICAgICAgLy8gZGlzYWJsZSBnbG9iYWxcbiAgICAgICAgICAgICAgJ2RheXMtYmVmb3JlLXN0YWxlJzogLTEsXG4gICAgICAgICAgICAgICdkYXlzLWJlZm9yZS1jbG9zZSc6IC0xLFxuXG4gICAgICAgICAgICAgIC8vIHB1bGwgcmVxdWVzdHNcbiAgICAgICAgICAgICAgJ2RheXMtYmVmb3JlLXByLXN0YWxlJzogcHVsbFJlcXVlc3RzLmRheXNCZWZvcmVTdGFsZSxcbiAgICAgICAgICAgICAgJ2RheXMtYmVmb3JlLXByLWNsb3NlJzogcHVsbFJlcXVlc3RzLmRheXNCZWZvcmVDbG9zZSxcbiAgICAgICAgICAgICAgJ3N0YWxlLXByLW1lc3NhZ2UnOiBwdWxsUmVxdWVzdHMuc3RhbGVNZXNzYWdlLFxuICAgICAgICAgICAgICAnY2xvc2UtcHItbWVzc2FnZSc6IHB1bGxSZXF1ZXN0cy5jbG9zZU1lc3NhZ2UsXG4gICAgICAgICAgICAgICdzdGFsZS1wci1sYWJlbCc6IHB1bGxSZXF1ZXN0cy5zdGFsZUxhYmVsLFxuXG4gICAgICAgICAgICAgIC8vIGlzc3Vlc1xuICAgICAgICAgICAgICAnZGF5cy1iZWZvcmUtaXNzdWUtc3RhbGUnOiBpc3N1ZXMuZGF5c0JlZm9yZVN0YWxlLFxuICAgICAgICAgICAgICAnZGF5cy1iZWZvcmUtaXNzdWUtY2xvc2UnOiBpc3N1ZXMuZGF5c0JlZm9yZUNsb3NlLFxuICAgICAgICAgICAgICAnc3RhbGUtaXNzdWUtbWVzc2FnZSc6IGlzc3Vlcy5zdGFsZU1lc3NhZ2UsXG4gICAgICAgICAgICAgICdjbG9zZS1pc3N1ZS1tZXNzYWdlJzogaXNzdWVzLmNsb3NlTWVzc2FnZSxcbiAgICAgICAgICAgICAgJ3N0YWxlLWlzc3VlLWxhYmVsJzogaXNzdWVzLnN0YWxlTGFiZWwsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=