"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBehavior = void 0;
function renderBehavior(behavior, opts) {
    var _a, _b, _c, _d, _e, _f;
    const enabled = (_a = behavior === null || behavior === void 0 ? void 0 : behavior.enabled) !== null && _a !== void 0 ? _a : true;
    if (!enabled) {
        return { daysBeforeStale: -1, daysBeforeClose: -1 };
    }
    return {
        daysBeforeStale: (_b = behavior === null || behavior === void 0 ? void 0 : behavior.daysBeforeStale) !== null && _b !== void 0 ? _b : opts.stale,
        daysBeforeClose: (_c = behavior === null || behavior === void 0 ? void 0 : behavior.daysBeforeClose) !== null && _c !== void 0 ? _c : opts.close,
        staleMessage: (_d = behavior === null || behavior === void 0 ? void 0 : behavior.staleMessage) !== null && _d !== void 0 ? _d : `This ${opts.type} is now marked as stale because it hasn\'t seen activity for a while. Add a comment or it will be closed soon.`,
        closeMessage: (_e = behavior === null || behavior === void 0 ? void 0 : behavior.closeMessage) !== null && _e !== void 0 ? _e : `Closing this ${opts.type} as it hasn\'t seen activity for a while. Please add a comment @mentioning a maintainer to reopen.`,
        staleLabel: (_f = behavior === null || behavior === void 0 ? void 0 : behavior.staleLabel) !== null && _f !== void 0 ? _f : 'stale',
    };
}
exports.renderBehavior = renderBehavior;
;
//# sourceMappingURL=data:application/json;base64,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