"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependabot_1 = require("./dependabot");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const workflows_1 = require("./workflows");
/**
 * @experimental
 */
class GitHub extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c;
        super(project);
        this.workflowsEnabled = (_b = options.workflows) !== null && _b !== void 0 ? _b : true;
        this._workflows = {};
        if ((_c = options.mergify) !== null && _c !== void 0 ? _c : true) {
            this.mergify = new mergify_1.Mergify(this);
        }
    }
    /**
     * (experimental) All workflows.
     *
     * @experimental
     */
    get workflows() {
        return Object.values(this._workflows);
    }
    /**
     * (experimental) Adds a workflow to the project.
     *
     * @param name Name of the workflow.
     * @returns a GithubWorkflow instance
     * @experimental
     */
    addWorkflow(name) {
        if (this._workflows[name]) {
            throw new Error(`A workflow with the name ${name} already exists.`);
        }
        const workflow = new workflows_1.GithubWorkflow(this, name);
        this._workflows[name] = workflow;
        return workflow;
    }
    /**
     * @experimental
     */
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    /**
     * @experimental
     */
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * (experimental) Finds a GitHub workflow by name.
     *
     * Returns `undefined` if the workflow cannot be found.
     *
     * @param name The name of the GitHub workflow.
     * @experimental
     */
    tryFindWorkflow(name) {
        return this._workflows[name];
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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