import { Component } from '../component';
import { Project } from '../project';
import { Dependabot, DependabotOptions } from './dependabot';
import { Mergify } from './mergify';
import { PullRequestTemplate } from './pr-template';
import { GithubWorkflow } from './workflows';
/**
 * @experimental
 */
export interface GitHubOptions {
    /**
     * (experimental) Whether mergify should be enabled on this repository or not.
     *
     * @default true
     * @experimental
     */
    readonly mergify?: boolean;
    /**
     * (experimental) Enables GitHub workflows.
     *
     * If this is set to `false`, workflows will not be created.
     *
     * @default true
     * @experimental
     */
    readonly workflows?: boolean;
}
/**
 * @experimental
 */
export declare class GitHub extends Component {
    /**
     * (experimental) The `Mergify` configured on this repository.
     *
     * This is `undefined` if Mergify
     * was not enabled when creating the repository.
     *
     * @experimental
     */
    readonly mergify?: Mergify;
    /**
     * (experimental) Are workflows enabled?
     *
     * @experimental
     */
    readonly workflowsEnabled: boolean;
    private readonly _workflows;
    /**
     * @experimental
     */
    constructor(project: Project, options?: GitHubOptions);
    /**
     * (experimental) All workflows.
     *
     * @experimental
     */
    get workflows(): GithubWorkflow[];
    /**
     * (experimental) Adds a workflow to the project.
     *
     * @param name Name of the workflow.
     * @returns a GithubWorkflow instance
     * @experimental
     */
    addWorkflow(name: string): GithubWorkflow;
    /**
     * @experimental
     */
    addPullRequestTemplate(...content: string[]): PullRequestTemplate;
    /**
     * @experimental
     */
    addDependabot(options?: DependabotOptions): Dependabot;
    /**
     * (experimental) Finds a GitHub workflow by name.
     *
     * Returns `undefined` if the workflow cannot be found.
     *
     * @param name The name of the GitHub workflow.
     * @experimental
     */
    tryFindWorkflow(name: string): undefined | GithubWorkflow;
}
