"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependabot = exports.VersioningStrategy = exports.DependabotScheduleInterval = exports.DependabotRegistryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const yargs_1 = require("yargs");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
/**
 * (experimental) Each configuration type requires you to provide particular settings.
 *
 * Some types allow more than one way to connect
 *
 * @see https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates#configuration-options-for-private-registries
 * @experimental
 */
var DependabotRegistryType;
(function (DependabotRegistryType) {
    DependabotRegistryType["COMPOSER_REGISTRY"] = "composer-registry";
    DependabotRegistryType["DOCKER_REGISTRY"] = "docker-registry";
    DependabotRegistryType["GIT"] = "git";
    DependabotRegistryType["HEX_ORGANIZATION"] = "hex-organization";
    DependabotRegistryType["MAVEN_REPOSITORY"] = "maven-repository";
    DependabotRegistryType["NPM_REGISTRY"] = "npm-registry";
    DependabotRegistryType["NUGET_FEED"] = "nuget-feed";
    DependabotRegistryType["PYTHON_INDEX"] = "python-index";
    DependabotRegistryType["RUBYGEMS_SERVER"] = "rubygems-server";
    DependabotRegistryType["TERRAFORM_REGISTRY"] = "terraform-registry";
})(DependabotRegistryType = exports.DependabotRegistryType || (exports.DependabotRegistryType = {}));
/**
 * (experimental) How often to check for new versions and raise pull requests for version updates.
 *
 * @experimental
 */
var DependabotScheduleInterval;
(function (DependabotScheduleInterval) {
    DependabotScheduleInterval["DAILY"] = "daily";
    DependabotScheduleInterval["WEEKLY"] = "weekly";
    DependabotScheduleInterval["MONTHLY"] = "monthly";
})(DependabotScheduleInterval = exports.DependabotScheduleInterval || (exports.DependabotScheduleInterval = {}));
/**
 * (experimental) The strategy to use when edits manifest and lock files.
 *
 * @experimental
 */
var VersioningStrategy;
(function (VersioningStrategy) {
    VersioningStrategy["LOCKFILE_ONLY"] = "lockfile-only";
    VersioningStrategy["AUTO"] = "auto";
    VersioningStrategy["WIDEN"] = "widen";
    VersioningStrategy["INCREASE"] = "increase";
    VersioningStrategy["INCREASE_IF_NECESSARY"] = "increase-if-necessary";
})(VersioningStrategy = exports.VersioningStrategy || (exports.VersioningStrategy = {}));
/**
 * (experimental) Defines dependabot configuration for node projects.
 *
 * Since module versions are managed in projen, the versioning strategy will be
 * configured to "lockfile-only" which means that only updates that can be done
 * on the lockfile itself will be proposed.
 *
 * @experimental
 */
class Dependabot extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e;
        super(github.project);
        const project = github.project;
        this.ignore = [];
        this.ignoresProjen = (_b = options.ignoreProjen) !== null && _b !== void 0 ? _b : true;
        const registries = options.registries ? util_1.kebabCaseKeys(options.registries) : undefined;
        this.config = {
            version: 2,
            registries,
            updates: [
                {
                    'package-ecosystem': 'npm',
                    'versioning-strategy': 'lockfile-only',
                    'directory': '/',
                    'schedule': {
                        interval: (_c = options.scheduleInterval) !== null && _c !== void 0 ? _c : DependabotScheduleInterval.DAILY,
                    },
                    'ignore': () => this.ignore.length > 0 ? this.ignore : undefined,
                    'labels': options.labels ? options.labels : undefined,
                    'registries': registries ? Object.keys(registries) : undefined,
                },
            ],
        };
        new yaml_1.YamlFile(project, '.github/dependabot.yml', {
            obj: this.config,
            committed: true,
        });
        for (const i of (_d = options.ignore) !== null && _d !== void 0 ? _d : []) {
            this.addIgnore(i.dependencyName, ...((_e = i.versions) !== null && _e !== void 0 ? _e : []));
        }
        if (this.ignoresProjen) {
            this.addIgnore('projen');
        }
    }
    /**
     * (experimental) Ignores a dependency from automatic updates.
     *
     * @param dependencyName Use to ignore updates for dependencies with matching names, optionally using `*` to match zero or more characters.
     * @param versions Use to ignore specific versions or ranges of versions.
     * @experimental
     */
    addIgnore(dependencyName, ...versions) {
        this.ignore.push({
            'dependency-name': dependencyName,
            'versions': () => versions.length > 0 ? yargs_1.version : undefined,
        });
    }
}
exports.Dependabot = Dependabot;
_a = JSII_RTTI_SYMBOL_1;
Dependabot[_a] = { fqn: "projen.github.Dependabot", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwZW5kYWJvdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9naXRodWIvZGVwZW5kYWJvdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUFnQztBQUNoQyw0Q0FBeUM7QUFDekMsa0NBQXdDO0FBQ3hDLGtDQUFtQzs7Ozs7Ozs7O0FBbURuQyxJQUFZLHNCQThCWDtBQTlCRCxXQUFZLHNCQUFzQjtJQUVoQyxpRUFBdUMsQ0FBQTtJQUd2Qyw2REFBbUMsQ0FBQTtJQUduQyxxQ0FBVyxDQUFBO0lBR1gsK0RBQXFDLENBQUE7SUFHckMsK0RBQXFDLENBQUE7SUFHckMsdURBQTZCLENBQUE7SUFHN0IsbURBQXlCLENBQUE7SUFHekIsdURBQTZCLENBQUE7SUFHN0IsNkRBQW1DLENBQUE7SUFHbkMsbUVBQXlDLENBQUE7QUFDM0MsQ0FBQyxFQTlCVyxzQkFBc0IsR0FBdEIsOEJBQXNCLEtBQXRCLDhCQUFzQixRQThCakM7Ozs7OztBQVlELElBQVksMEJBU1g7QUFURCxXQUFZLDBCQUEwQjtJQUVwQyw2Q0FBZSxDQUFBO0lBR2YsK0NBQWlCLENBQUE7SUFHakIsaURBQW1CLENBQUE7QUFDckIsQ0FBQyxFQVRXLDBCQUEwQixHQUExQixrQ0FBMEIsS0FBMUIsa0NBQTBCLFFBU3JDOzs7Ozs7QUFHRCxJQUFZLGtCQWVYO0FBZkQsV0FBWSxrQkFBa0I7SUFFNUIscURBQStCLENBQUE7SUFHL0IsbUNBQWEsQ0FBQTtJQUdiLHFDQUFlLENBQUE7SUFHZiwyQ0FBcUIsQ0FBQTtJQUdyQixxRUFBK0MsQ0FBQTtBQUNqRCxDQUFDLEVBZlcsa0JBQWtCLEdBQWxCLDBCQUFrQixLQUFsQiwwQkFBa0IsUUFlN0I7Ozs7Ozs7Ozs7QUFHRCxNQUFhLFVBQVcsU0FBUSxxQkFBUzs7OztJQVN2QyxZQUFZLE1BQWMsRUFBRSxVQUE2QixFQUFFOztRQUN6RCxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRXRCLE1BQU0sT0FBTyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFFL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxFQUFFLENBQUM7UUFDakIsSUFBSSxDQUFDLGFBQWEsU0FBRyxPQUFPLENBQUMsWUFBWSxtQ0FBSSxJQUFJLENBQUM7UUFFbEQsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsb0JBQWEsQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUV0RixJQUFJLENBQUMsTUFBTSxHQUFHO1lBQ1osT0FBTyxFQUFFLENBQUM7WUFDVixVQUFVO1lBQ1YsT0FBTyxFQUFFO2dCQUNQO29CQUNFLG1CQUFtQixFQUFFLEtBQUs7b0JBQzFCLHFCQUFxQixFQUFFLGVBQWU7b0JBQ3RDLFdBQVcsRUFBRSxHQUFHO29CQUNoQixVQUFVLEVBQUU7d0JBQ1YsUUFBUSxRQUFFLE9BQU8sQ0FBQyxnQkFBZ0IsbUNBQUksMEJBQTBCLENBQUMsS0FBSztxQkFDdkU7b0JBQ0QsUUFBUSxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsU0FBUztvQkFDaEUsUUFBUSxFQUFFLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLFNBQVM7b0JBQ3JELFlBQVksRUFBRSxVQUFVLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVM7aUJBQy9EO2FBQ0Y7U0FDRixDQUFDO1FBRUYsSUFBSSxlQUFRLENBQUMsT0FBTyxFQUFFLHdCQUF3QixFQUFFO1lBQzlDLEdBQUcsRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNoQixTQUFTLEVBQUUsSUFBSTtTQUNoQixDQUFDLENBQUM7UUFFSCxLQUFLLE1BQU0sQ0FBQyxVQUFJLE9BQU8sQ0FBQyxNQUFNLG1DQUFJLEVBQUUsRUFBRTtZQUNwQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxjQUFjLEVBQUUsR0FBRyxPQUFDLENBQUMsQ0FBQyxRQUFRLG1DQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7U0FDekQ7UUFFRCxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDdEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUMxQjtJQUNILENBQUM7Ozs7Ozs7O0lBR00sU0FBUyxDQUFDLGNBQXNCLEVBQUUsR0FBRyxRQUFrQjtRQUM1RCxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQztZQUNmLGlCQUFpQixFQUFFLGNBQWM7WUFDakMsVUFBVSxFQUFFLEdBQUcsRUFBRSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxlQUFPLENBQUMsQ0FBQyxDQUFDLFNBQVM7U0FDNUQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF6REgsZ0NBMERDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgdmVyc2lvbiB9IGZyb20gJ3lhcmdzJztcbmltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gJy4uL2NvbXBvbmVudCc7XG5pbXBvcnQgeyBrZWJhYkNhc2VLZXlzIH0gZnJvbSAnLi4vdXRpbCc7XG5pbXBvcnQgeyBZYW1sRmlsZSB9IGZyb20gJy4uL3lhbWwnO1xuaW1wb3J0IHsgR2l0SHViIH0gZnJvbSAnLi9naXRodWInO1xuXG5leHBvcnQgaW50ZXJmYWNlIERlcGVuZGFib3RPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNjaGVkdWxlSW50ZXJ2YWw/OiBEZXBlbmRhYm90U2NoZWR1bGVJbnRlcnZhbDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2ZXJzaW9uaW5nU3RyYXRlZ3k/OiBWZXJzaW9uaW5nU3RyYXRlZ3k7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpZ25vcmU/OiBEZXBlbmRhYm90SWdub3JlW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGlnbm9yZVByb2plbj86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbGFiZWxzPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpc3RyaWVzPzogeyBbbmFtZTogc3RyaW5nXTogRGVwZW5kYWJvdFJlZ2lzdHJ5IH07XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBEZXBlbmRhYm90UmVnaXN0cnkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHlwZTogRGVwZW5kYWJvdFJlZ2lzdHJ5VHlwZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB1cmw6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB1c2VybmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcGFzc3dvcmQ/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0b2tlbj86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXBsYWNlc0Jhc2U/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBvcmdhbml6YXRpb24/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIERlcGVuZGFib3RSZWdpc3RyeVR5cGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQ09NUE9TRVJfUkVHSVNUUlkgPSAnY29tcG9zZXItcmVnaXN0cnknLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIERPQ0tFUl9SRUdJU1RSWSA9ICdkb2NrZXItcmVnaXN0cnknLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBHSVQgPSAnZ2l0JyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEhFWF9PUkdBTklaQVRJT04gPSAnaGV4LW9yZ2FuaXphdGlvbicsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIE1BVkVOX1JFUE9TSVRPUlkgPSAnbWF2ZW4tcmVwb3NpdG9yeScsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBOUE1fUkVHSVNUUlkgPSAnbnBtLXJlZ2lzdHJ5JyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgTlVHRVRfRkVFRCA9ICdudWdldC1mZWVkJyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFBZVEhPTl9JTkRFWCA9ICdweXRob24taW5kZXgnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgUlVCWUdFTVNfU0VSVkVSID0gJ3J1YnlnZW1zLXNlcnZlcicsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBURVJSQUZPUk1fUkVHSVNUUlkgPSAndGVycmFmb3JtLXJlZ2lzdHJ5J1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBEZXBlbmRhYm90SWdub3JlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVwZW5kZW5jeU5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZlcnNpb25zPzogc3RyaW5nW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBlbnVtIERlcGVuZGFib3RTY2hlZHVsZUludGVydmFsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBEQUlMWSA9ICdkYWlseScsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFdFRUtMWSA9ICd3ZWVrbHknLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBNT05USExZID0gJ21vbnRobHknXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gVmVyc2lvbmluZ1N0cmF0ZWd5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgTE9DS0ZJTEVfT05MWSA9ICdsb2NrZmlsZS1vbmx5JyxcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBBVVRPID0gJ2F1dG8nLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBXSURFTiA9ICd3aWRlbicsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgSU5DUkVBU0UgPSAnaW5jcmVhc2UnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIElOQ1JFQVNFX0lGX05FQ0VTU0FSWSA9ICdpbmNyZWFzZS1pZi1uZWNlc3NhcnknLFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIERlcGVuZGFib3QgZXh0ZW5kcyBDb21wb25lbnQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY29uZmlnOiBhbnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBpZ25vcmVzUHJvamVuOiBib29sZWFuO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgaWdub3JlOiBhbnlbXTtcblxuICBjb25zdHJ1Y3RvcihnaXRodWI6IEdpdEh1Yiwgb3B0aW9uczogRGVwZW5kYWJvdE9wdGlvbnMgPSB7fSkge1xuICAgIHN1cGVyKGdpdGh1Yi5wcm9qZWN0KTtcblxuICAgIGNvbnN0IHByb2plY3QgPSBnaXRodWIucHJvamVjdDtcblxuICAgIHRoaXMuaWdub3JlID0gW107XG4gICAgdGhpcy5pZ25vcmVzUHJvamVuID0gb3B0aW9ucy5pZ25vcmVQcm9qZW4gPz8gdHJ1ZTtcblxuICAgIGNvbnN0IHJlZ2lzdHJpZXMgPSBvcHRpb25zLnJlZ2lzdHJpZXMgPyBrZWJhYkNhc2VLZXlzKG9wdGlvbnMucmVnaXN0cmllcykgOiB1bmRlZmluZWQ7XG5cbiAgICB0aGlzLmNvbmZpZyA9IHtcbiAgICAgIHZlcnNpb246IDIsXG4gICAgICByZWdpc3RyaWVzLFxuICAgICAgdXBkYXRlczogW1xuICAgICAgICB7XG4gICAgICAgICAgJ3BhY2thZ2UtZWNvc3lzdGVtJzogJ25wbScsXG4gICAgICAgICAgJ3ZlcnNpb25pbmctc3RyYXRlZ3knOiAnbG9ja2ZpbGUtb25seScsXG4gICAgICAgICAgJ2RpcmVjdG9yeSc6ICcvJyxcbiAgICAgICAgICAnc2NoZWR1bGUnOiB7XG4gICAgICAgICAgICBpbnRlcnZhbDogb3B0aW9ucy5zY2hlZHVsZUludGVydmFsID8/IERlcGVuZGFib3RTY2hlZHVsZUludGVydmFsLkRBSUxZLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgJ2lnbm9yZSc6ICgpID0+IHRoaXMuaWdub3JlLmxlbmd0aCA+IDAgPyB0aGlzLmlnbm9yZSA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAnbGFiZWxzJzogb3B0aW9ucy5sYWJlbHMgPyBvcHRpb25zLmxhYmVscyA6IHVuZGVmaW5lZCxcbiAgICAgICAgICAncmVnaXN0cmllcyc6IHJlZ2lzdHJpZXMgPyBPYmplY3Qua2V5cyhyZWdpc3RyaWVzKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfTtcblxuICAgIG5ldyBZYW1sRmlsZShwcm9qZWN0LCAnLmdpdGh1Yi9kZXBlbmRhYm90LnltbCcsIHtcbiAgICAgIG9iajogdGhpcy5jb25maWcsXG4gICAgICBjb21taXR0ZWQ6IHRydWUsXG4gICAgfSk7XG5cbiAgICBmb3IgKGNvbnN0IGkgb2Ygb3B0aW9ucy5pZ25vcmUgPz8gW10pIHtcbiAgICAgIHRoaXMuYWRkSWdub3JlKGkuZGVwZW5kZW5jeU5hbWUsIC4uLihpLnZlcnNpb25zID8/IFtdKSk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaWdub3Jlc1Byb2plbikge1xuICAgICAgdGhpcy5hZGRJZ25vcmUoJ3Byb2plbicpO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkSWdub3JlKGRlcGVuZGVuY3lOYW1lOiBzdHJpbmcsIC4uLnZlcnNpb25zOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuaWdub3JlLnB1c2goe1xuICAgICAgJ2RlcGVuZGVuY3ktbmFtZSc6IGRlcGVuZGVuY3lOYW1lLFxuICAgICAgJ3ZlcnNpb25zJzogKCkgPT4gdmVyc2lvbnMubGVuZ3RoID4gMCA/IHZlcnNpb24gOiB1bmRlZmluZWQsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==