"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SET_GIT_IDENTITY_WORKFLOW_STEP = exports.GITHUB_ACTIONS_USER = void 0;
/**
 * Represents the github-actions user.
 *
 * Use this when you need to perform a commit as part of your workflow.
 */
exports.GITHUB_ACTIONS_USER = {
    name: 'github-actions',
    email: 'github-actions@github.com',
};
/**
 * Workflow flow to configure git with the github actions identity.
 */
exports.SET_GIT_IDENTITY_WORKFLOW_STEP = {
    name: 'Set git identity',
    run: [
        `git config user.name "${exports.GITHUB_ACTIONS_USER.name}"`,
        `git config user.email "${exports.GITHUB_ACTIONS_USER.email}"`,
    ].join('\n'),
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dpdGh1Yi9jb25zdGFudHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7Ozs7R0FJRztBQUNVLFFBQUEsbUJBQW1CLEdBQUc7SUFDakMsSUFBSSxFQUFFLGdCQUFnQjtJQUN0QixLQUFLLEVBQUUsMkJBQTJCO0NBQ25DLENBQUM7QUFFRjs7R0FFRztBQUNVLFFBQUEsOEJBQThCLEdBQXFCO0lBQzlELElBQUksRUFBRSxrQkFBa0I7SUFDeEIsR0FBRyxFQUFFO1FBQ0gseUJBQXlCLDJCQUFtQixDQUFDLElBQUksR0FBRztRQUNwRCwwQkFBMEIsMkJBQW1CLENBQUMsS0FBSyxHQUFHO0tBQ3ZELENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztDQUNiLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyB3b3JrZmxvdyBmcm9tICcuL3dvcmtmbG93cy1tb2RlbCc7XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgZ2l0aHViLWFjdGlvbnMgdXNlci5cbiAqXG4gKiBVc2UgdGhpcyB3aGVuIHlvdSBuZWVkIHRvIHBlcmZvcm0gYSBjb21taXQgYXMgcGFydCBvZiB5b3VyIHdvcmtmbG93LlxuICovXG5leHBvcnQgY29uc3QgR0lUSFVCX0FDVElPTlNfVVNFUiA9IHtcbiAgbmFtZTogJ2dpdGh1Yi1hY3Rpb25zJyxcbiAgZW1haWw6ICdnaXRodWItYWN0aW9uc0BnaXRodWIuY29tJyxcbn07XG5cbi8qKlxuICogV29ya2Zsb3cgZmxvdyB0byBjb25maWd1cmUgZ2l0IHdpdGggdGhlIGdpdGh1YiBhY3Rpb25zIGlkZW50aXR5LlxuICovXG5leHBvcnQgY29uc3QgU0VUX0dJVF9JREVOVElUWV9XT1JLRkxPV19TVEVQOiB3b3JrZmxvdy5Kb2JTdGVwID0ge1xuICBuYW1lOiAnU2V0IGdpdCBpZGVudGl0eScsXG4gIHJ1bjogW1xuICAgIGBnaXQgY29uZmlnIHVzZXIubmFtZSBcIiR7R0lUSFVCX0FDVElPTlNfVVNFUi5uYW1lfVwiYCxcbiAgICBgZ2l0IGNvbmZpZyB1c2VyLmVtYWlsIFwiJHtHSVRIVUJfQUNUSU9OU19VU0VSLmVtYWlsfVwiYCxcbiAgXS5qb2luKCdcXG4nKSxcbn07XG4iXX0=