"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoMerge = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Sets up mergify to merging approved pull requests.
 *
 * If `buildJob` is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 *
 * `approvedReviews` specified the number of code review approvals required for
 * the PR to be merged.
 *
 * @experimental
 */
class AutoMerge extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c;
        super(github.project);
        const mergify = github.mergify;
        if (!mergify) {
            throw new Error('auto merging requires mergify to be enabled');
        }
        const successfulBuild = options.buildJob
            ? [`status-success=${options.buildJob}`]
            : [];
        const blockingLabels = (_b = options.blockingLabels) !== null && _b !== void 0 ? _b : ['do-not-merge'];
        const blockingCondition = (blockingLabels === null || blockingLabels === void 0 ? void 0 : blockingLabels.length) ? [`-label~=(${blockingLabels.join('|')})`]
            : [];
        const mergeAction = {
            merge: {
                // squash all commits into a single commit when merging
                method: 'squash',
                // use PR title+body as the commit message
                commit_message: 'title+body',
                // update PR branch so it's up-to-date before merging
                strict: 'smart',
                strict_method: 'merge',
            },
            delete_head_branch: {},
        };
        const approvedReviews = (_c = options.approvedReviews) !== null && _c !== void 0 ? _c : 1;
        mergify.addRule({
            name: 'Automatic merge on approval and successful build',
            actions: mergeAction,
            conditions: [
                `#approved-reviews-by>=${approvedReviews}`,
                ...blockingCondition,
                ...successfulBuild,
            ],
        });
        this.project.addPackageIgnore('/.mergify.yml');
    }
}
exports.AutoMerge = AutoMerge;
_a = JSII_RTTI_SYMBOL_1;
AutoMerge[_a] = { fqn: "projen.github.AutoMerge", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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