"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_model_1 = require("./workflows-model");
/**
 * (experimental) Auto approve pull requests that meet a criteria.
 *
 * @experimental
 */
class AutoApprove extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c;
        super(github.project);
        this.label = (_b = options.label) !== null && _b !== void 0 ? _b : 'auto-approve';
        const usernames = (_c = options.allowedUsernames) !== null && _c !== void 0 ? _c : ['github-actions[bot]'];
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += ' && (';
            condition += usernames.map(u => `github.event.pull_request.user.login == '${u}'`).join(' || ');
            condition += ')';
        }
        const approveJob = {
            runsOn: 'ubuntu-latest',
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [{
                    uses: 'hmarr/auto-approve-action@v2.1.0',
                    with: {
                        'github-token': `\${{ secrets.${options.secret} }}`,
                    },
                }],
        };
        const workflow = github.addWorkflow('auto-approve');
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: ['labeled', 'opened', 'synchronize', 'reopened', 'ready_for_review'],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,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