"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitAttributesFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * (experimental) Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 * @experimental
 */
class GitAttributesFile extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project) {
        super(project, '.gitattributes', {
            editGitignore: false,
        });
        this.attributes = new Map();
    }
    /**
     * (experimental) Maps a set of attributes to a set of files.
     *
     * @param glob Glob pattern to match files in the repo.
     * @param attributes Attributes to assign to these files.
     * @experimental
     */
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries())
            .sort(([l], [r]) => l.localeCompare(r));
        if (entries.length === 0) {
            return undefined;
        }
        const maxLen = Math.max(...entries.map(([glob]) => glob.length));
        return [
            `# ${file_1.FileBase.PROJEN_MARKER}`,
            '',
            ...entries.map(([name, attributes]) => `${name.padEnd(maxLen, ' ')}\t${Array.from(attributes).join(' ')}`),
        ].join('\n');
    }
}
exports.GitAttributesFile = GitAttributesFile;
_a = JSII_RTTI_SYMBOL_1;
GitAttributesFile[_a] = { fqn: "projen.git.GitAttributesFile", version: "0.29.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0YXR0cmlidXRlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9naXQvZ2l0YXR0cmlidXRlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGtDQUE4Qzs7Ozs7OztBQUk5QyxNQUFhLGlCQUFrQixTQUFRLGVBQVE7Ozs7SUFHN0MsWUFBbUIsT0FBZ0I7UUFDakMsS0FBSyxDQUFDLE9BQU8sRUFBRSxnQkFBZ0IsRUFBRTtZQUMvQixhQUFhLEVBQUUsS0FBSztTQUNyQixDQUFDLENBQUM7UUFMWSxlQUFVLEdBQUcsSUFBSSxHQUFHLEVBQXVCLENBQUM7SUFNN0QsQ0FBQzs7Ozs7Ozs7SUFHTSxhQUFhLENBQUMsSUFBWSxFQUFFLEdBQUcsVUFBb0I7UUFDeEQsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQzlCLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxJQUFJLEdBQUcsRUFBRSxDQUFDLENBQUM7U0FDdEM7UUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUUsQ0FBQztRQUN2QyxLQUFLLE1BQU0sU0FBUyxJQUFJLFVBQVUsRUFBRTtZQUNsQyxHQUFHLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1NBQ3BCO0lBQ0gsQ0FBQzs7Ozs7O0lBRVMsaUJBQWlCLENBQUMsQ0FBWTtRQUN0Qyw2Q0FBNkM7UUFDN0MsTUFBTSxPQUFPLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxDQUFDO2FBQ2xELElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRTFDLElBQUksT0FBTyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDeEIsT0FBTyxTQUFTLENBQUM7U0FDbEI7UUFFRCxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ2pFLE9BQU87WUFDTCxLQUFLLGVBQVEsQ0FBQyxhQUFhLEVBQUU7WUFDN0IsRUFBRTtZQUNGLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxLQUFLLEtBQUssQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7U0FDM0csQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDZixDQUFDOztBQW5DSCw4Q0FvQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJUmVzb2x2ZXIsIEZpbGVCYXNlIH0gZnJvbSAnLi4vZmlsZSc7XG5pbXBvcnQgeyBQcm9qZWN0IH0gZnJvbSAnLi4vcHJvamVjdCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgR2l0QXR0cmlidXRlc0ZpbGUgZXh0ZW5kcyBGaWxlQmFzZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgYXR0cmlidXRlcyA9IG5ldyBNYXA8c3RyaW5nLCBTZXQ8c3RyaW5nPj4oKTtcblxuICBwdWJsaWMgY29uc3RydWN0b3IocHJvamVjdDogUHJvamVjdCkge1xuICAgIHN1cGVyKHByb2plY3QsICcuZ2l0YXR0cmlidXRlcycsIHtcbiAgICAgIGVkaXRHaXRpZ25vcmU6IGZhbHNlLFxuICAgIH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkQXR0cmlidXRlcyhnbG9iOiBzdHJpbmcsIC4uLmF0dHJpYnV0ZXM6IHN0cmluZ1tdKSB7XG4gICAgaWYgKCF0aGlzLmF0dHJpYnV0ZXMuaGFzKGdsb2IpKSB7XG4gICAgICB0aGlzLmF0dHJpYnV0ZXMuc2V0KGdsb2IsIG5ldyBTZXQoKSk7XG4gICAgfVxuICAgIGNvbnN0IHNldCA9IHRoaXMuYXR0cmlidXRlcy5nZXQoZ2xvYikhO1xuICAgIGZvciAoY29uc3QgYXR0cmlidXRlIG9mIGF0dHJpYnV0ZXMpIHtcbiAgICAgIHNldC5hZGQoYXR0cmlidXRlKTtcbiAgICB9XG4gIH1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUNvbnRlbnQoXzogSVJlc29sdmVyKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgICAvLyBXZSBjYW4gYXNzdW1lIHRoZSBmaWxlIG1hcCBpcyBuZXZlciBlbXB0eS5cbiAgICBjb25zdCBlbnRyaWVzID0gQXJyYXkuZnJvbSh0aGlzLmF0dHJpYnV0ZXMuZW50cmllcygpKVxuICAgICAgLnNvcnQoKFtsXSwgW3JdKSA9PiBsLmxvY2FsZUNvbXBhcmUocikpO1xuXG4gICAgaWYgKGVudHJpZXMubGVuZ3RoID09PSAwKSB7XG4gICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgIH1cblxuICAgIGNvbnN0IG1heExlbiA9IE1hdGgubWF4KC4uLmVudHJpZXMubWFwKChbZ2xvYl0pID0+IGdsb2IubGVuZ3RoKSk7XG4gICAgcmV0dXJuIFtcbiAgICAgIGAjICR7RmlsZUJhc2UuUFJPSkVOX01BUktFUn1gLFxuICAgICAgJycsXG4gICAgICAuLi5lbnRyaWVzLm1hcCgoW25hbWUsIGF0dHJpYnV0ZXNdKSA9PiBgJHtuYW1lLnBhZEVuZChtYXhMZW4sICcgJyl9XFx0JHtBcnJheS5mcm9tKGF0dHJpYnV0ZXMpLmpvaW4oJyAnKX1gKSxcbiAgICBdLmpvaW4oJ1xcbicpO1xuICB9XG59XG4iXX0=